﻿-- ##############################################
-- #	Custom Info Trigger						#
-- #	version: 1.2							#
-- #	Date: 28.01.2013						#
-- #	author: [FSM]Webby						#
-- # 	Keine Veränderung ohne					# 
-- # 	meine Erlaubnis!						#
-- # 	No modification without					# 
-- # 	my permission!							#
-- #											#
-- #	MEGA THX 2:								#
-- #											#
-- #	Bluebaby210								#
-- #	Fiat80-90DT								#
-- #	webalizer								#
-- #	@planet-ls.de							#
-- #											#
-- #	4 helping me out 						#
-- #	with this Script						#
-- #											#
-- #	History:								#
-- #	v1.0 = Projekt started					#
-- #	v1.1 = Nomore HelpIcons in MP			#
-- #	v1.2 = variable TimeToShow				#
-- #											#
-- ############################################## 


-- This Script is based on the InfospotTrigger class! Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.


customInfoTrigger = {}

local customInfoTrigger_mt = Class(customInfoTrigger); 

function customInfoTrigger.onCreate(id)
	g_currentMission:addUpdateable(customInfoTrigger:new(id));
end;

function customInfoTrigger:new(id)
	local instance = {};
	setmetatable(instance, customInfoTrigger_mt);

	instance.triggerId = id;
	addTrigger(id, "triggerCallback", instance);
	
	instance.infoSymbol = getChildAt(id, 0);		
	local x, y, z = getTranslation(instance.infoSymbol);
	instance.posY = y;
	instance.jump = 0.08;
	
	instance.isEnabled = true;
 	instance.textInfo = getUserAttribute(id, "InfoField");
	instance.timeToShow = getUserAttribute(id, "TimeToShow");
	instance.playerInTrigger = false;
	
	instance.timer = 0;
	instance.timerBackup = 0;
	instance.startTimer = false;
	
	if (g_server ~= nil and g_server .netIsRunning or g_client ~= nil and g_client.netIsRunning) then
		instance.isEnabled = false;
		setVisibility(instance.triggerId, false);
	end;
	
	return instance;

end;

function customInfoTrigger:delete()
	removeTrigger(self.triggerId);
end;

function customInfoTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and self.isEnabled then 
		if (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) or (g_currentMission.controlledVehicle ~= nil and otherId == g_currentMission.controlledVehicle.components[1].node) then
			self.isEnabled = false;
			self.playerInTrigger = true;
		end;
	elseif onLeave then
		if (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) or (g_currentMission.controlledVehicle ~= nil and otherId == g_currentMission.controlledVehicle.components[1].node) then
			self.playerInTrigger = false;
		end;
	end;
end;

function customInfoTrigger:update(dt)

	if self.isEnabled then
		rotate(self.infoSymbol, 0, 0.002 * dt, 0);		
		self.jump = self.jump - 0.0002 * dt;
		local x, y, z = getTranslation(self.infoSymbol);
		setTranslation(self.infoSymbol, x, y + self.jump, z);
		
		if y + self.jump <= self.posY then
		self.jump = 0.08;
		end;
	end;
	--
	
	if self.playerInTrigger then
		self.startTimer = true;
		setVisibility(self.triggerId, false);
	end;

	if self.startTimer then
		self.timer = self.timer + dt;
			if self.timer >= 2 and self.timer <= self.timeToShow then
				g_currentMission:addWarning(g_i18n:getText(self.textInfo), 0.09, 0.03)
			elseif self.timer >= self.timeToShow then 
				self.startTimer = false;
				self.timer = self.timerBackup;
			end;
	end;
	
end;

g_onCreateUtil.addOnCreateFunction("customInfoTriggerOnCreate", customInfoTrigger.onCreate);
