-- Rolltor
-- @author: grafik-edv
-- @date: 12.12.2012

   
  Rolltor = {};
  
  local Rolltor_mt = Class(Rolltor);
  
  function Rolltor.onCreate(id)
      g_currentMission:addUpdateable(Rolltor:new(id));
      --print("created tip trigger, id: ", id);
  end;
  
  function Rolltor:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, Rolltor_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.barriers = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local barrierId = getChildAt(childLevel1, 0);
              if barrierId ~= 0 then
                  table.insert(instance.barriers, barrierId);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 14;
      self.minTrans = 0;
  
      return instance;
  end;
  
  function Rolltor:delete()
 
      removeTrigger(self.triggerId);
  end;
  
  function Rolltor:update(dt)
      
      local old = self.trans;
      if self.count > 0 then
          if self.trans < self.maxTrans then
              self.trans = self.trans + dt*0.010;    
          end;
     else
          if self.trans > self.minTrans then
              self.trans = self.trans - dt*0.005;    
          end;
      end;
      
      if old ~= self.trans then
          for i=1, table.getn(self.barriers) do
              setTranslation(self.barriers[i], self.trans, 0, 0);
          end;
      end;
      
  end;
  
  function Rolltor:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("RolltorOnCreate", Rolltor.onCreate);




-- Tor_Kuhstall
-- @author: grafik-edv
-- @date: 12.12.2012

   
  Tor_Kuhstall = {};
  
  local Tor_Kuhstall_mt = Class(Tor_Kuhstall);
  
  function Tor_Kuhstall.onCreate(id)
      g_currentMission:addUpdateable(Tor_Kuhstall:new(id));
      --print("created tip trigger, id: ", id);
  end;
  
  function Tor_Kuhstall:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, Tor_Kuhstall_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.barriers = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local barrierId = getChildAt(childLevel1, 0);
              if barrierId ~= 0 then
                  table.insert(instance.barriers, barrierId);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 4.1;
      self.minTrans = 0;
  
      return instance;
  end;
  
  function Tor_Kuhstall:delete()
 
      removeTrigger(self.triggerId);
  end;
  
  function Tor_Kuhstall:update(dt)
      
      local old = self.trans;
      if self.count > 0 then
          if self.trans < self.maxTrans then
              self.trans = self.trans + dt*0.003;    
          end;
     else
          if self.trans > self.minTrans then
              self.trans = self.trans - dt*0.003;    
          end;
      end;
      
      if old ~= self.trans then
          for i=1, table.getn(self.barriers) do
              setTranslation(self.barriers[i], self.trans, 0, 0);
          end;
      end;
      
  end;
  
  function Tor_Kuhstall:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("Tor_KuhstallOnCreate", Tor_Kuhstall.onCreate);







-- Torklein_Kuhstall
-- @author: grafik-edv
-- @date: 12.12.2012

   
  Torklein_Kuhstall = {};
  
  local Torklein_Kuhstall_mt = Class(Torklein_Kuhstall);
  
  function Torklein_Kuhstall.onCreate(id)
      g_currentMission:addUpdateable(Torklein_Kuhstall:new(id));
      --print("created tip trigger, id: ", id);
  end;
  
  function Torklein_Kuhstall:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, Torklein_Kuhstall_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.barriers = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local barrierId = getChildAt(childLevel1, 0);
              if barrierId ~= 0 then
                  table.insert(instance.barriers, barrierId);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 3.7;
      self.minTrans = 0;
  
      return instance;
  end;
  
  function Torklein_Kuhstall:delete()
 
      removeTrigger(self.triggerId);
  end;
  
  function Torklein_Kuhstall:update(dt)
      
      local old = self.trans;
      if self.count > 0 then
          if self.trans < self.maxTrans then
              self.trans = self.trans + dt*0.003;    
          end;
     else
          if self.trans > self.minTrans then
              self.trans = self.trans - dt*0.003;    
          end;
      end;
      
      if old ~= self.trans then
          for i=1, table.getn(self.barriers) do
              setTranslation(self.barriers[i], self.trans, 0, 0);
          end;
      end;
      
  end;
  
  function Torklein_Kuhstall:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("Torklein_KuhstallOnCreate", Torklein_Kuhstall.onCreate);