--
-- Maxxum
-- This is the specialization for Maxxum
--
-- M@D Author  Headshot XXL
-- M@D date 13.12.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

Maxxum = {};

function Maxxum.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Maxxum:load(xmlFile)
	

	self.backHydraulic = {};
	self.backHydraulic.hyraulicArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#hyraulicArm"));
	self.backHydraulic.hubhebel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#hubhebel"));
	self.backHydraulic.hubhebelFixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#hubhebelFixpoint"));
	self.backHydraulic.bottomArmFixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArmFixpoint"));	
	local ax, ay, az = getWorldTranslation(self.backHydraulic.hubhebel);
	local bx, by, bz = getWorldTranslation(self.backHydraulic.bottomArmFixpoint);
	self.backHydraulic.hubhebelLength = Utils.vector3Length(ax-bx, ay-by, az-bz);
	
	self.frontHydraulic = {};
	self.frontHydraulic.bottomArmLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontHydraulic#bottomArmLeft"));
	self.frontHydraulic.bottomArmRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontHydraulic#bottomArmRight"));	
	local x,y,z = getTranslation(self.frontHydraulic.bottomArmLeft);
	self.frontHydraulic.bottomArmLeftTranslation = {x,y,z};
	local x,y,z = getTranslation(self.frontHydraulic.bottomArmRight);
	self.frontHydraulic.bottomArmRightTranslation = {x,y,z};	
	
	local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", 0);
	self.TAJindex = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#moveIndex"));
	if self.TAJindex ~= nil then
		self.TAJmoveMin = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#moveMin"),0);
		self.TAJmoveMax = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#moveMax"),0);
	end;		
	
	self.brakeForce = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeForce"), 10);
	self.backupMotorBrakeForce = self.motor.brakeForce;
	
    self.revLimit = 100;
	self.maxRpm1 = self.motor.maxRpm[1];
	self.maxRpm2 = self.motor.maxRpm[2];
    self.maxRpm3 = self.motor.maxRpm[3];
	self.brakeOn = true;
	self.implementsLower = false;	
	
	self.HudHelpWidth = 0.437-0.012;
	self.HudHelpHeight = 0.1625;
	self.HudHelpPosX = 0.012;
	self.HudHelpPosY = 1-0.99;
	self.HudHelpTextPosX = 0.405;
	self.HudHelpTextPosY = 0.356;
	self.HudHelpOverlay = Overlay:new("helpPanel", Utils.getFilename("ApHud.png", self.baseDirectory), self.HudHelpPosX, self.HudHelpPosY, self.HudHelpWidth, self.HudHelpHeight);
	self.HudHelpActive = true;
	
end;

function Maxxum:delete()
end;

function Maxxum:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_KP_0 then
        self.HudHelpActive = not self.HudHelpActive;
    end;	

end;

function Maxxum:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Maxxum:update(dt)

    if self.isEntered then
		
		if Input.isKeyPressed(Input.KEY_shift) and InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self.implementsLower = true;
		end;

		
        if InputBinding.isPressed(InputBinding.MAXXUM_REVUP) and self.revLimit < 100 then
			self.revLimit = self.revLimit + 1;
        elseif InputBinding.isPressed(InputBinding.MAXXUM_REVDOWN) and self.revLimit > 1 then
			self.revLimit = self.revLimit - 1;
        end;
		self.motor.maxRpm[1] = string.format("%d",(self.revLimit * self.maxRpm1 / 100));
		self.motor.maxRpm[2] = string.format("%d",(self.revLimit * self.maxRpm2 / 100));
        self.motor.maxRpm[3] = string.format("%d",(self.revLimit * self.maxRpm3 / 100));
		self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
		if InputBinding.isAxisZero(self.input) then
			self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
		end;
		if InputBinding.hasEvent(InputBinding.MAXXUM_BRAKE) then
			self.brakeOn = not self.brakeOn;
		end;
		if not self.brakeOn then
			self.brakeOn = false;
			local brake = false;
			if self.motor.brakeForce == self.brakeForce and self.input ~= 0 then
				brake = true;
				self.motor.maxRpm[1] = 0;
				self.motor.maxRpm[2] = 0;
				self.motor.maxRpm[3] = 0;
			end;
			if (self.movingDirection*self.lastSpeed*(-self.input)) < -0.0001 then
				brake = true;
				self.motor.brakeForce = self.brakeForce;
			elseif not brake then
				self.motor.brakeForce = self.backupMotorBrakeForce;
			end;	
		else
			self.motor.brakeForce = self.brakeForce;
		end;
		
		
		self.jointmove = false;		
		local x,y,z = getTranslation(self.TAJindex);		
		if InputBinding.isPressed(InputBinding.MAXXUM_MOVEUP) and y < self.TAJmoveMax then
			y = y + 0.01;
			self.jointmove = true;	
        elseif InputBinding.isPressed(InputBinding.MAXXUM_MOVEDOWN) and y > self.TAJmoveMin then
			y = y - 0.01;
			self.jointmove = true;	
        end;
		setTranslation(self.TAJindex, x,y,z);
		


		if self.backHydraulic ~= nil then
			local ax, ay, az = getWorldTranslation(self.backHydraulic.hubhebel);
			local bx, by, bz = getWorldTranslation(self.backHydraulic.bottomArmFixpoint);			
			local x, y, z = worldDirectionToLocal(self.backHydraulic.hyraulicArm, bx-ax, by-ay, bz-az);
			setDirection(self.backHydraulic.hubhebel, x, y, z, 0, 0, 1);			
			local hubhebelLength = Utils.vector3Length(ax-bx, ay-by, az-bz);	
			local length = 	hubhebelLength - self.backHydraulic.hubhebelLength;
			local alpha = math.atan2(0.188,length);			
			setRotation(self.backHydraulic.hyraulicArm, alpha,0,0);
			setScale(self.backHydraulic.hubhebel, 1, 1, 1+length);
		end;

		
		if table.getn(self.attachedImplements) > 0 and self.implementsLower then
			for i=1, table.getn(self.attachedImplements) do
				if self.attachedImplements[i].object.allowsLowering then
					local jointDesc = self.attacherJoints[self.attachedImplements[i].jointDescIndex];
					if jointDesc.allowsLowering and self.selectedImplement ~= i then
						jointDesc.moveDown = not jointDesc.moveDown;
					end;
				end;
				if i == table.getn(self.attachedImplements) then
					self.implementsLower = false;
				end;
			end;
		end;
		
		if self.attacherJoints[2].jointIndex ~= 0 then
			setTranslation(self.frontHydraulic.bottomArmLeft, -0.02213, self.frontHydraulic.bottomArmLeftTranslation[2], self.frontHydraulic.bottomArmLeftTranslation[3]);
			setTranslation(self.frontHydraulic.bottomArmRight, 0.04122, self.frontHydraulic.bottomArmRightTranslation[2], self.frontHydraulic.bottomArmRightTranslation[3]);
		else
			setTranslation(self.frontHydraulic.bottomArmLeft, unpack(self.frontHydraulic.bottomArmLeftTranslation));
			setTranslation(self.frontHydraulic.bottomArmRight, unpack(self.frontHydraulic.bottomArmRightTranslation));
		end;	
		
    end;
end;

function Maxxum:draw()


	self:addSubSettings("Maxxum","Case IH Maxxum",InputBinding.MAXXUM_subHud);
	if self.isEntered then
		self:addSubText( InputBinding.getButtonKeyName(InputBinding.MAXXUM_BRAKE).." : Handbremse")
		self:addSubText( "Tasten -/+: "..string.format("%d Prozent Drehzahlbegrenzer", self.revLimit))			
		self:addSubText( "Taste "..InputBinding.getButtonKeyName(InputBinding.IGNITION)..": Motor starten/abstellen");			
		self:addSubText( "Taste "..InputBinding.getButtonKeyName(InputBinding.WORKLIGHTS)..": Arbeitslicht");			
		self:addSubText( "Taste Shift+"..InputBinding.getButtonKeyName(InputBinding.LOWER_IMPLEMENT)..": Anbaugeraete Gleichzeitig heben und senken");
		self:addSubText( "Taste "..InputBinding.getButtonKeyName(InputBinding.MAXXUM_MOVEUP).." / "..InputBinding.getButtonKeyName(InputBinding.MAXXUM_MOVEDOWN)..": Anhaengerkupplung heben und senken");			
	end;
	
	if self.brakeOn then
		setTextColor(1.0, 0.8, 0.0, 1.0);
	else
		setTextColor(1.0, 1.0, 1.0, 1.0);
	end;
	renderText(0.8335, 0.15, 0.02, "Tasten -/+: "..string.format("%d Prozent", self.revLimit));
	setTextColor(1.0, 1.0, 1.0, 1.0);
	
end;

function Maxxum:validateAttacherJoint(implement, jointDesc, dt)
	if self.jointmove then
		return true;
	end;
end;
