--
-- ToggleDriver
-- Specialization for ToggleDriver
--
-- @author  	71biTi (Shed Tuning System, STS)
-- @version 	v1.0
-- @date  		21/12/12
-- @history:	v1.0 - Initial version
--

ToggleDriver = {};

function ToggleDriver.prerequisitesPresent(specializations)
    return true;
end;

function ToggleDriver:load(xmlFile)	

	self.setDriver = SpecializationUtil.callSpecializationsFunction("setDriver");

	self.driver1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivers#index1"));
	self.driver2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivers#index2"));
	self.driverId = 0;
end;

function ToggleDriver:delete()
end;

function ToggleDriver:readStream(streamId, connection)
	self:setDriver(streamReadInt8(streamId), true);
end;

function ToggleDriver:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.driverId);	
end;

function ToggleDriver:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ToggleDriver:keyEvent(unicode, sym, modifier, isDown)
end;

function ToggleDriver:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.Toggle_Drivers) then
				self:setDriver(math.abs(self.driverId - 1));
			end;
		end;
	end;
end;

function ToggleDriver:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Toggle_driver"), InputBinding.Toggle_Drivers);
end;

function ToggleDriver:setDriver(driver, noEventSend)
	ToggleDriverEvent.sendEvent(self, driver, noEventSend);

	setVisibility(self.driver1, driver == 0);
	setVisibility(self.driver2, driver == 1);
	self.driverId = driver;
end;

function ToggleDriver:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self:setDriver(Utils.getNoNil(getXMLInt(xmlFile, key.."#driverId"),0), true);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ToggleDriver:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'driverId="'.. tostring(self.driverId) .. '"';
    return attributes, nil;
end;





ToggleDriverEvent = {};
ToggleDriverEvent_mt = Class(ToggleDriverEvent, Event);

InitEventClass(ToggleDriverEvent, "ToggleDriverEvent");

function ToggleDriverEvent:emptyNew()
    local self = Event:new(ToggleDriverEvent_mt);
    return self;
end;

function ToggleDriverEvent:new(vehicle, driver)
    local self = ToggleDriverEvent:emptyNew()
    self.vehicle = vehicle;
	self.driver = driver;
    return self;
end;

function ToggleDriverEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.driver = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ToggleDriverEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.driver);	
end;

function ToggleDriverEvent:run(connection)
	self.vehicle:setDriver(self.driver, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ToggleDriverEvent:new(self.vehicle, self.driver), nil, connection, self.vehicle);
	end;
end;

function ToggleDriverEvent.sendEvent(vehicle, driver, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ToggleDriverEvent:new(vehicle, driver), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ToggleDriverEvent:new(vehicle, driver));
		end;
	end;
end;
