--
-- FendtFork
-- Specialization for FendtFork
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		19/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--

FendtFork = {};

function FendtFork.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function FendtFork:load(xmlFile)	

	self.setFork = SpecializationUtil.callSpecializationsFunction("setFork");

	self.fork1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forks#index1"));
	self.fork2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forks#index2"));
	self.forkId = 0;
end;

function FendtFork:delete()
end;

function FendtFork:readStream(streamId, connection)
	self:setFork(streamReadInt8(streamId), true);
end;

function FendtFork:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.forkId);	
end;

function FendtFork:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FendtFork:keyEvent(unicode, sym, modifier, isDown)
end;

function FendtFork:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.Toggle_Forks) then
				self:setFork(math.abs(self.forkId - 1));
			end;
		end;
	end;
end;

function FendtFork:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Toggle_fork"), InputBinding.Toggle_Forks);
end;

function FendtFork:setFork(fork, noEventSend)
	FendtForkEvent.sendEvent(self, fork, noEventSend);

	setVisibility(self.fork1, fork == 0);
	setVisibility(self.fork2, fork == 1);
	self.forkId = fork;
end;

function FendtFork:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self:setFork(Utils.getNoNil(getXMLInt(xmlFile, key.."#forkId"),0), true);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function FendtFork:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'forkId="'.. tostring(self.forkId) .. '"';
    return attributes, nil;
end;





FendtForkEvent = {};
FendtForkEvent_mt = Class(FendtForkEvent, Event);

InitEventClass(FendtForkEvent, "FendtForkEvent");

function FendtForkEvent:emptyNew()
    local self = Event:new(FendtForkEvent_mt);
    return self;
end;

function FendtForkEvent:new(vehicle, fork)
    local self = FendtForkEvent:emptyNew()
    self.vehicle = vehicle;
	self.fork = fork;
    return self;
end;

function FendtForkEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.fork = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function FendtForkEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.fork);	
end;

function FendtForkEvent:run(connection)
	self.vehicle:setFork(self.fork, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(FendtForkEvent:new(self.vehicle, self.fork), nil, connection, self.vehicle);
	end;
end;

function FendtForkEvent.sendEvent(vehicle, fork, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(FendtForkEvent:new(vehicle, fork), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(FendtForkEvent:new(vehicle, fork));
		end;
	end;
end;
