--
-- Specialization for Blinker mod
--
-- @autor Sebastian B. (Blancker, www.landwirtschaftssimualtor-2009.de)
--
-- @update 15/09/09
--

StVO = {};

function StVO.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function StVO:load(xmlFile)
--[[Bremslicht start]]--
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;	
--[[Bremslicht ende]]--
end;

function StVO:delete()
end;

function StVO:mouseEvent(posX, posY, isDown, isUp, button)
end;

function StVO:keyEvent(unicode, sym, modifier, isDown)
end;

function StVO:update(dt)
--[[Bremslicht start]]--
    inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);	
    if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;
	if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;	
	end;
--[[Bremslicht ende]]--
end;

function StVO:draw()
end;

function StVO:onLeave()
end;