LamborghiniR8 = {};

function LamborghiniR8.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function LamborghiniR8:load(xmlFile)

	local nummarkAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.markAreas#count"), 0);
    self.markAreas = {}
    for i=1, nummarkAreas do
        self.markAreas[i] = {};
        local areanamei = string.format("vehicle.markAreas.markAreas%d", i);
        self.markAreas[i].point = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#pointIndex"));
        self.markAreas[i].width = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#width"), 0.55)
        self.markAreas[i].height = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#height"), 0.25)
    end;

--[[    self.radioCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.radio#count"),0);
	self.radioVolume = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.radio#volume"),0);
    self.radioOn = false;
    self.radio = {};
	self.currentSong = 1;
    for i=1, self.radioCount do
        local objname = string.format("vehicle.radio.song" .. "%d",i);
        self.radio[i] = {};
        local filename = Utils.getFilename(getXMLString(xmlFile, objname .. "#filename"),self.baseDirectory);
		self.radio[i].song = createSample(string.format("track" .. "%d",i));
		loadSample(self.radio[i].song, filename, false);
    end;
	self.songPlayed = false;]]

    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
    self.ignitionKey = false;
	self.allowedIgnition = false;                                                  
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);	
	
	self.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    self.twinWheels = {};
    for i=1, self.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        self.twinWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(self.twinWheels[i], false);
    end;	

    self.brakeForce = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeForce"), 10);
    self.motorBrakeForce = self.motor.brakeForce;

    local brakeSound = getXMLString(xmlFile, "vehicle.brakeSound#file");
    if brakeSound ~= nil and brakeSound ~= "" then
	  brakeSound = Utils.getFilename(brakeSound, self.baseDirectory); 
        self.brakeSound = createSample("brakeSound");
        loadSample(self.brakeSound, brakeSound, false);
        self.brakeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound#pitchOffset"), 0);
    end;

    self.lightsbrake = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.brake#index"));

    self.exhaustParticleLow = {};
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleLow, "vehicle.exhaustParticleLow", self.rootNode, false, nil, self.baseDirectory);
    self.exhaustParticleHigh = {};
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleHigh, "vehicle.exhaustParticleHigh", self.rootNode, false, nil, self.baseDirectory);

	self.trailerAttacherJoints = {};
      local obj = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", 0);
      self.TAJindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, obj.. "#index"));
      self.TAJdomv = Utils.getNoNil(getXMLBool(xmlFile, obj.. "#moveable"),false);
	if self.TAJdomv then
      self.TAJminY = Utils.getNoNil(getXMLFloat(xmlFile, obj.. "#minY"),0);
      self.TAJmaxY = Utils.getNoNil(getXMLFloat(xmlFile, obj.. "#maxY"),0);
	end;

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    self.Joint = self.TAJindex;
    self.trailerAttacherJointIndex = 0;
    self.attachedTrailer = nil;

    self.mirrors = {};
    self.mirrors[1] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrors.mirror1#index"));
    self.mirrors[2] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrors.mirror2#index"));
    self.twinWheelsActive= false;
    self.drawMirror = getVisibility(self.mirrors[1])
    self.brakeOn = false;
    self.rearlightActive = false;
    self.revLimit = 100;
    self.maxRpm3 = self.motor.maxRpm[3];
    self.activeTAJ = 0;

end;

function LamborghiniR8:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == self.keys.rundumleuchte then
      self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
    
	if isDown and sym == self.keys.twinWheels then 
		self.twinWheelsActive = not self.twinWheelsActive;
	end;	
    
    if isDown and sym == self.keys.spiegel then
    	self.drawMirror = not self.drawMirror;
    	setVisibility(self.mirrors[1], self.drawMirror);
    	setVisibility(self.mirrors[2], self.drawMirror);
    end;
	
--[[	if isDown and sym == Input.KEY_f5 then
		self.radioOn = not self.radioOn;
	end;
	
	if isDown and sym == Input.KEY_f6 then
		stopSample(self.radio[self.currentSong].song);
		self.songPlayed = false;
		if self.currentSong >= self.radioCount then
			self.currentSong = 1;
		else
			self.currentSong = self.currentSong + 1;
		end;
	end;
	
	if isDown and sym == Input.KEY_f7 then
		stopSample(self.radio[self.currentSong].song);
		self.songPlayed = false;
		if self.currentSong <= 1 then
			self.currentSong = self.radioCount;
		else
			self.currentSong = self.currentSong - 1;
		end;
	end;]]	
    
    if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;

end;


function LamborghiniR8:update(dt)
    if self.isEntered then

        if Input.isKeyPressed(self.keys.rev_up) and self.revLimit < 100 then
          self.revLimit = self.revLimit + 1;
        elseif Input.isKeyPressed(self.keys.rev_down) and self.revLimit > 10 then
          self.revLimit = self.revLimit - 1;
        end;
        self.motor.maxRpm[3] = string.format("%d",(self.revLimit * self.maxRpm3 / 100));

        local brake = false;
        if self.motor.brakeForce == self.brakeForce and getInputAxis(Input.AXIS_Y) ~= 0 then
          brake = true;
          self.motor.maxRpm[3] = 0;
        end;
        if (self.movingDirection*self.lastSpeed*(-getInputAxis(Input.AXIS_Y))) < -0.001 then
           brake = true;
           self.brakeOn = true;
           self.motor.brakeForce = self.brakeForce;
        elseif not brake then
           self.motor.brakeForce = self.motorBrakeForce;
        end;
        setVisibility(self.lightsbrake, brake);
        if self.brakeOn and not brake then
            if self.brakeSound ~= nil then
                setSamplePitch(self.brakeSound, self.brakeSoundPitchOffset);
                playSample(self.brakeSound, 1, 1, 0);
            end;
            self.brakeOn = false;
        end;
        if getInputAxis(Input.AXIS_Y) ~= 0 and not brake then
        		Utils.setEmittingState(self.exhaustParticleLow, false);
        		Utils.setEmittingState(self.exhaustParticleHigh, true);
        else
        		Utils.setEmittingState(self.exhaustParticleLow, false);
        		Utils.setEmittingState(self.exhaustParticleHigh, false);
        end;


        if self.attachedTrailer == nil then
            local nearestTrailer = nil;
            local nearestDistance = 0.4;
                local px, py, pz = getWorldTranslation(self.TAJindex);
                for t=1, table.getn(g_currentMission.attachables) do
                    local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[t].attacherJoint);
                    local distance = Utils.vector2Length(px-x, pz-z);
                    if distance < nearestDistance then
                        self.Joint = self.TAJindex;
                        self.activeTAJ = 0;
                        nearestDistance = distance;
                end;
            end;
        end;

        if Input.isKeyPressed(self.keys.moveAK_up) or Input.isKeyPressed(self.keys.moveAK_dn) then
            setJointFrame(self.trailerAttacherJointIndex,0,self.Joint);
            local ymod = 0;
            if Input.isKeyPressed(self.keys.moveAK_up) then ymod = 0.01; else ymod = -0.01; end;
                if self.TAJdomv then
                    local x,y,z = getTranslation(self.TAJindex);
                    y = y + ymod;
                    if y > self.TAJminY and y < self.TAJmaxY then
                        setTranslation(self.TAJindex,x,y,z);
                end;
            end;
        end;
		
	if self.twinWheelsActive then
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive);
		end;
	else
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive, false);
		end;
	end;		

        if self.rundumleuchtenAn then
          for i=1, self.rundumleuchtenAnz do
            rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
          end;
        end;
		
--[[	if self.radioVolume <= 0 then
		self.radioVolume = 0.1;
	end;
	if self.radioOn then
		if not self.songPlayed then
			playSample(self.radio[self.currentSong].song, 1, self.radioVolume, 0);
			self.songKoniec = self.time + getSampleDuration(self.radio[self.currentSong].song);
			self.songPlayed = true;
		end;
		if self.time >= self.songKoniec then
			if self.currentSong == self.radioCount then
				self.currentSong = 1;
			else
				self.currentSong = self.currentSong + 1;
			end;
			self.songPlayed = false;
		end;
	else
		if self.songPlayed then
			stopSample(self.radio[self.currentSong].song, 0, 1, 0);
			self.songPlayed = false;
		end;
	end;	]]	

	if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.FIELDMARKER_mark) then
		self.markOn = not self.markOn;
	end;	
	if self.markOn then		
		for k, markAreas in pairs(self.markAreas) do
	        local x,y,z = getWorldTranslation(markAreas.point);
	        local w = markAreas.width;
	        local h = markAreas.height;
			local x1 = x + h/2
			local x2 = x - h/2
			local z1 = z + w/2
			local z2 = z - w/2			
			Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
			Utils.cutFruitArea( 5, x1, z2, x1, z1, x2, z2);
			Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
			Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
		end;
	end;
	
    if not self.isAITractorActivated then
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.IGNITION) then
		        self.ignitionKey = not self.ignitionKey;
			    self.allowedIgnition = true;
	        end;
	    end;
		
	    if not self.allowedIgnition and  not self.ignitionKey then
            self.isMotorStarted = false;
            Motorized.stopSounds(self);
	        self.steeringEnabled = false;
            Utils.setEmittingState(self.exhaustParticleSystems, false)
	    end;
	
	    if not self.ignitionKey then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
		
	    if self.allowedIgnition then
	        if  not self.ignitionKey then
		        self.motorStopSoundVolume = self.motorStopSoundVolume2;
                self:stopMotor();
			    self.steeringEnabled = false;
                self.allowedIgnition = false;	
		
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                end;
                self:onDeactivateAttachements();
	        elseif self.ignitionKey then
                self:startMotor();
                self.steeringEnabled = true;
                self.allowedIgnition = false;		
       	    end;
	    end;
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;	

end;

end;

function LamborghiniR8:draw()

    if not self.isMotorStarted and not self.automaticStart then	
        g_currentMission:addHelpButtonText(g_i18n:getText("x720_DB_FL_Start"), InputBinding.IGNITION);
	end;

	if self.markOn then
		g_currentMission:addHelpButtonText(g_i18n:getText("FIELDMARKER_1"), (InputBinding.FIELDMARKER_mark)); 
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("FIELDMARKER_2"), (InputBinding.FIELDMARKER_mark)); 
	end;
	
	if self.isEntered then
		if not self.helpPanel then
			renderText(0.8335, 0.15, 0.02, "Taste 0: Info Einschalten");
		else
			renderText(0.8335, 0.15, 0.02, "Taste 0: Info Abschalten");
		end;
		if self.helpPanel then
			renderText(0.72, 0.84, 0.025, "- Deutz Agrotron X720 -");
			renderText(0.72, 0.815, 0.02, "Taste 4: Kupplung Heben");	
			renderText(0.72, 0.8, 0.02, "Taste 5: Kupplung Senken");			
			renderText(0.72, 0.785, 0.02, "Taste 6: Rundumleuchte ein/aus");
			renderText(0.72, 0.77, 0.02, "Tasten "..key_convert(self.keys.rev_down).."/"..key_convert(self.keys.rev_up)..": "..string.format("%d Prozent", self.revLimit));
			renderText(0.72, 0.77, 0.02, "Tasten "..key_convert(self.keys.rev_down).."/"..key_convert(self.keys.rev_up)..": "..string.format("%d Prozent", self.revLimit));
			renderText(0.72, 0.755, 0.02, "Taste T: Zwillingsreifen AN/AUS");
			renderText(0.72, 0.74, 0.02, "Taste U: Spiegel ein/ausblenden");	
			renderText(0.72, 0.70, 0.02, "Taste KP1: Blinker Links");
			renderText(0.72, 0.68, 0.02, "Taste KP3: Bilinker Rechts");
			renderText(0.72, 0.66, 0.02, "Taste KP2: Warnblinker");
--			renderText(0.72, 0.72, 0.025, "- Radio -");
--			renderText(0.72, 0.705, 0.02, "Taste F5: ein/ausschalten");	
--			renderText(0.72, 0.69, 0.02, "Taste F6: nchster Track");			
--			renderText(0.72, 0.675, 0.02, "Taste F7: vorheriger Track");			
		end;
	end;

end;

function LamborghiniR8:onEnter()
    Utils.setEmittingState(self.exhaustParticleLow, false);
end;

function LamborghiniR8:onLeave()
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
    Utils.setEmittingState(self.exhaustParticleLow, false);
	
	if not self.deactivateOnLeave then
	    self.allowedIgnition = false;
	    self.ignitionKey = true; 
    else
	    self.allowedIgnition = false;
	    self.ignitionKey = false;
	end;	
	
end;

function LamborghiniR8:delete()
end;


function LamborghiniR8:mouseEvent(posX, posY, isDown, isUp, button)
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;

function LamborghiniR8:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	self.markOn = false;
	local mark = Utils.getNoNil(getXMLString(xmlFile, key.."#mark"),"false");
	if mark == "false" and not resetVehicles then
		self.markOn = false; 
	elseif mark == "true" then
		self.markOn = true;
	end; 
	
    return BaseMission.VEHICLE_LOAD_OK;
end;



