--
-- greenFertilizer
-- 
-- 
--
-- upsideDown 19.12.2013
-- V1.0: 05.01.2014
-- V1.1: 09.08.2014 make compatible with soilMod (quick patch, no real plugin)

greenFertilizer = {};


function greenFertilizer:loadMap(name)
	print("--- loading greenFertilizer mod V1.1 (soilMod compatible)--- (by upsidedown)")
		
	g_currentMission.GFfruitData = {};
	g_currentMission.GFinitDone = false;
end;

function greenFertilizer:deleteMap()
end


function greenFertilizer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function greenFertilizer:keyEvent(unicode, sym, modifier, isDown)
end;


function greenFertilizer:update(dt)	
	if not g_currentMission.GFinitDone then
		local fruits = {}
		for n=1,FruitUtil.NUM_FRUITTYPES,1 do
			fruits[n] = n;
		end;
		
		local fruitData = {}
		local cnt = 1;
		print("adding fruits to green fertilizer mod...")
		for _,subFruit in pairs(fruits) do
			local ids = g_currentMission.fruits[subFruit]
			if ids == nil or ids.id == 0 then
				
			else
				local id = ids.id
				local desc = FruitUtil.fruitIndexToDesc[subFruit];
				if desc.name ~= "grass" and desc.name~="dryGrass" then-- and (desc.name=="klee" or desc.name=="luzerne" or desc.name=="rape")
					local allowed = true;
					if g_currentMission.greenFertilizerBlockList ~= nil then
						for _,str in pairs(g_currentMission.greenFertilizerBlockList) do
							if str==desc.name then
								allowed = false;
							end;
						end;
					end;
					if allowed then
						fruitData[cnt] = {};
						print(desc.name)
						fruitData[cnt].index = subFruit;
						fruitData[cnt].allowed = true;
						cnt = cnt + 1;
					end;
				end;
				
			end;
		end;
		g_currentMission.GFfruitData = fruitData;
		g_currentMission.GFinitDone = true;
		print(tostring(cnt-1).." fruits added to cultivator, plough and direct seeder for fertilizer use")
		
				
		greenFertilizer.oldUpdateCultivatorArea = Utils.updateCultivatorArea;
		Utils.updateCultivatorArea = greenFertilizer.updateCultivatorArea;

		greenFertilizer.oldUpdateSowingArea = Utils.updateSowingArea;
		Utils.updateSowingArea = greenFertilizer.updateSowingArea;

		greenFertilizer.oldUpdatePloughArea = Utils.updatePloughArea;
		Utils.updatePloughArea = greenFertilizer.updatePloughArea;
		print("greenFertilizer functions added to Utils (compatible to soilManagementMod by Decker MMIV)")
		
	end;
end


function greenFertilizer:draw()
end;




function greenFertilizer.updateCultivatorArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle)
	if g_currentMission.GFinitDone then
		local detailId = g_currentMission.terrainDetailId;
		for _,fruit in pairs(g_currentMission.GFfruitData) do
			local ids = g_currentMission.fruits[fruit.index]
			if ids == nil or ids.id == 0 then
				return 0
			end
			local id = ids.id
			local desc = FruitUtil.fruitIndexToDesc[fruit.index]
		
			local x_n, z_n, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
			
			local organicId = g_currentMission.fmcFoliageFertilizerOrganic;
			if organicId~= nil then -- soilMod
				setDensityMaskParams(organicId, "between", desc.minHarvestingGrowthState, desc.cutState)
				addDensityMaskedParallelogram(
							organicId, 
							x_n, z_n, widthX, widthZ, heightX, heightZ,
							0,2,
							id,0,g_currentMission.numFruitStateChannels,
							2 -- add 2
						)
				setDensityMaskParams(organicId, "greater", -1);
			else --normal mode
				setDensityMaskParams(detailId, "between", desc.minHarvestingGrowthState, desc.cutState)
				setDensityMaskedParallelogram(detailId, x_n, z_n, widthX, widthZ, heightX, heightZ, g_currentMission.sprayChannel, 1, id, 0, g_currentMission.numFruitStateChannels, 1)
				setDensityMaskParams(detailId, "greater", 0);
			end;
			
			
			
			
			
		end;
	end;	
	local area = greenFertilizer.oldUpdateCultivatorArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle);
	return area;
end;

function greenFertilizer.updatePloughArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle)
	if g_currentMission.GFinitDone then
		local detailId = g_currentMission.terrainDetailId;
		for _,fruit in pairs(g_currentMission.GFfruitData) do
			local ids = g_currentMission.fruits[fruit.index]
			if ids == nil or ids.id == 0 then
				return 0
			end
			local id = ids.id
			local desc = FruitUtil.fruitIndexToDesc[fruit.index]
		
			local x_n, z_n, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
			local organicId = g_currentMission.fmcFoliageFertilizerOrganic;
			if organicId~= nil then -- soilMod
				setDensityMaskParams(organicId, "between", desc.minHarvestingGrowthState, desc.cutState)
				addDensityMaskedParallelogram(
							organicId, 
							x_n, z_n, widthX, widthZ, heightX, heightZ,
							0,2,
							id,0,g_currentMission.numFruitStateChannels,
							3 -- add 2
						)
				setDensityMaskParams(organicId, "greater", -1);
			else --normal mode
				setDensityMaskParams(detailId, "between", desc.minHarvestingGrowthState, desc.cutState)
				setDensityMaskedParallelogram(detailId, x_n, z_n, widthX, widthZ, heightX, heightZ, g_currentMission.sprayChannel, 1, id, 0, g_currentMission.numFruitStateChannels, 1)
				setDensityMaskParams(detailId, "greater", 0);
			end;
		end;
	end;
	
	local area = greenFertilizer.oldUpdatePloughArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle);
	return area;
end;



function greenFertilizer.updateSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting)
	if g_currentMission.GFinitDone then
		if useDirectPlanting then
			local detailId = g_currentMission.terrainDetailId;
			for _,fruit in pairs(g_currentMission.GFfruitData) do
				local ids = g_currentMission.fruits[fruit.index]
				if ids == nil or ids.id == 0 then
					return 0
				end
				local id = ids.id
				local desc = FruitUtil.fruitIndexToDesc[fruit.index]
			
				local x_n, z_n, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
				local organicId = g_currentMission.fmcFoliageFertilizerOrganic;
				if organicId~= nil then -- soilMod
					setDensityMaskParams(organicId, "between", desc.minHarvestingGrowthState, desc.cutState)
					addDensityMaskedParallelogram(
								organicId, 
								x_n, z_n, widthX, widthZ, heightX, heightZ,
								0,2,
								id,0,g_currentMission.numFruitStateChannels,
								1 -- add 1
							)
					setDensityMaskParams(organicId, "greater", -1);
				else --normal mode
					setDensityMaskParams(detailId, "between", desc.minHarvestingGrowthState, desc.cutState)
					setDensityMaskedParallelogram(detailId, x_n, z_n, widthX, widthZ, heightX, heightZ, g_currentMission.sprayChannel, 1, id, 0, g_currentMission.numFruitStateChannels, 1)
					setDensityMaskParams(detailId, "greater", 0);
				end;
			end;
		end;
	end;
	
	
	local numPixels, numDetailPixels = greenFertilizer.oldUpdateSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, useDirectPlanting);
	return numPixels, numDetailPixels
end;


-- greenFertilizer.oldUpdateCultivatorArea = Utils.updateCultivatorArea;
-- Utils.updateCultivatorArea = greenFertilizer.updateCultivatorArea;

-- greenFertilizer.oldUpdateSowingArea = Utils.updateSowingArea;
-- Utils.updateSowingArea = greenFertilizer.updateSowingArea;

-- greenFertilizer.oldUpdatePloughArea = Utils.updatePloughArea;
-- Utils.updatePloughArea = greenFertilizer.updatePloughArea;
addModEventListener(greenFertilizer);