-- ConcessiontimeControlledslidingGate2
-- @author: Daniel (Desperados93) W.
-- @date: 01.03.2011

-- Copyright () by Daniel "Desperados93" W.
   
  ConcessiontimeControlledslidingGate2 = {};
  
  local ConcessiontimeControlledslidingGate2_mt = Class(ConcessiontimeControlledslidingGate2);
  
  function ConcessiontimeControlledslidingGate2.onCreate(id)
      g_currentMission:addUpdateable(ConcessiontimeControlledslidingGate2:new(id));

  end;
  
  function ConcessiontimeControlledslidingGate2:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, ConcessiontimeControlledslidingGate2_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.gate = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local gate2Id = getChildAt(childLevel1, 0);
              if gate2Id ~= 0 then
                  table.insert(instance.gate, gate2Id);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 14;
      self.minTrans = 0;
  	  
      return instance;
  end;
  
  function ConcessiontimeControlledslidingGate2:delete()
 
      removeTrigger(self.triggerId);
  end;
  	
  
function ConcessiontimeControlledslidingGate2:update(dt)
 
    
	local available = false;
	
	if  (g_currentMission.environment.dayTime > 27000000 and g_currentMission.environment.dayTime < 43200000) or --7h30 - 12 Uhr
		(g_currentMission.environment.dayTime > 50400000 and g_currentMission.environment.dayTime < 63000000) then --14h - 17h30 Uhr

		available = true;
	end;
	
	if available == true then 
		local old = self.trans;
		if self.count > 0 then
			if self.trans < self.maxTrans then
				self.trans = self.trans + dt*0.0025;    
			end;
		else  
			if self.trans > self.minTrans then
				self.trans = self.trans - dt*0.0025;    
			end;
		end;
      
		for i=1, table.getn(self.gate) do
			setTranslation(self.gate[i], self.trans, 0, 0);
		end;
	end;
      
end;
    
  function ConcessiontimeControlledslidingGate2:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then

          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("ConcessiontimeControlleOnCreate", ConcessiontimeControlledslidingGate2.onCreate);