LaFermeLimousine = {}

-- LaFermeLimousine V1
--
-- @author  haryseb
-- @date  27/08/2014
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.


local LaFermeLimousine_mt = Class(LaFermeLimousine, Mission00);


function LaFermeLimousine:new(baseDirectory, customMt)

--	FruitUtil.registerFruitType("sunflower", g_i18n:getText("sunflower"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("scripts/huds/sunflowerHud.dds", baseDirectory), {0,1,0,1});
--	FruitUtil.registerFruitType("oat", g_i18n:getText("oat"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("scripts/huds/oatHud.dds", baseDirectory), {2,0,1,1});
--	FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_OAT, "oat_windrow", g_i18n:getText("oat_windrow"), 0.2, 3, false, Utils.getFilename("scripts/huds/oatWindrow.dds", baseDirectory));
--	FruitUtil.registerFruitType("sorghum", g_i18n:getText("sorghum"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("scripts/huds/sorghumHud.dds", baseDirectory), {1,1,1,1});
--	FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_SORGHUM, "sorghum_windrow", g_i18n:getText("sorghum_windrow"), 0.2, 3, false, Utils.getFilename("scripts/huds/sorghumWindrow.dds", baseDirectory));

--	FruitUtil.registerFruitType("choppedStraw", g_i18n:getText("choppedStraw"), false, false, true, 1, 100, 2, 1, 1, nil);
--	FruitUtil.registerFruitTypePreparing(FruitUtil.FRUITTYPE_CHOPPEDSTRAW,"choppedStraw_haulm", 8, 8, 9);
--	FruitUtil.registerFruitType("choppedMaize", g_i18n:getText("choppedMaize"), false, false, true, 1, 100, 2, 1, 1, nil);
--	FruitUtil.registerFruitTypePreparing(FruitUtil.FRUITTYPE_CHOPPEDMAIZE,"choppedMaize_haulm", 8, 8, 9);
--	FruitUtil.registerFruitType("choppedRape", g_i18n:getText("choppedRape"), false, false, true, 1, 100, 2, 1, 1, nil);
--	FruitUtil.registerFruitTypePreparing(FruitUtil.FRUITTYPE_CHOPPEDRAPE,"choppedRape_haulm", 8, 8, 9);

--	if g_i18n.globalI18N.texts.choppedStraw == nil then
--		g_i18n.globalI18N.texts.choppedStraw = g_i18n:getText("choppedStraw");
--	end;

--	if g_i18n.globalI18N.texts.choppedMaize == nil then
--		g_i18n.globalI18N.texts.choppedMaize = g_i18n:getText("choppedMaize");
--	end;

--	if g_i18n.globalI18N.texts.choppedRape == nil then
--		g_i18n.globalI18N.texts.choppedRape = g_i18n:getText("choppedRape");
--	end;
--	print("*** ChoppedStraw fruittypes registered!");
	
    local mt = customMt;
    if mt == nil then
        mt = LaFermeLimousine_mt;
		
    end;
    local self = LaFermeLimousine:superClass():new(baseDirectory, mt);

	--#############################################################################
--#### Soil Mod ###############################################################
    if fmcSoilMod ~= nil and fmcSoilMod.setup_map_new ~= nil then
        --fmcSoilMod.setup_map_new(baseDirectory .. "map/fmcSoilManagement/filltypeOverlays")  -- If map provides its own fill-type HUD overlay icons.
        fmcSoilMod.setup_map_new(baseDirectory .. "map/fmcSoilManagement/filltypeOverlays") -- If using icons included with the SoilManagement.ZIP mod.
    end
--#############################################################################
--#############################################################################
--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function LaFermeLimousine:delete()
--#############################################################################
--#### Soil Mod ###############################################################
    if fmcSoilMod ~= nil and fmcSoilMod.teardown_map_delete ~= nil then
        fmcSoilMod.teardown_map_delete()
    end
--#############################################################################
--#############################################################################
    LaFermeLimousine:superClass().delete(self);
end;

function LaFermeLimousine:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;
	
	self:loadMap(Utils.getFilename("map/La_Ferme_Limousine_V1.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
	
	
		--DURAL : add this line to support the "realisticStartSettings.xml" file
			g_currentMission.realMapBaseDirectory = self.baseDirectory;
end;

function LaFermeLimousine:loadMap01Finished(node, arguments)

	self.terrainDetailAngleNumChannels = 8; -- durch die gewünschte Anzahl Channels ersetzen
	
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("LaFermeLimousine.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 419, 163, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 431, 164, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 442, 178, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 256, 655, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 178, 647, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 215, 527, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    LaFermeLimousine:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
   else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

	if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;
--#############################################################################
--#### Soil Mod ###############################################################
    if fmcSoilMod ~= nil and fmcSoilMod.postInit_loadMapFinished ~= nil then
        if fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected ~= nil then
			fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("sunflower"     ,"fertilizer3"  ,"herbicide")
			fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("sorghum"     ,"fertilizer3"  ,"herbicide")
			fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("luzerne"      ,"fertilizer"   ,"herbicide2")
			fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("klee"      ,"fertilizer"   ,"herbicide2")
			
            -- If needed, set up this map's custom fruit-types fertilizer-boost and herbicide-affected attributes.
            
            -- <<Examples>>
            -- fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("tomato"   ,"fertilizer"   ,"herbicide3")
            -- fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("soybean"  ,"fertilizer2"  ,"herbicide" )
            -- fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("pumpkin"  ,"fertilizer3"  ,"herbicide2")
        end
        --
        fmcSoilMod.postInit_loadMapFinished()
    end
--#############################################################################
--#############################################################################
    self:finishLoadingTask();
end;

function LaFermeLimousine:onStartMission()
    LaFermeLimousine:superClass().onStartMission(self);
end;

function LaFermeLimousine:mouseEvent(posX, posY, isDown, isUp, button)
    LaFermeLimousine:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function LaFermeLimousine:keyEvent(unicode, sym, modifier, isDown)
    LaFermeLimousine:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function LaFermeLimousine:update(dt)
    LaFermeLimousine:superClass().update(self, dt);
--#############################################################################
--#### Soil Mod ###############################################################
    if fmcSoilMod ~= nil and fmcSoilMod.update ~= nil then
        fmcSoilMod.update(dt)
    end
--#############################################################################
--#############################################################################	
end;

function LaFermeLimousine:draw()
    LaFermeLimousine:superClass().draw(self);
	
--#############################################################################
--#### Soil Mod ###############################################################
    if fmcSoilMod ~= nil and fmcSoilMod.draw ~= nil then
        fmcSoilMod.draw()
    end
--#############################################################################
--#############################################################################	
end;