--
-- PdaPlugin_VehicleSpecs
--
-- @author  Decker_MMIV - fs-uk.com, forum.farming-simulator.com, modhoster.com
-- @date    2013-04-28
--
-- @history
--  2013-April
--      v0.01   - Initial experiment
--      v0.02   - Tweaks for the icon placement.
--  2013-May
--      v0.03   - Only create/delete image, when selection changes.
--  2013-June
--      v0.04   - Show what fruittypes/filltypes the implements is configured to handle.
--  2013-October
--      v0.05   - Show what types of AttacherJoints and AttacherJoint the vehicle has.
--              - Show if the vehicle is a 'MoreRealistic' one.
--  2014-February
--      v0.06   - Scrolling text.
--      v0.07   - Fix for when storeItem is not found.
--              - Additional specs added regarding Fillable and Trailer.
--  2014-May
--      v0.10   - Changed to use modPDAMOD.registerPlugin(...)
--  2014-June
--      v0.11   - Due to the NON-deterministic way that mods are loaded in multiplayer, the modPDAMOD.registerPlugin(...)
--                is replaced in favor of a hopefully more robust "create object modPDAMODplugins, and add yourself to it" method.
--      v0.12   - Minor tweaks.
--      2.0.0   - Using http://semver.org/
--

PdaPlugin_VehicleSpecs = {}
--
local modItem = ModsUtil.findModItemByModName(g_currentModName);
PdaPlugin_VehicleSpecs.version = (modItem and modItem.version) and modItem.version or "?.?.?";
--
PdaPlugin_VehicleSpecs.isInitialized = false;

-- Register this PDAMod plugin
getfenv(0)["modPDAMODplugins"] = getfenv(0)["modPDAMODplugins"] or {}
table.insert(getfenv(0)["modPDAMODplugins"], PdaPlugin_VehicleSpecs);
--


function PdaPlugin_VehicleSpecs:loadMap(xmlName)
    PdaPlugin_VehicleSpecs.pageNum = 0;
    PdaPlugin_VehicleSpecs.currVehObj = nil;
    PdaPlugin_VehicleSpecs.currStoreItem = nil;
    PdaPlugin_VehicleSpecs.currImage = nil;
end;

function PdaPlugin_VehicleSpecs:deleteMap()
    PdaPlugin_VehicleSpecs.isInitialized = false;
    if PdaPlugin_VehicleSpecs.currImage ~= nil then
        delete(PdaPlugin_VehicleSpecs.currImage);
        PdaPlugin_VehicleSpecs.currImage = nil;
    end;
end;

function PdaPlugin_VehicleSpecs.initialize(self, initStep)
    if initStep == 1 then
        modPDAMOD.registerPage(
            "vehicleSpecs", nil, 
            PdaPlugin_VehicleSpecs.subPageDraw,    g_currentMission.missionPDA, nil,
            PdaPlugin_VehicleSpecs.screenKeyEvent, g_currentMission.missionPDA, nil
        );
    end
end;

--
function PdaPlugin_VehicleSpecs.allAttachments(veh, vehObjs)
    for _,v in pairs(veh.attachedImplements) do
        table.insert(vehObjs, v.object);
    end;
    for _,v in pairs(veh.attachedImplements) do
        PdaPlugin_VehicleSpecs.allAttachments(v.object, vehObjs);
    end; 
end;

--
function PdaPlugin_VehicleSpecs.screenKeyEvent(self, parm, origMissionPdaUpdateFunc)
    -- Note: 'self' is in context of the g_currentMission.missionPDA object.
    
    PdaPlugin_VehicleSpecs.pageNum = PdaPlugin_VehicleSpecs.pageNum + 1;
    playSample(self.pdaBeepSound, 1, 0.3, 0);
end;

--
function PdaPlugin_VehicleSpecs.subPageDraw(self, parm, origMissionPdaDrawFunc)
    -- Note: 'self' is in context of the g_currentMission.missionPDA object.

    --
    self.hudPDABackgroundOverlay:render()
    --
    if g_currentMission.controlledVehicle then
        local vehObjs = {g_currentMission.controlledVehicle};
        PdaPlugin_VehicleSpecs.allAttachments(g_currentMission.controlledVehicle, vehObjs);
        --
        if PdaPlugin_VehicleSpecs.pageNum < 1 or PdaPlugin_VehicleSpecs.pageNum > table.getn(vehObjs) then
            PdaPlugin_VehicleSpecs.pageNum = 1;
        end;
        --
        if PdaPlugin_VehicleSpecs.currVehObj ~= vehObjs[PdaPlugin_VehicleSpecs.pageNum] then
            PdaPlugin_VehicleSpecs.currVehObj = vehObjs[PdaPlugin_VehicleSpecs.pageNum];
            local xmlFilename = PdaPlugin_VehicleSpecs.currVehObj.configFileName;
            PdaPlugin_VehicleSpecs.currStoreItem = nil;
            PdaPlugin_VehicleSpecs.currVehName = g_i18n:getText("NoVehicleName")
            if PdaPlugin_VehicleSpecs.currImage ~= nil then
                delete(PdaPlugin_VehicleSpecs.currImage);
                PdaPlugin_VehicleSpecs.currImage = nil;
            end;
            --
            for k,v in pairs(g_shopScreen.storeItems) do
                if xmlFilename == v.xmlFilename then
                    PdaPlugin_VehicleSpecs.currStoreItem = v;
                    PdaPlugin_VehicleSpecs.currVehName = v.name;
                    break
                end
            end
            if PdaPlugin_VehicleSpecs.currStoreItem ~= nil then
                if PdaPlugin_VehicleSpecs.currStoreItem.imageActive ~= nil then
                    PdaPlugin_VehicleSpecs.currImage = createImageOverlay(PdaPlugin_VehicleSpecs.currStoreItem.imageActive);
                    setOverlayColor(PdaPlugin_VehicleSpecs.currImage, 1,1,1, 0.5);
                end
            end;
            --
            local specs = {}
            PdaPlugin_VehicleSpecs.buildSpecsText(specs, PdaPlugin_VehicleSpecs.currVehObj, PdaPlugin_VehicleSpecs.currStoreItem)
            PdaPlugin_VehicleSpecs.makeScrollText(specs, self.pdaFontSize, self.pdaWidth)
        end;
        -- 
        if PdaPlugin_VehicleSpecs.currImage ~= nil then
            local iconH = self.pdaMapHeight * 0.75;
            local iconW = iconH * (3/4); -- TODO: Is this the correct aspect-ratio?
            renderOverlay(PdaPlugin_VehicleSpecs.currImage, self.pdaMapPosX + (self.pdaMapWidth * 0.98) - iconW, self.pdaMapPosY + (self.pdaMapHeight * 0.95) - iconH, iconW, iconH);
        end;
        --
        setTextAlignment(RenderText.ALIGN_LEFT);
        setTextColor(1,1,1,1);
        --
        if PdaPlugin_VehicleSpecs.currVehName ~= nil then
            setTextWrapWidth(self.pdaWidth);
            setTextBold(true);
            renderText(self.pdaX, self.pdaHeadRow, self.pdaFontSize, PdaPlugin_VehicleSpecs.currVehName);
            setTextWrapWidth(0);
        end
        --
        setTextBold(false);
        --
        if PdaPlugin_VehicleSpecs.scrollTxts ~= nil then
            local row = g_currentMission.time -- (g_currentMission.time - PdaPlugin_VehicleSpecs.scrollLine)
            local posY = self.pdaHeadRow - (2 * self.pdaFontSize) + ((row % 1000) / 1000 * self.pdaFontSize)
            
            row = math.floor(row / 1000)
            local maxRows = table.getn(PdaPlugin_VehicleSpecs.scrollTxts)
            
            row = (row % maxRows) + 1
            while posY > self.pdaMapPosY do
                renderText(self.pdaX, posY, self.pdaFontSize, PdaPlugin_VehicleSpecs.scrollTxts[row]);
                posY = posY - self.pdaFontSize
                row = (row % maxRows) + 1
            end
        end
        --
        if table.getn(vehObjs) > 1 then 
            g_currentMission:addHelpButtonText(g_i18n:getText("NextPage"), InputBinding.TOGGLE_PDA_ZOOM);
            modPDAMOD.drawPageOfPages(PdaPlugin_VehicleSpecs.pageNum, table.getn(vehObjs));
        end;
    else
        renderText(self.pdaX, self.pdaHeadRow, self.pdaFontSize, g_i18n:getText("NotInVehicle"));
    end;
    --
    self.hudPDAFrameOverlay:render()
    --
    modPDAMOD.drawTitle(g_i18n:getText("VehicleSpecs"));
end

function PdaPlugin_VehicleSpecs.buildSpecsText(specs, veh, storeItem)
    if veh == nil then
        return
    end

    local txt
    local found
    
    -- Store specs
    if storeItem and storeItem.specs and storeItem.specs ~= "" then
        table.insert(specs, "");
        table.insert(specs, g_i18n:getText("StoreSpecs1")) --"===== Store specs =====");
        local lines = Utils.splitString("\n", string.format(storeItem.specs, tostring(storeItem.dailyUpkeep)))
        for _,line in pairs(lines) do
            table.insert(specs, line);
        end
        table.insert(specs, g_i18n:getText("StoreSpecs2")) --"=======================");
    end

    -- Fruit/FillTypes
    found = false
    txt = "" --g_i18n:getText("mapViewMode2")..": ";  -- "Fruit types: "
    if veh.fillTypes ~= nil then  -- Fillable
        for fillType,accepted in pairs(veh.fillTypes) do
            if accepted and fillType ~= Fillable.FILLTYPE_UNKNOWN then
                local txtFillName = Fillable.fillTypeIntToName[fillType];
                if g_i18n:hasText(txtFillName) then
                    txtFillName = g_i18n:getText(txtFillName);
                end;
                txt = txt .. (found==true and ", " or "") .. txtFillName;
                found = true;
            end;
        end
    else
        local fruitTypes = nil;
        if veh.grainTankFruitTypes ~= nil then
            fruitTypes = veh.grainTankFruitTypes; -- Combine
        elseif veh.fruitTypes ~= nil then
            fruitTypes = veh.fruitTypes;  -- Cutter and other
        end
        if fruitTypes ~= nil then
            for fruitIndex,accepted in pairs(fruitTypes) do
                if accepted and fruitIndex ~= FruitUtil.FRUITTYPE_UNKNOWN then
                    local fruitDesc = FruitUtil.fruitIndexToDesc[fruitIndex];
                    local txtFruitName = fruitDesc.name;
                    if g_i18n:hasText(txtFruitName) then
                        txtFruitName = g_i18n:getText(txtFruitName);
                    end;
                    txt = txt .. (found==true and ", " or "") .. txtFruitName;
                    found = true;
                end;
            end
        end
    end
    if found then
        table.insert(specs, "");
        table.insert(specs, (g_i18n:getText("FruitTypes")):format(txt));
    end

    --
    local function hasNumberValue(obj, greaterThan)
        if obj ~= nil and type(obj)==type(9) then
            if greaterThan == nil then
                return true;
            end
            if obj > greaterThan then
                return true
            end
        end
        return false
    end
    local function getBoolText(bool)
        return g_i18n:getText((bool==true) and "Yes" or "No")
    end
    
    local lines = {}
    --
    if hasNumberValue(veh.fuelCapacity, 0) then
        table.insert(lines, (g_i18n:getText("FuelCapacity")):format(veh.fuelCapacity));
    end
    if hasNumberValue(veh.grainTankCapacity, 0) then
        table.insert(lines, (g_i18n:getText("GrainTankCapacity")):format(veh.grainTankCapacity));
    end
    if hasNumberValue(veh.capacity, 0) then
        table.insert(lines, (g_i18n:getText("FillCapacity")):format(veh.capacity));
    end
    if veh.getAllowFillFromAir ~= nil then
        table.insert(lines, (g_i18n:getText("AllowFillFromAir")):format(getBoolText(veh:getAllowFillFromAir())))
    end
    if veh.allowTipDischarge ~= nil then
        table.insert(lines, (g_i18n:getText("AllowTipDischarge")):format(getBoolText(veh.allowTipDischarge)))
    end
    if hasNumberValue(veh.currentFillType) then
        local fillType = Fillable.fillTypeIntToName[veh.currentFillType];
        if fillType == nil then
            fillType = "unknown";
        else
            if g_i18n:hasText(fillType) then
                fillType = fillType .. " ("..g_i18n:getText(fillType)..")"
            end
        end
        table.insert(lines, (g_i18n:getText("CurrentFillType")):format(fillType))
    end
    if hasNumberValue(veh.currentMass) then
        table.insert(lines, (g_i18n:getText("CurrentMass")):format(veh.currentMass))
    end
    --
    if table.getn(lines) > 0 then
        table.insert(specs, "");
        for _,line in pairs(lines) do
            table.insert(specs, line);
        end
    end
    
    -- AttacherJoint (primary)
    lines = {}
    txt = ""
    found = false
    if veh.attacherJoint ~= nil then
        local v = veh.attacherJoint;
        local attacherTypeName = "unknown";
        for n,i in pairs(Vehicle.jointTypeNameToInt) do
            if i == v.jointType then
                attacherTypeName = n;
                break
            end
        end
        txt = txt .. attacherTypeName;
        found = true
    end;
    if not found then
        txt = txt .. g_i18n:getText("None");
        found = true
    end
    if found then
        table.insert(lines, (g_i18n:getText("PrimAttacher")):format(txt))
    end
    -- AttacherJoints (secondary)
    txt = ""
    found = false
    if veh.attacherJoints ~= nil then
        for k,v in pairs(veh.attacherJoints) do
            local jointTypeName = "unknown";
            for n,i in pairs(Vehicle.jointTypeNameToInt) do
                if i == v.jointType then
                    jointTypeName = n;
                    break
                end
            end
            txt = txt .. (found==true and ", " or "") .. jointTypeName;
            found = true
        end
    end
    if not found then
        txt = txt .. g_i18n:getText("None");
        found = true
    end
    if found then
        table.insert(lines, (g_i18n:getText("SecAttachers")):format(txt))
    end
    if table.getn(lines) > 0 then
        table.insert(specs, "");
        for _,line in pairs(lines) do
            table.insert(specs, line);
        end
    end

    -- MoreRealistic
    txt = (g_i18n:getText("IsMoreRealistic")):format(getBoolText(veh.isRealistic))
    table.insert(specs, "");
    table.insert(specs, txt)
end

function PdaPlugin_VehicleSpecs.makeScrollText(specs, fontSize, maxTextWidth)
    -- Convert to scrollable text-area
    PdaPlugin_VehicleSpecs.scrollTxts = {}
    PdaPlugin_VehicleSpecs.scrollLine = g_currentMission.time
    for _,spec in pairs(specs) do
        local line = nil
        local words = Utils.splitString(" ",spec)
        local j = table.getn(words)
        if j > 0 then
            local i = 1
            line = words[i]
            i=i+1
            while i <= j do
                if getTextWidth(fontSize, line.." "..words[i]) > maxTextWidth then
                    table.insert(PdaPlugin_VehicleSpecs.scrollTxts, line)
                    line = words[i]
                else
                    line = line .. " " .. words[i]
                end
                i=i+1
            end
        end
        if line ~= nil then
            table.insert(PdaPlugin_VehicleSpecs.scrollTxts, line)
        end
        --
    end
    table.insert(PdaPlugin_VehicleSpecs.scrollTxts, "")
    table.insert(PdaPlugin_VehicleSpecs.scrollTxts, g_i18n:getText("Divider")) --"----- -----")
    table.insert(PdaPlugin_VehicleSpecs.scrollTxts, "")
    while table.getn(PdaPlugin_VehicleSpecs.scrollTxts) < 15 do
        table.insert(PdaPlugin_VehicleSpecs.scrollTxts, "")
    end
end

--
print(string.format("Script loaded: PdaPlugin_VehicleSpecs.LUA (v%s)", PdaPlugin_VehicleSpecs.version));
