--
-- LS_Nextgeneration_Map
--
-- @author  Mike LS-NG
-- @date  16/12/13
--
-- Copyright (C) LS-NG Modteam, www.ls-nextgeneration.com

LS_Nextgeneration_Map = {}

local LS_Nextgeneration_Map_mt = Class(LS_Nextgeneration_Map, Mission00);


function LS_Nextgeneration_Map:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = LS_Nextgeneration_Map_mt;
    end;
    local self = LS_Nextgeneration_Map:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function LS_Nextgeneration_Map:delete()
    LS_Nextgeneration_Map:superClass().delete(self);
end;

function LS_Nextgeneration_Map:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("map/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/LSNG.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function LS_Nextgeneration_Map:loadMap01Finished(node, arguments)

		self.terrainDetailAngleNumChannels = 8;
		
		self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("LS_Nextgeneration_Map.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;
	


    -- ATMs
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 156.58, 35.06, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -247.85554504395, -343.47616577148, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 166.82, 44.03, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 299.07, -353.36, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -141.74, -4.28, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 468.45, -38.48, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 276.54598999023, -857.44244384766, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Cows1", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 240.48, -286.03, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -41.873638153076, 603.51239013672, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 377.66329956055, -488.33001708984, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	-- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -296.08367919922, -134.4781036377, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -26.316404342651, 121.25405883789, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 188.10205078125, 747.74798583984, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 326.77255249023, -556.52947998047, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 366.02716064453, -553.79321289063, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 365.99307250977, -780.90789794922, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 162.49594116211, 515.52252197266, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -625.5166015625, -352.39682006836, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	-- bga
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 478.42, -56.82, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
	
    -- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), -245.26538085938, -120.58798980713, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    LS_Nextgeneration_Map:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function LS_Nextgeneration_Map:onStartMission()
    LS_Nextgeneration_Map:superClass().onStartMission(self);
end;

function LS_Nextgeneration_Map:mouseEvent(posX, posY, isDown, isUp, button)
    LS_Nextgeneration_Map:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function LS_Nextgeneration_Map:keyEvent(unicode, sym, modifier, isDown)
    LS_Nextgeneration_Map:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function LS_Nextgeneration_Map:update(dt)
    LS_Nextgeneration_Map:superClass().update(self, dt);
end;

function LS_Nextgeneration_Map:draw()
    LS_Nextgeneration_Map:superClass().draw(self);
end;