--
-- Joskin
-- 
--
-- @poc@lypse
-- Edit by Fendt-939 for www.lsportal.nl


Joskin = {};


function Joskin.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Joskin:load(xmlFile)
	
  
    
local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end;   

    

    
      

    
    
   self.isActive = false;
  
   

   self.time = 0;
   self.groundCheck = {};
   self.groundCheck = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundCheck#index"));
   

   
end;


function Joskin:delete()   
   Utils.setEmittingState(self.particleSystems,false)  
 if self.mowerSoundEnabled then
       stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;  	 
end;

function Joskin:mouseEvent(posX, posY, isDown, isUp, button)
   
end;

function Joskin:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_b then
		self.isTurnedOn = not self.isTurnedOn;
	end;
   
   
end;

function Joskin:update(dt)
 if self.attacherVehicle then
	
	
	if self.isTurnedOn then	
			
			local x,y,z = getWorldTranslation(self.groundCheck);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gC = y-terrainHeight; 
		
			if (math.min(gC) < 0.5) then
			  self.go = true;
			else
			  self.go = false;
			end;	
			
	   if  self.go	  then
		Utils.setEmittingState(self.dustParticleSystems, true)
		Utils.setEmittingState(self.particleSystems, true);
	   else
		Utils.setEmittingState(self.particleSystems, false);
		Utils.setEmittingState(self.dustParticleSystems, false)
	   end;
		
			
	
			if self.go then
		        if table.getn(self.cuttingAreas) > 0 then
				local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
				Utils.cutFruitArea( 1, x1, z2, x1, z1, x2, z2);
				Utils.cutFruitArea( 2, x1, z2, x1, z1, x2, z2);
				Utils.cutFruitArea( 3, x1, z2, x1, z1, x2, z2);
				Utils.cutFruitArea( 4, x1, z2, x1, z1, x2, z2);
				Utils.updateMeadowArea(x1, z2, x1, z1, x2, z2);
				Utils.updateCuttedMeadowArea(x1, z2, x1, z1, x2, z2);
			  end;
			end;
		if not self.mowerSoundRunning then
                print("start");
                playSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = true;				
		end;	
	else
	
	   if self.mowerSoundRunning then
                print("end");
                stopSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = false;
		
	  end;	
	end;	
end;
	if (not self.isTurnedOn) then	
		Utils.setEmittingState(self.particleSystems, false);
			Utils.setEmittingState(self.dustParticleSystems, false)
	end;

if (not self.isTurnedOn) then	
		Utils.setEmittingState(self.particleSystems, false);
			Utils.setEmittingState(self.dustParticleSystems, false)
	end;
	if self.playHidraulic or self.playHidraulic1 or self.playHidraulic2 or self.playHidraulic3 or self.playHidraulic4 or self.playHidraulic5 or self.playHidraulic6 or self.playHidraulic7 then
            if self.hidraulicSound ~= nil and not self.hidraulicSoundEnabled then
                if self:getIsActiveForSound() then
                    setSamplePitch(self.hidraulicSound, self.hidraulicSoundPitchOffset);
                    playSample(self.hidraulicSound, 0, 0.5, 0);
                    self.hidraulicSoundEnabled = true;
                end;
            end;
     
		
     else
            if self.hidraulicSound ~= nil and self.hidraulicSoundEnabled then
                stopSample(self.hidraulicSound);
                self.hidraulicSoundEnabled = false;
            end;
     
	end;







function Joskin:draw()
 
   
  g_currentMission:addExtraPrintText("Push B: ON/OFF Joskin TR 275 C3");       
   
end;


function Joskin:onDetach()
  self.isTurnedOn = false;
	 stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;   
end;



function Joskin:onDeactivateSounds()
    if self.hidraulicSound ~= nil and self.hidraulicSoundEnabled then
        stopSample(self.hidraulicSound);
        self.hidraulicSoundEnabled = false;
    end;
   if self.mowerSoundRunning then
                print("end");
                stopSample(self.mowerSound, 0, 1.6, 0);
                self.mowerSoundRunning = false;
			end;
end;
end;