SeedsSetIsFillingEvent = {};
SeedsSetIsFillingEvent_mt = Class(SeedsSetIsFillingEvent, Event);
  
InitEventClass(SeedsSetIsFillingEvent, "SeedsSetIsFillingEvent");
  
function SeedsSetIsFillingEvent:emptyNew()
	local self = Event:new(SeedsSetIsFillingEvent_mt);
	self.className="SeedsSetIsFillingEvent";
	return self;
end;
  
function SeedsSetIsFillingEvent:new(object, isFilling)
	local self = SeedsSetIsFillingEvent:emptyNew()
	self.object = object;
	self.isFilling = isFilling;
	return self;
end;
 
function SeedsSetIsFillingEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.isFilling = streamReadBool(streamId);
	self:run(connection);
end;
  
function SeedsSetIsFillingEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isFilling);
end;
  
function SeedsSetIsFillingEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	self.object:setIsSowingMachineFilling(self.isFilling, true);
end;
  
function SeedsSetIsFillingEvent.sendEvent(object, isFilling, noEventSend)
	if isFilling ~= object.isSowingMachineFilling then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SeedsSetIsFillingEvent:new(object, isFilling), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(SeedsSetIsFillingEvent:new(object, isFilling));
			end;
		end;
	end;
end;