--
-- Straw Specialization for Combines
--
-- @author  Templaer
-- @date  24/05/09
--
-- @edit 	by gotchTOM 
-- @date	17-May-2012 -> ready for Multiplayer (FS 2011)
-- @date	18-May-2012 -> fix: the input, the HelpButtonText and the moving of the chopperBlind 

strawSpec = {};

function strawSpec.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function strawSpec:load(xmlFile)

	self.setStrawActivation = SpecializationUtil.callSpecializationsFunction("setStrawActivation");
	-- Backup of Chopper Blind
    self.backupChopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));
    self.strawActive = true;
end;

function strawSpec:readStream(streamId, connection)  

	self.strawActive = streamReadBool(streamId);
end;

function strawSpec:writeStream(streamId, connection)  

	streamWriteBool(streamId, self.strawActive);
end;

function strawSpec:delete()
end;

function strawSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function strawSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function strawSpec:update(dt)
    -- Check for input and set self.strawActive
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			--show HelpButtonText and allow input to set self.strawActive only if the crop in the graintank has straw or the graintank is empty
			local fruitType = Utils.getNoNil(self.currentGrainTankFruitType, FruitUtil.FRUITTYPE_UNKNOWN);
			local fruitDesc = FruitUtil.fruitIndexToDesc[fruitType];
			if (fruitDesc ~= nil and fruitDesc.hasStraw) or fruitType == FruitUtil.FRUITTYPE_UNKNOWN then 
				self.showStrawSpecTxt = true;
				if InputBinding.hasEvent(InputBinding.STRAW_TOGGLE) then				
					if self.strawActive	then
						self:setStrawActivation(false);
					else
						self:setStrawActivation(true);
					end;	
				end;
			else --the crop in the graintank has no straw, so hide HelpButtonText and set self.strawActive = false -> self.chopperActivated = true
				self.showStrawSpecTxt = false;
				if self.strawActive then
					self:setStrawActivation(false);
				end;
			end;
		end;
    end;
end;

function strawSpec:updateTick(dt)

	if self:getIsActive() then
		self.chopperActivated = not self.strawActive
		if self.chopperActivated then
			self.strawEmitState = false;
			self.strawEnableTime = nil;
			if self.isClient then
				self.chopperBlind = nil;
				-- Lower the chopper
				if self.backupChopperBlind ~= nil then
					local chopperBlindRotationSpeed = 0.001;
					local minRotX = -83*3.1415/180.0;
					local x,y,z = getRotation(self.backupChopperBlind);
					x = x-dt*chopperBlindRotationSpeed;
					if x < minRotX then
						x = minRotX;
					end;
					setRotation(self.backupChopperBlind, x, y, z);
				end;
			end;
			-- Enable chopper particle system					
			if self.lastArea > 0 then
			    if self.chopperActivated then
                    if self.chopperEnableTime == nil then
                        self.chopperEnableTime = self.time + self.chopperToggleTime;
                    else
                        self.chopperDisableTime = nil;
                    end;
                    disableChopperEmit = false;
			    end;
			    -- Chopper starting delay
			    if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
			
                    self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
			
                    if self.currentChopperParticleSystem == nil then
                        self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
                    end;
                    Utils.setEmittingState(self.currentChopperParticleSystem, true);
				
			    end;
			end;
		else
			if self.isClient then	
				self.chopperBlind = self.backupChopperBlind;
			end;	
		end;
	end;
end;

function strawSpec:setStrawActivation(strawActive, noEventSend) 

	if noEventSend == nil or noEventSend == false then	
		SetStrawActivationEvent.sendEvent(self, strawActive, noEventSend); 
	end;
	self.strawActive = strawActive;
end;

function strawSpec:draw()
    -- Add text to the HUD if needed
	if self.showStrawSpecTxt then
		if self.strawActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("strawCutOn"), InputBinding.STRAW_TOGGLE);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("strawCutOff"), InputBinding.STRAW_TOGGLE);
		end;
	end;	
end;


SetStrawActivationEvent = {};
SetStrawActivationEvent_mt = Class(SetStrawActivationEvent, Event);

InitEventClass(SetStrawActivationEvent, "SetStrawActivationEvent");

function SetStrawActivationEvent:emptyNew()
  
    local self = Event:new(SetStrawActivationEvent_mt);
    self.className="SetStrawActivationEvent";
    return self;
end;

function SetStrawActivationEvent:new(vehicle, strawActive)

    local self = SetStrawActivationEvent:emptyNew()
    self.vehicle = vehicle;
	self.strawActive = strawActive;
    return self;
end;

function SetStrawActivationEvent:readStream(streamId, connection) 

    local id = streamReadInt32(streamId); 
	self.strawActive = streamReadBool(streamId);  
    self.vehicle = networkGetObject(id); 
    self:run(connection);
end;

function SetStrawActivationEvent:writeStream(streamId, connection) 
  
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.strawActive);
end;

function SetStrawActivationEvent:run(connection) 
  
	if not connection:getIsServer() then	
		for k, v in pairs(g_server.clientConnections) do
			if v ~= connection and not v:getIsLocal() then
				v:sendEvent(SetStrawActivationEvent:new(self.vehicle, self.strawActive));
			end;
		end;
	end;	
	self.vehicle:setStrawActivation(self.strawActive, true); 
end;

function SetStrawActivationEvent.sendEvent(vehicle, strawActive, noEventSend)  
		
	if g_server ~= nil then  
		g_server:broadcastEvent(SetStrawActivationEvent:new(vehicle, strawActive), nil, nil, vehicle);
	else  
		g_client:getServerConnection():sendEvent(SetStrawActivationEvent:new(vehicle, strawActive));
	end;
end;
