--
-- handbrake
--
-- handbremse
--
-- @author ???
--
-- @complement by Amarlich (16.01.2013)
--

handBrake = {};

function handBrake.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function handBrake:load(xmlFile)
	self.setHandBrakeState = SpecializationUtil.callSpecializationsFunction("setHandBrakeState");
	self.handBrakeHud = Overlay:new("hBOverlay", Utils.getFilename("Textures/hb_symbol.dds", self.baseDirectory), 0.45, 0.0150, 0.040, 0.050);
	
	self.handbrake = true;
    
	handbrakeSoundFile = Utils.getFilename("sounds/pbrake.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	
	brakereleaseSoundFile = Utils.getFilename("sounds/pbrake2.wav", self.baseDirectory);
    self.brakereleaseSoundId = createSample("brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
    
	self.brakereleasePlaying = false;
    self.BreakForceVal = 10000/self.motor.brakeForce;

    self.HandBrakeTurnOff = false;
end;

function handBrake:delete()

end;

function handBrake:mouseEvent(posX, posY, isDown, isUp, button)

end;

function handBrake:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_space then
        self:setHandBrakeState(not self.handbrake);
		if self.handbrake and self:getIsActiveForSound() then
			playSample(self.handbrakeSoundId,1,1,0);
		end;
	end;
end;

function handBrake:updateTick(dt)
   if self.isServer then
        if self.handbrake then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 999, 0);
                end;
            end;
        elseif not self.handbrake and self.HandBrakeTurnOff then
            if self.isServer then
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 0, 0);
                end;
            end;
            self.HandBrakeTurnOff = false;
        end;
    end;
end;

function handBrake:update(dt)

	if self.isMotorStarted then        
		if Input.isKeyPressed(Input.KEY_s) then
				if not self.braking then
					self.braking = true;
				end;
				if not self.brakePlaying and self:getIsActiveForSound() then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;				
		else
			self.brakePlaying = false;
			self.braking = false;
			if not self.brakereleasePlaying and self:getIsActiveForSound() then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;
	end;
end;

function handBrake:draw()
	if self.isEntered then	
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_w) then
				self.handBrakeHud:render();
			end;
		self.handBrakeHud:render();
		end;
		end;
		if self.handbrake == false then
		g_currentMission:addHelpButtonText(g_i18n:getText("handbrakeON"), InputBinding.handbrake);
		else
		g_currentMission:addHelpButtonText(g_i18n:getText("handbrakeOFF"), InputBinding.handbrake);
	end;
	if self.isEntered then	
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_w) then
				g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
			end;
		end;
	end;
	if self.isEntered then	
		if self.handbrake then
			if Input.isKeyPressed(Input.KEY_s) then
				g_currentMission:addWarning(g_i18n:getText("handbrakeRELEASE"), 0.015, 0.030);
			end;
		end;
	end;
end;

function handBrake:onLeave()

end;

function handBrake:setHandBrakeState(state, noEventSend)
    self.handbrake = state;
    self.HandBrakeTurnOff = state;
end;

