-- NI Modding
--
-- author  	Henly20 
-- date  	03-03-2013.
-- ni_modding@hotmail.com
-- http://nimodding.wordpress.com
  
Taarup3532Cond = {};
  
function Taarup3532Cond.prerequisitesPresent(specializations)
 	return SpecializationUtil.hasSpecialization(Taarup3532, specializations);
end;
  
function Taarup3532Cond:load(xmlFile)

	  self.setCondPanel = SpecializationUtil.callSpecializationsFunction("setCondPanel");
	  self.CondPanelAnimation = getXMLString(xmlFile, "vehicle.CondPanel#animationName");
	  self.CondPanel = true;  
      self.setConditionerOn = SpecializationUtil.callSpecializationsFunction("setConditionerOn");
	  self.conditionerNode = {};
	  self.conditionerNode.node  = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.conditionerNode#index"));

      self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
      self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
      if self.groundReferenceNode == nil then
          self.groundReferenceNode = self.components[1].node;
      end;
  
      local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
      if numWindrowerDropAreas == 0 then
          print("Warning: No drop areas specified in '"..self.configFileName.."'");
      else
          if numWindrowerDropAreas ~= 1 and numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
              print("Warning: Number of cutting areas and drop areas should be equal in '"..self.configFileName.."'");
          end;
      end;
      self.windrowerDropAreas = {}
      for i=1, numWindrowerDropAreas do
          self.windrowerDropAreas[i] = {};
          local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
          self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
          self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
          self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
      end;
  
      local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
      self.accumulatedCuttingAreaValues = {};
      self.accumulatedFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
      for i=1, numCuttingAreas do
          self.accumulatedCuttingAreaValues[i] = 0;
      end;
	  self.isTurnedOn = false;
	  self.isConditionerOn = true;
  
      self.windrowerGroundFlag = self.nextDirtyFlag;
      self.nextDirtyFlag = self.windrowerGroundFlag*2;
end;
  
function Taarup3532Cond:delete()

  
end;
  
function Taarup3532Cond:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function Taarup3532Cond:keyEvent(unicode, sym, modifier, isDown)
end;

function Taarup3532Cond:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then

	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Taarup3532Cond:getSaveAttributesAndNodes(nodeIdent)

end;
  
function Taarup3532Cond:readStream(streamId, connection)
      local isConditionerOn = streamReadBool(streamId);
      self:setConditionerOn(isConditionerOn, true);
      self:setCondPanel(streamReadBool(streamId), true);
end;
  
function Taarup3532Cond:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isConditionerOn);
      streamWriteBool(streamId, self.CondPanel);
end;
  
function Taarup3532Cond:readUpdateStream(streamId, timestamp, connection)
end;
  
function Taarup3532Cond:writeUpdateStream(streamId, connection, dirtyMask)
end;
  
function Taarup3532Cond:update(dt)
  
	if not self:getIsActive() then
		if self.conditionerInRange then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
				self:setCondPanel(not self.CondPanel);
			end;
			if not self.CondPanel then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("conditionerOn"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("conditionerOff"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
			end;
		end;
	end;
end;
  
function Taarup3532Cond:updateTick(dt)

		if g_currentMission.player ~= nil then
			local nearestDistance = 3;
			local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);		
			local px, py, pz = getWorldTranslation(self.conditionerNode.node); 
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
			if distance < nearestDistance then
				self.conditionerInRange = true; 
			else
				self.conditionerInRange = false; 
			end;
		end;
		
    if self:getIsActive() then
		if not self.CondPanel then
			self:setConditionerOn(false);
			else
			self:setConditionerOn(true);
		end;
          if self.isConditionerOn and self.isTurnedOn and self.isTransRotOn then
              if self.isServer then
                  local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
                  if not toFast then
                      local x,y,z = getWorldTranslation(self.groundReferenceNode);
                      local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                      if terrainHeight+self.groundReferenceThreshold >= y then
                          local numDropAreas = table.getn(self.windrowerDropAreas);
                          local numAreas = table.getn(self.cuttingAreas);
                          if numDropAreas > 0 and numAreas > 0 then
                              local cuttingAreasSend = {};
                              local dropAreasSend = {};
                              for i=1, numAreas do
                                  local cuttingArea = self.cuttingAreas[i];
                                  if self:getIsAreaActive(cuttingArea) then
                                      local x,_,z = getWorldTranslation(cuttingArea.start);
                                      local x1,_,z1 = getWorldTranslation(cuttingArea.width);
                                      local x2,_,z2 = getWorldTranslation(cuttingArea.height);
  
                                      table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                                  end;
                              end;
                              for i=1, numDropAreas do
                                  local dropArea = self.windrowerDropAreas[i];
                                  local dx,dy,dz = getWorldTranslation(dropArea.start);
                                  local dx1,dy1,dz1 = getWorldTranslation(dropArea.width);
                                  local dx2,dy2,dz2 = getWorldTranslation(dropArea.height);
                                  table.insert(dropAreasSend, {dx, dz, dx1, dz1, dx2, dz2});
                              end;
                              if table.getn(cuttingAreasSend) > 0 then
                                  local cuttingAreasSend, dropAreasSend, fruitType, bitType = WindrowAreaEvent.runLocally(cuttingAreasSend, dropAreasSend, self.accumulatedCuttingAreaValues, self.accumulatedFruitType);
                                  if table.getn(cuttingAreasSend) > 0 or table.getn(dropAreasSend) > 0 then
                                      self.accumulatedFruitType = fruitType
                                      g_server:broadcastEvent(WindrowAreaEvent:new(cuttingAreasSend, dropAreasSend, fruitType, bitType));
                                  end;
                              end;
                          end;
                      end;
                  end;
  
                  self.wasToFast = toFast;
              end;
			end;

      end;
end;
  
function Taarup3532Cond:draw()

end;
  
function Taarup3532Cond:onDetach()



end;
  
function Taarup3532Cond:onLeave()

	  self:setConditionerOn(false, true);

end;
  
function Taarup3532Cond:onDeactivate()

end;
  
function Taarup3532Cond:onDeactivateSounds()

end;
  
function Taarup3532Cond:setConditionerOn(isConditionerOn, noEventSend)
    SetConditionerOnEvent.sendEvent(self, isConditionerOn, noEventSend)   
	self.isConditionerOn = isConditionerOn;
	if not isConditionerOn then
        for k,_ in pairs(self.accumulatedCuttingAreaValues) do
              self.accumulatedCuttingAreaValues[k] = 0;
        end
	end;
end;

function Taarup3532Cond:setCondPanel(isCondPanel,noEventSend)
	SetCondPanelEvent.sendEvent(self, isCondPanel, noEventSend);

	if isCondPanel then
		if self.CondPanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.CondPanelAnimation, -1, nil, true);
			self.CondPanel = true;
		end;
	else
		if self.CondPanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.CondPanelAnimation, 1, nil, true);
			self.CondPanel = false;
		end;
	end;	
end;