SetWheelRotEvent = {};
SetWheelRotEvent_mt = Class(SetWheelRotEvent, Event);

InitEventClass(SetWheelRotEvent, "SetWheelRotEvent");

function SetWheelRotEvent:emptyNew()
    local self = Event:new(SetWheelRotEvent_mt);
    self.className="SetWheelRotEvent";
    return self;
end;

function SetWheelRotEvent:new(vehicle, isWheelRot)
    local self = SetWheelRotEvent:emptyNew()
    self.vehicle = vehicle;
	self.isWheelRot = isWheelRot;
    return self;
end;

function SetWheelRotEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isWheelRot = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetWheelRotEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isWheelRot);
end;

function SetWheelRotEvent:run(connection)   
	self.vehicle:setWheelRot(self.isWheelRot, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetWheelRotEvent:new(self.vehicle, self.isWheelRot), nil, connection, self.vehicle);
    end;
end;

function SetWheelRotEvent.sendEvent(vehicle, isWheelRot, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetWheelRotEvent:new(vehicle, isWheelRot), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetWheelRotEvent:new(vehicle, isWheelRot));
		end;
	end;
end;

SetConditionerOnEvent = {};
SetConditionerOnEvent_mt = Class(SetConditionerOnEvent, Event);
  
InitEventClass(SetConditionerOnEvent, "SetConditionerOnEvent");
  
function SetConditionerOnEvent:emptyNew()
     local self = Event:new(SetConditionerOnEvent_mt);
      self.className="SetConditionerOnEvent";
      return self;
end;
  
function SetConditionerOnEvent:new(object, condtionerOn)
      local self = SetConditionerOnEvent:emptyNew()
      self.object = object;
      self.condtionerOn = condtionerOn;
      return self;
end;
  
function SetConditionerOnEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.condtionerOn = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetConditionerOnEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.condtionerOn);
end;
  
function SetConditionerOnEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setConditionerOn(self.condtionerOn, true);
end;
  
function SetConditionerOnEvent.sendEvent(vehicle, condtionerOn, noEventSend)
      if condtionerOn ~= vehicle.isConditionerOn then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetConditionerOnEvent:new(vehicle, condtionerOn), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetConditionerOnEvent:new(vehicle, condtionerOn));
              end;
          end;
      end;
end;

SetSideSkirtsEvent = {};
SetSideSkirtsEvent_mt = Class(SetSideSkirtsEvent, Event);

InitEventClass(SetSideSkirtsEvent, "SetSideSkirtsEvent");

function SetSideSkirtsEvent:emptyNew()
    local self = Event:new(SetSideSkirtsEvent_mt);
    self.className="SetSideSkirtsEvent";
    return self;
end;

function SetSideSkirtsEvent:new(vehicle, isSideSkirts)
    local self = SetSideSkirtsEvent:emptyNew()
    self.vehicle = vehicle;
	self.isSideSkirts = isSideSkirts;
    return self;
end;

function SetSideSkirtsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isSideSkirts = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetSideSkirtsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isSideSkirts);
end;

function SetSideSkirtsEvent:run(connection)   
	self.vehicle:setSideSkirts(self.isSideSkirts, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetSideSkirtsEvent:new(self.vehicle, self.isSideSkirts), nil, connection, self.vehicle);
    end;
end;

function SetSideSkirtsEvent.sendEvent(vehicle, isSideSkirts, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetSideSkirtsEvent:new(vehicle, isSideSkirts), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetSideSkirtsEvent:new(vehicle, isSideSkirts));
		end;
	end;
end;

SetCondPanelEvent = {};
SetCondPanelEvent_mt = Class(SetCondPanelEvent, Event);

InitEventClass(SetCondPanelEvent, "SetCondPanelEvent");

function SetCondPanelEvent:emptyNew()
    local self = Event:new(SetCondPanelEvent_mt);
    self.className="SetCondPanelEvent";
    return self;
end;

function SetCondPanelEvent:new(vehicle, isCondState)
    local self = SetCondPanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isCondPanelState = isCondState;
    return self;
end;

function SetCondPanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isCondPanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetCondPanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isCondPanelState);
end;

function SetCondPanelEvent:run(connection)   
	self.vehicle:setCondPanel(self.isCondPanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetCondPanelEvent:new(self.vehicle, self.isCondPanelState), nil, connection, self.vehicle);
    end;
end;

function SetCondPanelEvent.sendEvent(vehicle, isCondState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCondPanelEvent:new(vehicle, isCondState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetCondPanelEvent:new(vehicle, isCondState));
		end;
	end;
end;

SetTransRotEvent = {};
SetTransRotEvent_mt = Class(SetTransRotEvent, Event);

InitEventClass(SetTransRotEvent, "SetTransRotEvent");

function SetTransRotEvent:emptyNew()
    local self = Event:new(SetTransRotEvent_mt);
    self.className="SetTransRotEvent";
    return self;
end;

function SetTransRotEvent:new(vehicle, isTransRot)
    local self = SetTransRotEvent:emptyNew()
    self.vehicle = vehicle;
	self.isTransRot = isTransRot;
    return self;
end;

function SetTransRotEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isTransRot = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTransRotEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isTransRot);
end;

function SetTransRotEvent:run(connection)   
	self.vehicle:setTransRot(self.isTransRot, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTransRotEvent:new(self.vehicle, self.isTransRot), nil, connection, self.vehicle);
    end;
end;

function SetTransRotEvent.sendEvent(vehicle, isTransRot, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTransRotEvent:new(vehicle, isTransRot), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTransRotEvent:new(vehicle, isTransRot));
		end;
	end;
end;

SetTransportEvent = {};
SetTransportEvent_mt = Class(SetTransportEvent, Event);

InitEventClass(SetTransportEvent, "SetTransportEvent");

function SetTransportEvent:emptyNew()
    local self = Event:new(SetTransportEvent_mt);
    self.className="SetTransportEvent";
    return self;
end;

function SetTransportEvent:new(object, isTransport)
    local self = SetTransportEvent:emptyNew()
    self.object = object;
	self.isTransport = isTransport;
    return self;
end;

function SetTransportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isTransport = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetTransportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isTransport);
end;

function SetTransportEvent:run(connection)
	self.object:setTransport(self.isTransport, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTransportEvent:new(self.object, self.isTransport), nil, connection, self.object);
    end;	
end;

function SetTransportEvent.sendEvent(vehicle, isTransport, noEventSend)
	if isTransport ~= vehicle.isTransport then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetTransportEvent:new(vehicle, isTransport), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetTransportEvent:new(vehicle, isTransport));
			end;
		end;
	end;
end;

SetIsArmDownEvent = {};
SetIsArmDownEvent_mt = Class(SetIsArmDownEvent, Event);

InitEventClass(SetIsArmDownEvent, "SetIsArmDownEvent");

function SetIsArmDownEvent:emptyNew()
    local self = Event:new(SetIsArmDownEvent_mt);
    self.className="SetIsArmDownEvent";
    return self;
end;

function SetIsArmDownEvent:new(object, arm, isDown)
    local self = SetIsArmDownEvent:emptyNew()
    self.object = object;
	self.arm = arm;
	self.isDown = isDown;
    return self;
end;

function SetIsArmDownEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDown = streamReadBool(streamId);
	self.arm = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetIsArmDownEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isDown);
	streamWriteInt32(streamId, self.arm);
end;

function SetIsArmDownEvent:run(connection)   
	if self.object ~= nil then
		self.object:setIsArmDown(self.arm, self.isDown, true);
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetIsArmDownEvent:new(self.object, self.arm, self.isDown), nil, connection, self.object);
    end;
end;

function SetIsArmDownEvent.sendEvent(vehicle, arm, isDown, noEventSend)
	local foldingArm = vehicle.mowerFoldingParts[arm];
	if foldingArm ~= nil then
		if isDown ~= vehicle.mowerFoldingParts[arm].mainPart.isDown then
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(SetIsArmDownEvent:new(vehicle, arm, isDown), nil, nil, vehicle);
				else
					g_client:getServerConnection():sendEvent(SetIsArmDownEvent:new(vehicle, arm, isDown));
				end;
			end;
		end;
	end;
end;

SetAutoRightEvent = {};
SetAutoRightEvent_mt = Class(SetAutoRightEvent, Event);

InitEventClass(SetAutoRightEvent, "SetAutoRightEvent");

function SetAutoRightEvent:emptyNew()
    local self = Event:new(SetAutoRightEvent_mt);
    self.className="SetAutoRightEvent";
    return self;
end;

function SetAutoRightEvent:new(vehicle, isAutoRight)
    local self = SetAutoRightEvent:emptyNew()
    self.vehicle = vehicle;
	self.isAutoRight = isAutoRight;
    return self;
end;

function SetAutoRightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isAutoRight = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetAutoRightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isAutoRight);
end;

function SetAutoRightEvent:run(connection)   
	if self.vehicle ~= nil then
		self.vehicle:setAutoRight(self.isAutoRight, true);
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetAutoRightEvent:new(self.vehicle, self.isAutoRight), nil, connection, self.vehicle);
    end;
end;

function SetAutoRightEvent.sendEvent(vehicle, isAutoRight, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetAutoRightEvent:new(vehicle, isAutoRight), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetAutoRightEvent:new(vehicle, isAutoRight));
		end;
	end;
end;

SetAutoLeftEvent = {};
SetAutoLeftEvent_mt = Class(SetAutoLeftEvent, Event);

InitEventClass(SetAutoLeftEvent, "SetAutoLeftEvent");

function SetAutoLeftEvent:emptyNew()
    local self = Event:new(SetAutoLeftEvent_mt);
    self.className="SetAutoLeftEvent";
    return self;
end;

function SetAutoLeftEvent:new(vehicle, isAutoLeft)
    local self = SetAutoLeftEvent:emptyNew()
    self.vehicle = vehicle;
	self.isAutoLeft= isAutoLeft;
    return self;
end;

function SetAutoLeftEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isAutoLeft= streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetAutoLeftEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isAutoLeft);
end;

function SetAutoLeftEvent:run(connection)   
	if self.vehicle ~= nil then
		self.vehicle:setAutoLeft(self.isAutoLeft, true);
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetAutoLeftEvent:new(self.vehicle, self.isAutoLeft), nil, connection, self.vehicle);
    end;
end;

function SetAutoLeftEvent.sendEvent(vehicle, isAutoLeft, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetAutoLeftEvent:new(vehicle, isAutoLeft), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetAutoLeftEvent:new(vehicle, isAutoLeft));
		end;
	end;
end;

SetArmOneEvent = {};
SetArmOneEvent_mt = Class(SetArmOneEvent, Event);

InitEventClass(SetArmOneEvent, "SetArmOneEvent");

function SetArmOneEvent:emptyNew()
    local self = Event:new(SetArmOneEvent_mt);
    self.className="SetArmOneEvent";
    return self;
end;

function SetArmOneEvent:new(vehicle, isArmOne)
    local self = SetArmOneEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmOne = isArmOne;
    return self;
end;

function SetArmOneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmOne = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmOneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmOne);
end;

function SetArmOneEvent:run(connection)   
	self.vehicle:setArmOne(self.isArmOne, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmOneEvent:new(self.vehicle, self.isArmOne), nil, connection, self.vehicle);
    end;
end;

function SetArmOneEvent.sendEvent(vehicle, isArmOne, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmOneEvent:new(vehicle, isArmOne), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmOneEvent:new(vehicle, isArmOne));
		end;
	end;
end;


