--
-- Servo650
-- Specialization for Poettinger Servo 6.50
--
-- @author  ErikDK
-- @date  19/09/11
--
-- Copyright (C) ErikDK, Confidential, All Rights Reserved.

Servo650 = {};

function Servo650.prerequisitesPresent(specializations)
    return true;
end;

function Servo650:load(xmlFile)
		self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel;
		self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel;
		
		self.doRotateRight = false;
		self.doRotateLeft = false;
		self.attacherBackup = nil;
		self.TurnRadiusBackup = 0;
		self.AiLeftMarkerBackup = self.aiLeftMarker;

		self.startMoveDirection =0;
		self.startAnimTime = 0;
		self.kippen = 1000;
                
		self.entry = {};
		local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animParts.part1#rootNode"));
		self.entry.animCharSet = 0;
		if rootNode ~= nil then
			self.entry.animCharSet = getAnimCharacterSet(rootNode);
			if self.entry.animCharSet ~= 0 then
				local clip = getAnimClipIndex(self.entry.animCharSet, getXMLString(xmlFile, "vehicle.animParts.part1#animationClip"));
				if clip >= 0 then
					assignAnimTrackClip(self.entry.animCharSet, 0, clip);
					setAnimTrackLoopState(self.entry.animCharSet, 0, false);
					self.entry.animDuration = getAnimClipDuration(self.entry.animCharSet, clip);
				end;
			end;
		end;
		
	        local ploughTurnSound = getXMLString(xmlFile, "vehicle.ploughTurnSound#file");
		if ploughTurnSound ~= nil and ploughTurnSound ~= "" then
			ploughTurnSound = Utils.getFilename(ploughTurnSound, self.baseDirectory);
			self.ploughTurnSound = createSample("ploughTurnSound");
			loadSample(self.ploughTurnSound, ploughTurnSound, false);
			self.ploughTurnSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughTurnSound#pitchOffset"), 0);
			self.ploughTurnSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughTurnSound#volume"), 1.0);
			self.ploughTurnSoundEnabled = false;
		end;

		local ploughSound = getXMLString(xmlFile, "vehicle.ploughSound#file");
		if ploughSound ~= nil and ploughSound ~= "" then
			ploughSound = Utils.getFilename(ploughSound, self.baseDirectory);
			self.ploughSound = createSample("ploughSound");
			loadSample(self.ploughSound, ploughSound, false);
			self.ploughSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughSound#pitchOffset"), 0);
			self.ploughSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughSound#volume"), 1.0);
			self.ploughSoundEnabled = false;
		end;
self.changemarker = false;
end;


function Servo650:delete()
    if self.ploughTurnSound ~= nil then
        delete(self.ploughTurnSound);
    end;
    
    if self.ploughSound ~= nil then
        delete(self.ploughSound);
    end;
end;

function Servo650:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Servo650:keyEvent(unicode, sym, modifier, isDown)
end;

function Servo650:aiInvertsMarkerOnTurn(turnLeft)
    if self.kippen > 1999 then
        return true;
    else
        return false;
    end;
end;

function Servo650:update(dt)
	if self.attacherBackup == nil and self.attacherVehicle ~= nil then 
		self.attacherBackup = self.attacherVehicle;
	end;


    setJointFrame(self.componentJoints[1].jointIndex , 0, self.componentJoints[1].jointNode);
    if self.kippen < 1 then 
       self.kippen = 0;
       self.doRotateLeft = false;
    end;
    if self.kippen > 2000 then 
      self.kippen = 2000;
      self.doRotateRight = false;
    end;
    
    if  InputBinding.isPressed(InputBinding.SCHWENK_LINKS)  or InputBinding.isPressed(InputBinding.SCHWENK_RECHTS) then
                if self.ploughTurnSound ~= nil and not self.ploughTurnSoundEnabled and self:getIsActiveForSound() then
                    playSample(self.ploughTurnSound, 0, self.ploughTurnSoundVolume, 0);
                    setSamplePitch(self.ploughTurnSound, self.ploughTurnSoundPitchOffset);
                    self.ploughTurnSoundEnabled = true;
		end;
    
     else
                stopSample(self.ploughTurnSound);
                self.ploughTurnSoundEnabled = false;
    end;
    
    if (InputBinding.isPressed(InputBinding.SCHWENK_RECHTS) and self:getIsActiveForInput()) or self.doRotateRight then
        self.kippen = self.kippen +10;
        enableAnimTrack(self.entry.animCharSet, 0);
        setAnimTrackTime(self.entry.animCharSet, 0, self.kippen, true);
        disableAnimTrack(self.entry.animCharSet, 0);
    end;
    if (InputBinding.isPressed(InputBinding.SCHWENK_LINKS) and self:getIsActiveForInput()) or self.doRotateLeft then
        self.kippen = self.kippen -10;
        enableAnimTrack(self.entry.animCharSet, 0);
        setAnimTrackTime(self.entry.animCharSet, 0, self.kippen, true);
        disableAnimTrack(self.entry.animCharSet, 0);
    end;


 if self.ploughSound ~= nil  then
	if (self:isLowered() and (self.kippen < 1 or self.kippen > 1999) and (self.lastSpeed*3600 > 10) and self:getIsActiveForSound()) then
		if not self.ploughSoundEnabled then
			playSample(self.ploughSound, 0, self.ploughSoundVolume, 0);
			setSamplePitch(self.ploughSound, self.ploughSoundPitchOffset);
			self.ploughSoundEnabled = true;
			--print("start Sound"); --DBG
		end;
        else
		 if self.ploughSoundEnabled then
			stopSample(self.ploughSound);
			self.ploughSoundEnabled = false;
			--print("Stop Sound"); --DBG
		end;
	end;
end;

 if (self:isLowered() and (self.kippen < 1 or self.kippen > 1999)) then
                    for k, cuttingArea in pairs(self.cuttingAreas) do
                        local x,y,z = getWorldTranslation(cuttingArea.start);
                        local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                        local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                        Utils.updatePloughArea(x, z, x1, z1, x2, z2);
                    end;
 end;

end;

function Servo650:onDeactivateSounds()
    if self.ploughSoundEnabled then
        stopSample(self.ploughSound);
        self.ploughSoundEnabled = false;
    end;
end;

function Servo650:draw()
	g_currentMission:addExtraPrintText("Servo 6.50 drehen : n/m");
end;

function Servo650:moveToCrossroads()
end;

function Servo650:aiRotateRight()
	self.doRotateRight = true;
self.changemarker = true;

end;

function Servo650:aiRotateLeft()
	self.doRotateLeft = true;
self.changemarker = true;



end;

function Servo650:onAttach(attacherVehicle)
self.TurnRadiusBackup = self.attacherVehicle.aiTractorTurnRadius;
self.attacherVehicle.aiTractorTurnRadius = 0;

end;
 
function Servo650:onDetach()
self.attacherBackup.aiTractorTurnRadius = self.TurnRadiusBackup;
self.attacherVehicle = self.attacherBackup;
self.attacherVehicle = nil;
self.attacherBackup = nil;
end;

function Plough:aiInvertsMarkerOnTurn(turnLeft)
    if turnLeft then
        return self.rotationMax ~= self.rotateLeftToMax;
    else
        return self.rotationMax == self.rotateLeftToMax;
    end;
end;
