--
-- add specialization to all mods.
--
--
-- @author:    	Xentro (www.ls-uk.info)(Marcus@Xentro.se)
-- @version:    v1.0
-- @date:       2012-11-11
-- @history:    v1.0 - inital implementation
--

addPTOhoseSpec = {};
addPTOhoseSpec.specIsLoaded = true;
addPTOhoseSpec.g_currentModDirectory = g_currentModDirectory;

if SpecializationUtil.specializations["PTO_hoseAttacher"] == nil then
	SpecializationUtil.registerSpecialization("PTO_hoseAttacher", "PTO_hoseAttacher", g_currentModDirectory .. "PTO_hoseAttacher.lua")
	addPTOhoseSpec.specIsLoaded = false;
else
	print("PTO and hose attacher have been loaded already!");
end;

addModEventListener(addPTOhoseSpec);

function addPTOhoseSpec:loadMap(name)	
    if not addPTOhoseSpec.specIsLoaded then
	
		addPTOhoseSpec:add();
        addPTOhoseSpec.specIsLoaded = true;
    end;
end;

function addPTOhoseSpec:deleteMap()
    addPTOhoseSpec.specIsLoaded = false;
end;

function addPTOhoseSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function addPTOhoseSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function addPTOhoseSpec:update(dt)
end;

function addPTOhoseSpec:draw()
end;

function addPTOhoseSpec:add()
	local searchTable = {"PowerShaftAttacher",
						"powerShaftAttacher",
						"powershaftAttacher",
						"powershaftattacher",
						"PowershaftAttacher",
						"Powershaftattacher",
						"PowerShaftattacher",
						"powerShaftattacher"};
	
	for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
		local modName = string.match(k, "([^.]+)");
		
		local addPTOhoseSpec = true;
		for _, search in pairs(searchTable) do			
			if SpecializationUtil.specializations[modName .. "." .. search] ~= nil then
				addPTOhoseSpec = false;
				break;
			end;
		end;
		
		if SpecializationUtil.hasSpecialization(PowerShaftAttacher, v.specializations) then
			addPTOhoseSpec = false;
			break;
		end;
		
		local correctLocation = false;
		for i = 1, table.maxn(v.specializations) do
			local vs = v.specializations[i];
			if vs ~= nil and vs == SpecializationUtil.getSpecialization("animatedVehicle") then
				correctLocation = true;
				break;
			end;
		end;
		
		if addPTOhoseSpec and correctLocation then
			table.insert(v.specializations, SpecializationUtil.getSpecialization("PTO_hoseAttacher"));
		elseif correctLocation and not addPTOhoseSpec then
			print("  Failed to inserting PTO and hose attacher on " .. k);
		end;
	end;
end;