--
-- PowerShaftAttacher
-- Specialization for PowerShaftAttacher
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v3.0 - converted to ls2013 and added hose - PeterJ
--
-- hose part added by
-- PeterJ_FS-UK modteam
-- @date  02/06/2012
--
--

PTO_hoseAttacher = {};
PTO_hoseAttacher.stat = {};

function PTO_hoseAttacher.prerequisitesPresent(specializations)
    return true;
end;

function PTO_hoseAttacher:load(xmlFile)
	
	self.deactivatePTO = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.PowerShaftAttach#deactivate"), false);	
	if not self.deactivatePTO then	
		local i=0;
		while true do
			local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
			local index = getXMLString(xmlFile, baseName.. "#index");
			if index == nil then
				break;
			end;		
			local joint = self.attacherJoints[i+1];
			local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#ptoOutputNode"));
			if shaftAttacher ~= nil then
				joint.powerShaftAttacher = shaftAttacher;
			end;
			i = i + 1;
		end;

		local attacherJointCount = i;
		i = 0;
		while true do
			local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
			local index = getXMLString(xmlFile, baseName.. "#index");
			if index == nil then
				break;
			end;
			
			local joint = self.attacherJoints[attacherJointCount + 1 + i];
			local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#ptoOutputNode"));
			if shaftAttacher ~= nil then
				joint.powerShaftAttacher = shaftAttacher;
			end;
			i = i+1;
		end;
	end;
	self.deactivateHose = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.hydraulicHose#deactivate"), false);	
	if not self.deactivateHose then	
		local i=0;
		while true do
			local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
			local index = getXMLString(xmlFile, baseName.. "#index");
			if index == nil then
				break;
			end;		
			local joint = self.attacherJoints[i+1];
			local hoseAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#hose"));
			if hoseAttacher ~= nil then
				joint.hydrahoseAttacher = hoseAttacher;
			end;
			i = i + 1;
		end;

		local attacherJointCount = i;
		i = 0;
		while true do
			local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
			local index = getXMLString(xmlFile, baseName.. "#index");
			if index == nil then
				break;
			end;
			
			local joint = self.attacherJoints[attacherJointCount + 1 + i];
			local hoseAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#hose"));
			if hoseAttacher ~= nil then
				joint.hydrahoseAttacher = hoseAttacher;
			end;
			i = i+1;
		end;
	end;
end;

function PTO_hoseAttacher:delete()
end;

function PTO_hoseAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PTO_hoseAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function PTO_hoseAttacher:update(dt)
end;

function PTO_hoseAttacher:draw()
end;




