--
-- Airseeder
-- Specialization for Airseeder mod
--
-- @author  Knagsted
-- @date  18/12/09
--
-- Copyright (C)
-- @Script Modifcation by Tubman
-- @date 25/1/11
--
-- LS13 compatiblity: upsidedown
-- @date 23.05.2013

Airseeder = {};

function Airseeder.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Airseeder:load(xmlFile)
	self.speedlimit = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.speed#limit"), 13);
    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
    end;
	
	--self.numSowingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.sowingAreas#count"),0);
    --self.sowingAreas = {};
    --for i=1, self.numSowingAreas do
        --local objname = string.format("vehicle.sowingAreas.sowingArea" .. "%d",i);
        --self.sowingAreas[i] = {};
        --self.sowingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#startIndex"));
        --self.sowingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#widthIndex"));
		--self.sowingAreas[i].hight = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#heightIndex"));
    --end;
    self.numSowingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.sowingAreas#count"), 0);
    self.sowingAreas = {}
    for i=1, self.numSowingAreas do
        self.sowingAreas[i] = {};
        local areanamei = string.format("vehicle.sowingAreas.sowingArea%d", i);
        self.sowingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.sowingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.sowingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
	self.numCombinationAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.combinationAreas#count"), 0);
    self.combinationAreas = {}
    for i=1, self.numCombinationAreas do
        self.combinationAreas[i] = {};
        local areanamei = string.format("vehicle.combinationAreas.combinationArea%d", i);
        self.combinationAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.combinationAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.combinationAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
	self.numMarkerAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.markerAreas#count"), 0);
    self.markerAreas = {}
    for i=1, self.numMarkerAreas do
        self.markerAreas[i] = {};
        local areanamei = string.format("vehicle.markerAreas.markerArea%d", i);
        self.markerAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.markerAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.markerAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
	local seederBoom1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seederBoom1#index"));
    if seederBoom1Node ~= nil then
        self.seederBoom1 = {};
        self.seederBoom1.node = seederBoom1Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom1#minRot"));
        self.seederBoom1.minRot = {};
        self.seederBoom1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom1#maxRot"));
        self.seederBoom1.maxRot = {};
        self.seederBoom1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seederBoom1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom1#rotTime"), 2)*1000;
        self.seederBoom1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom1#touchRotLimit"), 10));
    end;
	
	local seederBoom2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seederBoom2#index"));
    if seederBoom2Node ~= nil then
        self.seederBoom2 = {};
        self.seederBoom2.node = seederBoom2Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom2#minRot"));
        self.seederBoom2.minRot = {};
        self.seederBoom2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom2#maxRot"));
        self.seederBoom2.maxRot = {};
        self.seederBoom2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seederBoom2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom2#rotTime"), 2)*1000;
        self.seederBoom2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom2#touchRotLimit"), 10));
    end;
	
	local seederBoom3Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seederBoom3#index"));
    if seederBoom3Node ~= nil then
        self.seederBoom3 = {};
        self.seederBoom3.node = seederBoom3Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom3#minRot"));
        self.seederBoom3.minRot = {};
        self.seederBoom3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom3#maxRot"));
        self.seederBoom3.maxRot = {};
        self.seederBoom3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seederBoom3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom3#rotTime"), 2)*1000;
        self.seederBoom3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom3#touchRotLimit"), 10));
    end;
	
	local seederBoom3Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seederBoom3#index"));
    if seederBoom3Node ~= nil then
        self.seederBoom3 = {};
        self.seederBoom3.node = seederBoom3Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom3#minRot"));
        self.seederBoom3.minRot = {};
        self.seederBoom3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom3#maxRot"));
        self.seederBoom3.maxRot = {};
        self.seederBoom3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seederBoom3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom3#rotTime"), 2)*1000;
        self.seederBoom3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom3#touchRotLimit"), 10));
    end;
	
	local seederBoom4Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seederBoom4#index"));
    if seederBoom4Node ~= nil then
        self.seederBoom4 = {};
        self.seederBoom4.node = seederBoom4Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom4#minRot"));
        self.seederBoom4.minRot = {};
        self.seederBoom4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom4#maxRot"));
        self.seederBoom4.maxRot = {};
        self.seederBoom4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seederBoom4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom4#rotTime"), 2)*1000;
        self.seederBoom4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom4#touchRotLimit"), 10));
    end;
	
	local seederBoom5Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seederBoom5#index"));
    if seederBoom5Node ~= nil then
        self.seederBoom5 = {};
        self.seederBoom5.node = seederBoom5Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom5#minRot"));
        self.seederBoom5.minRot = {};
        self.seederBoom5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom5#maxRot"));
        self.seederBoom5.maxRot = {};
        self.seederBoom5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seederBoom5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom5#rotTime"), 2)*1000;
        self.seederBoom5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom5#touchRotLimit"), 10));
    end;
	
	local seederBoom6Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seederBoom6#index"));
    if seederBoom6Node ~= nil then
        self.seederBoom6 = {};
        self.seederBoom6.node = seederBoom6Node;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom6#minRot"));
        self.seederBoom6.minRot = {};
        self.seederBoom6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.seederBoom6#maxRot"));
        self.seederBoom6.maxRot = {};
        self.seederBoom6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.seederBoom6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.seederBoom6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.seederBoom6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom6#rotTime"), 2)*1000;
        self.seederBoom6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.seederBoom6#touchRotLimit"), 10));
    end;
	
	local leftMarkerInnerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarkerInner#index"));
    if leftMarkerInnerNode ~= nil then
        self.leftMarkerInner = {};
        self.leftMarkerInner.node = leftMarkerInnerNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftMarkerInner#minRot"));
        self.leftMarkerInner.minRot = {};
        self.leftMarkerInner.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.leftMarkerInner.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.leftMarkerInner.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftMarkerInner#maxRot"));
        self.leftMarkerInner.maxRot = {};
        self.leftMarkerInner.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.leftMarkerInner.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.leftMarkerInner.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.leftMarkerInner.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftMarkerInner#rotTime"), 2)*1000;
        self.leftMarkerInner.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftMarkerInner#touchRotLimit"), 10));
    end;
	
	local leftMarkerOuterNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarkerOuter#index"));
    if leftMarkerOuterNode ~= nil then
        self.leftMarkerOuter = {};
        self.leftMarkerOuter.node = leftMarkerOuterNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftMarkerOuter#minRot"));
        self.leftMarkerOuter.minRot = {};
        self.leftMarkerOuter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.leftMarkerOuter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.leftMarkerOuter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftMarkerOuter#maxRot"));
        self.leftMarkerOuter.maxRot = {};
        self.leftMarkerOuter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.leftMarkerOuter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.leftMarkerOuter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.leftMarkerOuter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftMarkerOuter#rotTime"), 2)*1000;
        self.leftMarkerOuter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftMarkerOuter#touchRotLimit"), 10));
    end;
	
	self.leftMarkerDisc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarkerDisc#index"));
	self.leftMarkerInnerPivot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarkerInnerPivot#index"));
	self.leftMarkerHydraulics = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarkerHydraulics#index"));
	
	local leftMarkerPushNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftMarkerPush#index"));
    if leftMarkerPushNode ~= nil then
        self.leftMarkerPush = {};
        self.leftMarkerPush.node = leftMarkerPushNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftMarkerPush#minTrans"));
        self.leftMarkerPush.minTrans = {};
        self.leftMarkerPush.minTrans[1] = Utils.getNoNil(x, 0);
        self.leftMarkerPush.minTrans[2] = Utils.getNoNil(y, 0);
        self.leftMarkerPush.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftMarkerPush#maxTrans"));
        self.leftMarkerPush.maxTrans = {};
        self.leftMarkerPush.maxTrans[1] = Utils.getNoNil(x, 0);
        self.leftMarkerPush.maxTrans[2] = Utils.getNoNil(y, 0);
        self.leftMarkerPush.maxTrans[3] = Utils.getNoNil(z, 0);

        self.leftMarkerPush.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftMarkerPush#transTime"), 2)*1000;
        self.leftMarkerPush.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftMarkerPush#touchTransLimit"), 10);
    end;
	
	local rightMarkerInnerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarkerInner#index"));
    if rightMarkerInnerNode ~= nil then
        self.rightMarkerInner = {};
        self.rightMarkerInner.node = rightMarkerInnerNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightMarkerInner#minRot"));
        self.rightMarkerInner.minRot = {};
        self.rightMarkerInner.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rightMarkerInner.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rightMarkerInner.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightMarkerInner#maxRot"));
        self.rightMarkerInner.maxRot = {};
        self.rightMarkerInner.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rightMarkerInner.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rightMarkerInner.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rightMarkerInner.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightMarkerInner#rotTime"), 2)*1000;
        self.rightMarkerInner.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightMarkerInner#touchRotLimit"), 10));
    end;
	
	local rightMarkerOuterNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarkerOuter#index"));
    if rightMarkerOuterNode ~= nil then
        self.rightMarkerOuter = {};
        self.rightMarkerOuter.node = rightMarkerOuterNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightMarkerOuter#minRot"));
        self.rightMarkerOuter.minRot = {};
        self.rightMarkerOuter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rightMarkerOuter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rightMarkerOuter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightMarkerOuter#maxRot"));
        self.rightMarkerOuter.maxRot = {};
        self.rightMarkerOuter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rightMarkerOuter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rightMarkerOuter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rightMarkerOuter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightMarkerOuter#rotTime"), 2)*1000;
        self.rightMarkerOuter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightMarkerOuter#touchRotLimit"), 10));
    end;
	
	self.rightMarkerDisc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarkerDisc#index"));
	self.rightMarkerInnerPivot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarkerInnerPivot#index"));
	self.rightMarkerHydraulics = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarkerHydraulics#index"));
	
	local rightMarkerPushNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightMarkerPush#index"));
    if rightMarkerPushNode ~= nil then
        self.rightMarkerPush = {};
        self.rightMarkerPush.node = rightMarkerPushNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightMarkerPush#minTrans"));
        self.rightMarkerPush.minTrans = {};
        self.rightMarkerPush.minTrans[1] = Utils.getNoNil(x, 0);
        self.rightMarkerPush.minTrans[2] = Utils.getNoNil(y, 0);
        self.rightMarkerPush.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightMarkerPush#maxTrans"));
        self.rightMarkerPush.maxTrans = {};
        self.rightMarkerPush.maxTrans[1] = Utils.getNoNil(x, 0);
        self.rightMarkerPush.maxTrans[2] = Utils.getNoNil(y, 0);
        self.rightMarkerPush.maxTrans[3] = Utils.getNoNil(z, 0);

        self.rightMarkerPush.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightMarkerPush#transTime"), 2)*1000;
        self.rightMarkerPush.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightMarkerPush#touchTransLimit"), 10);
    end;
	
	-- Seeder discs and wheels
	self.rightFrontDisc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightFrontDisc#index"));
	self.rightRearDisc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightRearDisc#index"));
	self.rightFrontLevelWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightFrontLevelWheel#index"));
	self.rightRearLevelWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightRearLevelWheel#index"));
	self.rightFrontCowerWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightFrontCowerWheel#index"));
	self.rightRearCowerWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightRearCowerWheel#index"));
	
	self.centerFrontDisc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.centerFrontDisc#index"));
	self.centerRearDisc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.centerRearDisc#index"));
	self.centerFrontLevelWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.centerFrontLevelWheel#index"));
	self.centerRearLevelWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.centerRearLevelWheel#index"));
	self.centerFrontCowerWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.centerFrontCowerWheel#index"));
	self.centerRearCowerWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.centerRearCowerWheel#index"));
	
	self.leftFrontDisc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftFrontDisc#index"));
	self.leftRearDisc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftRearDisc#index"));
	self.leftFrontLevelWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftFrontLevelWheel#index"));
	self.leftRearLevelWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftRearLevelWheel#index"));
	self.leftFrontCowerWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftFrontCowerWheel#index"));
	self.leftRearCowerWheel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftRearCowerWheel#index"));
	
	-- Particles
	self.particleSystems1 = {};
    local psName1 = "vehicle.particleSystem1";
    Utils.loadParticleSystem(xmlFile, self.particleSystems1, psName1, self.components, false);
	
	self.particleSystems2 = {};
    local psName2 = "vehicle.particleSystem2";
    Utils.loadParticleSystem(xmlFile, self.particleSystems2, psName2, self.components, false);
	
	self.particleSystems3 = {};
    local psName3 = "vehicle.particleSystem3";
    Utils.loadParticleSystem(xmlFile, self.particleSystems3, psName3, self.components, false);
	
	self.particleSystems4 = {};
    local psName4 = "vehicle.particleSystem4";
    Utils.loadParticleSystem(xmlFile, self.particleSystems4, psName4, self.components, false);

	self.particleSystems5 = {};
    local psName5 = "vehicle.particleSystem5";
    Utils.loadParticleSystem(xmlFile, self.particleSystems5, psName5, self.components, false);
	
	self.particleSystems6 = {};
    local psName6 = "vehicle.particleSystem6";
    Utils.loadParticleSystem(xmlFile, self.particleSystems6, psName6, self.components, false);
	
	-- Sound
	GroundWorkSoundFile = Utils.getFilename("groundWork.wav", self.baseDirectory);
    self.GroundWorkSoundId = createSample("GroundWorkSound");
    loadSample(self.GroundWorkSoundId, GroundWorkSoundFile, false);
    self.GroundWorkPlaying = false;
	
	self.groundWork = false;
	self.externalGroundWork = false;
	
	HydraulicSoundFile = Utils.getFilename("hydraulicUp.wav", self.baseDirectory);
    self.HydraulicSoundId = createSample("HydraulicSound");
    loadSample(self.HydraulicSoundId, HydraulicSoundFile, false);
    self.HydraulicPlaying = false;
	
	self.hydraulicSound = false;
	self.hydraulicLiftersSound = false;
	
	-- External sound
	ExternalGroundWorkSound  = Utils.getFilename("groundWorkExternal.wav", self.baseDirectory);
	self.externalGroundWorkSound = createAudioSource("ExternalGroundWorkSound", ExternalGroundWorkSound, 50, 10, 1, 0);
	link(self.components[1].node, self.externalGroundWorkSound);
	setVisibility(self.externalGroundWorkSound, false);
	
	self.push1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push1#index"));
	self.push2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push2#index"));
	self.push3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push3#index"));
	self.push4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.push4#index"));
	
	self.hydraulics1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics1#index"));
	self.hydraulics2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics2#index"));
	self.hydraulics3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics3#index"));
	self.hydraulics4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics4#index"));
	
	self.hydraulics1Attacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics1Attacher#index"));
	self.hydraulics2Attacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics2Attacher#index"));
	self.hydraulics3Attacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics3Attacher#index"));
	self.hydraulics4Attacher = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulics4Attacher#index"));
	
	self.leftWing = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftWing#index"));
	self.rightWing = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightWing#index"));

	self.simulatedDolly1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.simulatedDolly1#index"));
	self.simulatedDolly2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.simulatedDolly2#index"));
	
	self.simulatedWheel1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.simulatedWheel1#index"));
	self.simulatedWheel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.simulatedWheel2#index"));
	self.simulatedWheel3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.simulatedWheel3#index"));
	self.simulatedWheel4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.simulatedWheel4#index"));
	self.simulatedWheel5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.simulatedWheel5#index"));
	self.simulatedWheel6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.simulatedWheel6#index"));
	
	self.dollyJoint1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dollyJoint1#index"));
	self.dollyJoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dollyJoint2#index"));
	
	--self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    --self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel;
	
	--self.aiaktiv = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index"));
	
	self.maxWingRotation = 104;
	self.minWingRotation = 0;

	self.wingRotation = self.minWingRotation;
	self.pushTranslation = 1.873;
	
	self.lastDolly1Rotation = 0;
	self.lastDolly2Rotation = 0;
	
	self.boomsLowered = false;
	self.boomsRaised = true;
	self.fullyExtended = true;
	self.noCombination = false;
	
	self.keyType = InputBinding.getKeyNamesOfDigitalAction;
	
	self.seeding = false;
	
	self.speedViolationMaxTime = 2500;
    self.speedViolationTimer = self.speedViolationMaxTime;
	
	self.currentSeedType = FruitUtil.FRUITTYPE_UNKNOWN;
	self.usingCartTankNo = -1;
	self.fertilize = false;
	self.autoMarkersEnabled = true;
	
	self.markerPos = 0;
end;

function Airseeder:delete()
	if self.GroundWorkPlaying ~= nil then
		stopSample(self.GroundWorkSoundId);
	end;
	Utils.deleteParticleSystem(self.particleSystems1)
	Utils.deleteParticleSystem(self.particleSystems2)
	Utils.deleteParticleSystem(self.particleSystems3)
	Utils.deleteParticleSystem(self.particleSystems4)
	Utils.deleteParticleSystem(self.particleSystems5)
	Utils.deleteParticleSystem(self.particleSystems6)
	
end;

function Airseeder:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Airseeder:keyEvent(unicode, sym, modifier, isDown)
end;

function Airseeder:update(dt)
	--insert angle
		local dx,dy,dz = localDirectionToWorld(self.rootNode, 0, 0, 1);

		local angleRad = Utils.getYRotationFromDirection(dx, dz)
		local desc = FruitUtil.fruitIndexToDesc[seedsFruitType];
		if desc ~= nil and desc.directionSnapAngle ~= 0 then
			angleRad = math.floor(angleRad / desc.directionSnapAngle + 0.5) * desc.directionSnapAngle;
		end

		local angle = Utils.convertToDensityMapAngle(angleRad, g_currentMission.terrainDetailAngleMaxValue);
	--end angle

	-- Hydraulics angle animation
	if self.hydraulics1Attacher ~= nil and self.hydraulics1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics1);
        local bx, by, bz = getWorldTranslation(self.hydraulics1Attacher);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics1), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics1, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.hydraulics1);
		setRotation(self.hydraulics1,x2,y2,z2+1.57);
	end;
	
	if self.hydraulics2Attacher ~= nil and self.hydraulics2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics2);
        local bx, by, bz = getWorldTranslation(self.hydraulics2Attacher);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics2), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics2, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.hydraulics2);
		setRotation(self.hydraulics2,x2,y2,z2+1.57);
	end;
	
	if self.hydraulics3Attacher ~= nil and self.hydraulics3 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics3);
        local bx, by, bz = getWorldTranslation(self.hydraulics3Attacher);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics3), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics3, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.hydraulics3);
		setRotation(self.hydraulics3,x2,y2,z2+1.57);
	end;
	
	if self.hydraulics4Attacher ~= nil and self.hydraulics4 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulics4);
        local bx, by, bz = getWorldTranslation(self.hydraulics4Attacher);

        local x, y, z = worldDirectionToLocal(getParent(self.hydraulics4), bx-ax, by-ay, bz-az);
        setDirection(self.hydraulics4, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.hydraulics4);
		setRotation(self.hydraulics4,x2,y2,z2+1.57);
	end;
	
	if self.leftMarkerInnerPivot ~= nil and self.leftMarkerHydraulics ~= nil then
		local ax, ay, az = getWorldTranslation(self.leftMarkerHydraulics);
        local bx, by, bz = getWorldTranslation(self.leftMarkerInnerPivot);

        local x, y, z = worldDirectionToLocal(getParent(self.leftMarkerHydraulics), bx-ax, by-ay, bz-az);
        setDirection(self.leftMarkerHydraulics, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.leftMarkerHydraulics);
		setRotation(self.leftMarkerHydraulics,x2,y2+1.57,z2);
	end;
	
	if self.rightMarkerInnerPivot ~= nil and self.rightMarkerHydraulics ~= nil then
		local ax, ay, az = getWorldTranslation(self.rightMarkerHydraulics);
        local bx, by, bz = getWorldTranslation(self.rightMarkerInnerPivot);

        local x, y, z = worldDirectionToLocal(getParent(self.rightMarkerHydraulics), bx-ax, by-ay, bz-az);
        setDirection(self.rightMarkerHydraulics, x, y, z, 0, 1, 0);
		
		local x2,y2,z2 = getRotation(self.rightMarkerHydraulics);
		setRotation(self.rightMarkerHydraulics,x2,y2+1.57,z2);
	end;
	
	if self.push1 ~= nil then
		setTranslation(self.push1, 0, self.pushTranslation, 0);
	end;
	
	if self.push2 ~= nil then
		setTranslation(self.push2, 0, self.pushTranslation, 0);
	end;
	
	if self.push3 ~= nil then
		setTranslation(self.push3, 0, self.pushTranslation, 0);
	end;
	
	if self.push4 ~= nil then
		setTranslation(self.push4, 0, self.pushTranslation, 0);
	end;

	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.attacherVehicle ~= nil then
			if self.attacherVehicle.attacherVehicle.isEntered then
				

			
				--Unfolding and folding wings
					if InputBinding.isPressed(InputBinding.JD1890FOLD) then
						if not self.attacherVehicle.lowerBooms then
							if self.wingRotation < self.maxWingRotation then
								self.wingRotation = self.wingRotation + dt * 0.012;
								self.pushTranslation = self.pushTranslation - dt * 0.00009323;
								self.hydraulicSound = true;
							else
								self.hydraulicSound = false;
							end;
						else
							g_currentMission:addWarning("You must raise seeder booms\nbefore folding or unfolding", 0.07+0.022, 0.019+0.029);
						end;						
					elseif InputBinding.isPressed(InputBinding.JD1890UNFOLD) then
						if not self.attacherVehicle.lowerBooms then
							if self.wingRotation > self.minWingRotation then
								self.wingRotation = self.wingRotation - dt * 0.012;
								self.pushTranslation = self.pushTranslation + dt * 0.00009323;
								self.hydraulicSound = true;
							else
								self.hydraulicSound = false;
							end;
						else
							g_currentMission:addWarning("You must raise seeder booms\nbefore folding or unfolding", 0.07+0.022, 0.019+0.029);
						end;
					else
						self.hydraulicSound = false;
					end;
				
				if self.leftWing ~= nil then
					local x,y,z = getRotation(self.leftWing);
					setRotation(self.leftWing, x, y, Utils.degToRad(self.wingRotation));
				end;
				
				if self.rightWing ~= nil then
					local x,y,z = getRotation(self.leftWing);
					setRotation(self.rightWing, x, y, Utils.degToRad(-1 * self.wingRotation));
				end;
				
				if self.wingRotation > self.minWingRotation and self.attacherVehicle.lowerBooms then
					self.attacherVehicle.lowerBooms = false;
				end;
				
				if InputBinding.hasEvent(InputBinding.JD1890MAKERTRANSPORT) then
					self.markerPos = 2;
				end;
				
				if  InputBinding.hasEvent(InputBinding.JD1890MAKERLEFT) then
					self.markerPos = 1;
				end;
				
				if  InputBinding.hasEvent(InputBinding.JD1890MAKERRIGHT) then
					self.markerPos = 3;
				end;
				
				if  InputBinding.hasEvent(InputBinding.JD1890AUTOMARKERS) then
					self.autoMarkersEnabled = not self.autoMarkersEnabled;
					if self.autoMarkersEnabled and self.attacherVehicle.lowerBooms then
						if self.markerPos == 2 or  self.markerPos == 0 then
							self.markerPos = self.markerPos + 1;
						end;
					end;
				end;
				
				if  InputBinding.hasEvent(InputBinding.JD1890LOWER) then
					if self.autoMarkersEnabled then
						self.markerPos = self.markerPos + 1;
						if self.markerPos > 3 then
							self.markerPos = 0;
						end;
					end;
				end;
				
				if self.wingRotation > self.minWingRotation then
					self.markerPos = 2;
				end;
			end;
			
			if self.markerPos == 1  then
				self.extendLeft = true;
				self.extendRight = false;
			elseif self.markerPos == 2 or  self.markerPos == 0 then
				self.extendLeft = false;
				self.extendRight = false;
			elseif self.markerPos == 3 then
				self.extendLeft = false;
				self.extendRight = true;
			end;
			
			self.noCombination = self.attacherVehicle.lowerBooms;
			
			self.boomsLowered = false
			if self.seederBoom1 ~= nil then
				local x, y, z = getRotation(self.seederBoom1.node);
				local minRot = self.seederBoom1.minRot;
				local eps = self.seederBoom1.touchRotLimit;
				
				if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
					self.boomsLowered = true;
				end;
			end;

			self.boomsRaised = false
			if self.seederBoom1 ~= nil then
				local x, y, z = getRotation(self.seederBoom1.node);
				local maxRot = self.seederBoom1.maxRot;
				local eps = self.seederBoom1.touchRotLimit;
				
				if math.abs(maxRot[1]-x) < eps and math.abs(maxRot[2]-y) < eps and math.abs(maxRot[3]-z) < eps then
					self.boomsRaised = true;
				end;
			end;
			
			self.leftExtended = false;
			if self.leftMarkerOuter ~= nil then
				local x, y, z = getRotation(self.leftMarkerOuter.node);
				local minRot = self.leftMarkerOuter.minRot;
				local eps = self.leftMarkerOuter.touchRotLimit;
				
				if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
					self.leftExtended = true;
				end;
			end;
			
			self.rightExtended = false;
			if self.rightMarkerOuter ~= nil then
				local x, y, z = getRotation(self.rightMarkerOuter.node);
				local minRot = self.rightMarkerOuter.minRot;
				local eps = self.rightMarkerOuter.touchRotLimit;
				
				if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
					self.rightExtended = true;
				end;
			end;
			
			if self.seederBoom1 ~= nil then
				local x, y, z = getRotation(self.seederBoom1.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.seederBoom1.maxRot, self.seederBoom1.minRot, 3, self.seederBoom1.rotTime, dt, self.attacherVehicle.lowerBooms);
				setRotation(self.seederBoom1.node, unpack(newRot));
			end;
			
			if self.seederBoom2 ~= nil then
				local x, y, z = getRotation(self.seederBoom2.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.seederBoom2.maxRot, self.seederBoom2.minRot, 3, self.seederBoom2.rotTime, dt, self.attacherVehicle.lowerBooms);
				setRotation(self.seederBoom2.node, unpack(newRot));
			end;
			
			if self.seederBoom3 ~= nil then
				local x, y, z = getRotation(self.seederBoom3.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.seederBoom3.maxRot, self.seederBoom3.minRot, 3, self.seederBoom3.rotTime, dt, self.attacherVehicle.lowerBooms);
				setRotation(self.seederBoom3.node, unpack(newRot));
			end;
			
			if self.seederBoom4 ~= nil then
				local x, y, z = getRotation(self.seederBoom4.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.seederBoom4.maxRot, self.seederBoom4.minRot, 3, self.seederBoom4.rotTime, dt, self.attacherVehicle.lowerBooms);
				setRotation(self.seederBoom4.node, unpack(newRot));
			end;
			
			if self.seederBoom5 ~= nil then
				local x, y, z = getRotation(self.seederBoom5.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.seederBoom5.maxRot, self.seederBoom5.minRot, 3, self.seederBoom5.rotTime, dt, self.attacherVehicle.lowerBooms);
				setRotation(self.seederBoom5.node, unpack(newRot));
			end;
			
			if self.seederBoom6 ~= nil then
				local x, y, z = getRotation(self.seederBoom6.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.seederBoom6.maxRot, self.seederBoom6.minRot, 3, self.seederBoom6.rotTime, dt, self.attacherVehicle.lowerBooms);
				setRotation(self.seederBoom6.node, unpack(newRot));
			end;
			
			if self.leftMarkerInner ~= nil then
				local x, y, z = getRotation(self.leftMarkerInner.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.leftMarkerInner.maxRot, self.leftMarkerInner.minRot, 3, self.leftMarkerInner.rotTime, dt, self.extendLeft);
				setRotation(self.leftMarkerInner.node, unpack(newRot));
			end;
			
			if self.leftMarkerOuter ~= nil then
				local x, y, z = getRotation(self.leftMarkerOuter.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.leftMarkerOuter.maxRot, self.leftMarkerOuter.minRot, 3, self.leftMarkerOuter.rotTime, dt, self.extendLeft);
				setRotation(self.leftMarkerOuter.node, unpack(newRot));
			end;

			if self.leftMarkerPush ~= nil then
				local x, y, z = getTranslation(self.leftMarkerPush.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.leftMarkerPush.maxTrans, self.leftMarkerPush.minTrans, 3, self.leftMarkerPush.transTime, dt, not self.extendLeft);
				setTranslation(self.leftMarkerPush.node, unpack(newTrans));
			end;
			
			if self.rightMarkerInner ~= nil then
				local x, y, z = getRotation(self.rightMarkerInner.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rightMarkerInner.maxRot, self.rightMarkerInner.minRot, 3, self.rightMarkerInner.rotTime, dt, self.extendRight);
				setRotation(self.rightMarkerInner.node, unpack(newRot));
			end;
			
			if self.rightMarkerOuter ~= nil then
				local x, y, z = getRotation(self.rightMarkerOuter.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rightMarkerOuter.maxRot, self.rightMarkerOuter.minRot, 3, self.rightMarkerOuter.rotTime, dt, self.extendRight);
				setRotation(self.rightMarkerOuter.node, unpack(newRot));
			end;
			
			if self.rightMarkerPush ~= nil then
				local x, y, z = getTranslation(self.rightMarkerPush.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.rightMarkerPush.maxTrans, self.rightMarkerPush.minTrans, 3, self.rightMarkerPush.transTime, dt, not self.extendRight);
				setTranslation(self.rightMarkerPush.node, unpack(newTrans));
			end;
		end;
	end;
	
	if 	self.wingRotation <= self.minWingRotation then
		self.fullyExtended = true;
	else
		self.fullyExtended = false;
	end;
	
	-- Markers
	if self.attacherVehicle ~= nil then
		if self.leftMarkerDisc ~= nil and self.leftExtended then
			local axleSpeed = getRotation(self.wheels[2].repr)
			setRotation(self.leftMarkerDisc, axleSpeed*-1.3,0,0);
			
			if self.markerAreas[1] ~= nil then
				local x,y,z = getWorldTranslation(self.markerAreas[1].start);
				local x1,y1,z1 = getWorldTranslation(self.markerAreas[1].width);
				local x2,y2,z2 = getWorldTranslation(self.markerAreas[1].height);
				Utils.updatePloughArea(x, z, x1, z1, x2, z2, false,false,angle);
			end;
		end;
		if self.rightMarkerDisc ~= nil and self.rightExtended then
			local axleSpeed = getRotation(self.wheels[1].repr)
			setRotation(self.rightMarkerDisc, axleSpeed*-1.3,0,0);
			
			if self.markerAreas[2] ~= nil then
				local x,y,z = getWorldTranslation(self.markerAreas[2].start);
				local x1,y1,z1 = getWorldTranslation(self.markerAreas[2].width);
				local x2,y2,z2 = getWorldTranslation(self.markerAreas[2].height);
				Utils.updatePloughArea(x, z, x1, z1, x2, z2, false,false,angle);
			end;
		end;
	end;
	
	-- Seader wheels animation
	if self.attacherVehicle ~= nil then
		if self.boomsLowered then
			local axleSpeed1 = getRotation(self.wheels[1].repr);
			local axleSpeed2 = getRotation(self.wheels[2].repr);
			local axleSpeed3 = (axleSpeed1 + axleSpeed2)/2;
			
			-- Right wing
			if self.rightFrontDisc ~= nil then
				setRotation(self.rightFrontDisc, axleSpeed1*1.3,0,0);			
			end;
			
			if self.rightRearDisc ~= nil then
				setRotation(self.rightRearDisc, axleSpeed1*1.3,0,0);			
			end;
			
			if self.rightFrontLevelWheel ~= nil then
				setRotation(self.rightFrontLevelWheel, axleSpeed1*1.5,0,0);			
			end;
			
			if self.rightRearLevelWheel ~= nil then
				setRotation(self.rightRearLevelWheel, axleSpeed1*1.5,0,0);			
			end;
			
			if self.rightFrontCowerWheel ~= nil then
				setRotation(self.rightFrontCowerWheel, axleSpeed1*2,0,0);			
			end;
			
			if self.rightRearCowerWheel ~= nil then
				setRotation(self.rightRearCowerWheel, axleSpeed1*2,0,0);			
			end;

			-- Center
			if self.centerFrontDisc ~= nil then
				setRotation(self.centerFrontDisc, axleSpeed3*1.3,0,0);			
			end;
			
			if self.centerRearDisc ~= nil then
				setRotation(self.centerRearDisc, axleSpeed3*1.3,0,0);			
			end;
			
			if self.centerFrontLevelWheel ~= nil then
				setRotation(self.centerFrontLevelWheel, axleSpeed3*1.5,0,0);			
			end;
			
			if self.centerRearLevelWheel ~= nil then
				setRotation(self.centerRearLevelWheel, axleSpeed3*1.5,0,0);			
			end;
			
			if self.centerFrontCowerWheel ~= nil then
				setRotation(self.centerFrontCowerWheel, axleSpeed3*2,0,0);			
			end;
			
			if self.centerRearCowerWheel ~= nil then
				setRotation(self.centerRearCowerWheel, axleSpeed3*2,0,0);			
			end;
			
			-- left wing
			if self.leftFrontDisc ~= nil then
				setRotation(self.leftFrontDisc, axleSpeed2*1.3,0,0);			
			end;
			
			if self.leftRearDisc ~= nil then
				setRotation(self.leftRearDisc, axleSpeed2*1.3,0,0);			
			end;
			
			if self.leftFrontLevelWheel ~= nil then
				setRotation(self.leftFrontLevelWheel, axleSpeed2*1.5,0,0);			
			end;
			
			if self.leftRearLevelWheel ~= nil then
				setRotation(self.leftRearLevelWheel, axleSpeed2*1.5,0,0);			
			end;
			
			if self.leftFrontCowerWheel ~= nil then
				setRotation(self.leftFrontCowerWheel, axleSpeed2*2,0,0);			
			end;
			
			if self.leftRearCowerWheel ~= nil then
				setRotation(self.leftRearCowerWheel, axleSpeed2*2,0,0);			
			end;
		end;
	end;
	
	-- Dolly simulation
	if self.attacherVehicle ~= nil and self.simulatedDolly1 ~= nil then
		local axleSpeed1 = self.attacherVehicle.lastSpeed*3600;
		local axleSpeed2 = getWheelShapeAxleSpeed(self.wheels[1].node, self.wheels[1].wheelShape)*3.14/180; -- rad/sec


		local frontAngle = 0;
		 local x,y,z = worldDirectionToLocal(self.dollyJoint1, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
		local dot = z; -- 0*x + z*1;
		dot = dot / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x < 0 then
			angle = -angle;
		end;
		local startSpeed = self.steeringAxleAngleScaleStart;
		local endSpeed = self.steeringAxleAngleScaleEnd;
		local scale = Utils.clamp(1 + (self.lastSpeed*3600-startSpeed) * 1.0/(startSpeed-endSpeed), 0, 1);
		self.steeringAxleAngle = angle*scale;
		frontAngle = self.steeringAxleAngle;
		
		frontAngle = frontAngle * 0.70;
		
		if axleSpeed2 < 0 then
			frontAngle = frontAngle - 3.14;
		end;
		
		local adjustedRotation = frontAngle;
		if self.lastDolly1Rotation > frontAngle+0.1 or self.lastDolly1Rotation < frontAngle-0.1  then    
			if self.lastDolly1Rotation < frontAngle then
				adjustedRotation = self.lastDolly1Rotation - 0.6 * -1 * axleSpeed1/30;  
			elseif self.lastDolly1Rotation > frontAngle then
				adjustedRotation = self.lastDolly1Rotation + 0.6 * -1 * axleSpeed1/30;
			end;
		end;
		
		if self.wingRotation <= self.minWingRotation then
			setRotation(self.simulatedDolly1, 0, adjustedRotation, 0);
			self.lastDolly1Rotation = adjustedRotation;
		end;
	end;
	
	if self.attacherVehicle ~= nil and self.simulatedDolly2 ~= nil then
		local axleSpeed1 = self.attacherVehicle.lastSpeed*3600;
		local axleSpeed2 = getWheelShapeAxleSpeed(self.wheels[2].node, self.wheels[2].wheelShape)*3.14/180; -- rad/sec


		local frontAngle = 0;
		 local x,y,z = worldDirectionToLocal(self.dollyJoint2, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
		local dot = z; -- 0*x + z*1;
		dot = dot / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x < 0 then
			angle = -angle;
		end;
		local startSpeed = self.steeringAxleAngleScaleStart;
		local endSpeed = self.steeringAxleAngleScaleEnd;
		local scale = Utils.clamp(1 + (self.lastSpeed*3600-startSpeed) * 1.0/(startSpeed-endSpeed), 0, 1);
		self.steeringAxleAngle = angle*scale;
		frontAngle = self.steeringAxleAngle;
		
		frontAngle = frontAngle * 0.70;
		
		if axleSpeed2 < 0 then
			frontAngle = frontAngle - 3.14;
		end;
		
		local adjustedRotation = frontAngle;
		if self.lastDolly2Rotation > frontAngle+0.1 or self.lastDolly2Rotation < frontAngle-0.1  then    
			if self.lastDolly2Rotation < frontAngle then
				adjustedRotation = self.lastDolly2Rotation - 0.6 * -1 * axleSpeed1/30;  
			elseif self.lastDolly2Rotation > frontAngle then
				adjustedRotation = self.lastDolly2Rotation + 0.6 * -1 * axleSpeed1/30;
			end;
		end;
		
		if self.wingRotation <= self.minWingRotation then
			setRotation(self.simulatedDolly2, 0, adjustedRotation, 0);
			self.lastDolly2Rotation = adjustedRotation;
		end;
	end;
	
	-- Wheel rotation simulation
	
	if self.wingRotation <= self.minWingRotation then
		if self.simulatedWheel1 ~= nil then
			local x,y,z = getRotation(self.wheels[1].repr);
			setRotation(self.simulatedWheel1, x, y, z);
			local x2,y2,z2 = getTranslation(self.wheels[1].repr);
			local x3,y3,z3 = getTranslation(self.simulatedWheel1);
			setTranslation(self.simulatedWheel1, x3,y2,z3);
		end;
		
		if self.simulatedWheel2 ~= nil then
			local x,y,z = getRotation(self.wheels[2].repr);
			setRotation(self.simulatedWheel2, x, y, z);
			local x2,y2,z2 = getTranslation(self.wheels[2].repr);
			local x3,y3,z3 = getTranslation(self.simulatedWheel2);
			setTranslation(self.simulatedWheel2, x3,y2,z3);
		end;
	
		if self.simulatedWheel3 ~= nil then
			local x,y,z = getRotation(self.wheels[1].repr);
			setRotation(self.simulatedWheel3, x, y, z);
			local x2,y2,z2 = getTranslation(self.wheels[1].repr);
			local x3,y3,z3 = getTranslation(self.simulatedWheel3);
			setTranslation(self.simulatedWheel3, x3,y2,z3);
		end;
		
		if self.simulatedWheel4 ~= nil then
			local x,y,z = getRotation(self.wheels[2].repr);
			setRotation(self.simulatedWheel4, x, y, z);
			local x2,y2,z2 = getTranslation(self.wheels[2].repr);
			local x3,y3,z3 = getTranslation(self.simulatedWheel4);
			setTranslation(self.simulatedWheel4, x3,y2,z3);
		end;
	end;
	
	if self.simulatedWheel5 ~= nil then
		local x,y,z = getRotation(self.wheels[3].repr);
		setRotation(self.simulatedWheel5, x, y, z);
		local x2,y2,z2 = getTranslation(self.wheels[1].repr);
		local x3,y3,z3 = getTranslation(self.simulatedWheel5);
		setTranslation(self.simulatedWheel5, x3,y2,z3);		
	end;
	
	if self.simulatedWheel6 ~= nil then
		local x,y,z = getRotation(self.wheels[4].repr);
		setRotation(self.simulatedWheel6, x, y, z);
		local x2,y2,z2 = getTranslation(self.wheels[2].repr);
		local x3,y3,z3 = getTranslation(self.simulatedWheel6);
		setTranslation(self.simulatedWheel6, x3,y2,z3);
	end;
	
	-- Ground work sound
	if self.attacherVehicle ~= nil and self.attacherVehicle.attacherVehicle ~= nil and self.attacherVehicle.attacherVehicle.isEntered then
		if self.attacherVehicle.attacherVehicle.movingDirection ~= 0 and self.boomsLowered then
			self.groundWork = true;
		else
			self.GroundWorkPlaying = false;
			self.groundWork = false;
			if self.GroundWorkPlaying ~= nil then
				stopSample(self.GroundWorkSoundId);
			end;
		end;
	else
		self.groundWork = false;
	end;
	
	if self.attacherVehicle ~= nil and self.attacherVehicle.attacherVehicle ~= nil and not self.attacherVehicle.attacherVehicle.isEntered then
		if self.attacherVehicle.attacherVehicle.movingDirection ~= 0 and self.boomsLowered then
			setVisibility(self.externalGroundWorkSound, true);
			self.externalGroundWork = true;
		else
			setVisibility(self.externalGroundWorkSound, false);
			self.externalGroundWork = false;
		end;
	else
		setVisibility(self.externalGroundWorkSound, false);
		self.externalGroundWork = false;
	end;
	
	if self.groundWork and self:getIsActiveForSound() then
		if not self.GroundWorkPlaying then
			playSample(self.GroundWorkSoundId, 0, 1, 0);
			self.GroundWorkPlaying = true;
		end;
	else
		if self.GroundWorkPlaying then
			stopSample(self.GroundWorkSoundId);
			self.GroundWorkPlaying = false;
		end;
	end;
	
	if self.groundWork or self.externalGroundWork then
		Utils.setEmittingState(self.particleSystems1, true);
		Utils.setEmittingState(self.particleSystems2, true);
		Utils.setEmittingState(self.particleSystems3, true);
		Utils.setEmittingState(self.particleSystems4, true);
		Utils.setEmittingState(self.particleSystems5, true);
		Utils.setEmittingState(self.particleSystems6, true);
	else
		Utils.setEmittingState(self.particleSystems1, false);
		Utils.setEmittingState(self.particleSystems2, false);
		Utils.setEmittingState(self.particleSystems3, false);
		Utils.setEmittingState(self.particleSystems4, false);
		Utils.setEmittingState(self.particleSystems5, false);
		Utils.setEmittingState(self.particleSystems6, false);
	end;
	
	-- Hydraulics sound
	if self.attacherVehicle ~= nil and self.attacherVehicle.attacherVehicle ~= nil and self.attacherVehicle.attacherVehicle.isEntered then
		if not self.boomsLowered and not self.boomsRaised then
			self.hydraulicLiftersSound = true
		else
			self.hydraulicLiftersSound = false;
		end;
	else
		self.hydraulicLiftersSound = false;
	end;
	
	if (self.hydraulicLiftersSound or self.hydraulicSound) and self:getIsActiveForSound() then
		if not self.HydraulicPlaying then
			playSample(self.HydraulicSoundId, 0, 1, 0);
			self.HydraulicPlaying = true;
		end;
	else
		if self.HydraulicPlaying then
			stopSample(self.HydraulicSoundId);
			self.HydraulicPlaying = false;
		end;
	end;

	-- Speed monitoring
	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.attacherVehicle ~= nil then
			if self.fullyExtended and self.boomsLowered then
				if self.attacherVehicle.lastSpeed*3600 > self.speedlimit then
					self.speedViolationTimer = self.speedViolationTimer - dt;
				else
					self.speedViolationTimer = self.speedViolationMaxTime;
				end;
			end;
		end;
	end;
	
	
	if self.attacherVehicle ~= nil and self.attacherVehicle.airCart then	
		-- Establishing graintype in cart
		if self.attacherVehicle.attacherVehicle ~= nil then
			local frontTankFill = self.attacherVehicle.currentFrontFillType;
			local rearTankFill = self.attacherVehicle.currentRearFillType;
			
			self.currentSeedType = FruitUtil.FRUITTYPE_UNKNOWN;
			self.usingCartTankNo = -1;
			self.fertilize = false;
			
			if frontTankFill == rearTankFill and rearTankFill ~= FruitUtil.FRUITTYPE_FERTILIZER then
				self.currentSeedType = frontTankFill;
				self.usingCartTankNo = 1;
				self.fertilize = false;
			elseif frontTankFill == FruitUtil.FRUITTYPE_UNKNOWN and rearTankFill ~= FruitUtil.FRUITTYPE_FERTILIZER then
				self.currentSeedType = rearTankFill;
				self.usingCartTankNo = 2;
				self.fertilize = false;
			elseif rearTankFill == FruitUtil.FRUITTYPE_UNKNOWN and frontTankFill ~= FruitUtil.FRUITTYPE_FERTILIZER then
				self.currentSeedType = frontTankFill;
				self.usingCartTankNo = 1;
				self.fertilize = false;
			elseif frontTankFill == FruitUtil.FRUITTYPE_FERTILIZER and rearTankFill ~= FruitUtil.FRUITTYPE_UNKNOWN then
				self.currentSeedType = rearTankFill;
				self.usingCartTankNo = 2;
				self.fertilize = true;
			elseif rearTankFill == FruitUtil.FRUITTYPE_FERTILIZER and frontTankFill ~= FruitUtil.FRUITTYPE_UNKNOWN then
				self.currentSeedType = frontTankFill;
				self.usingCartTankNo = 1;
				self.fertilize = true;
			end;
		end;
			
		if self.noCombination then
			-- Harrowing
			if not self.seeding then
				if self.attacherVehicle.attacherVehicle ~= nil then
					if self.fullyExtended and self.boomsLowered and not self.attacherVehicle.attacherVehicle.isAITractorActivated then
						if self.speedViolationTimer > 0 and self.lastSpeed*3600 > 0.2 then
							for k, cuttingArea in pairs(self.cuttingAreas) do
								local x,y,z = getWorldTranslation(cuttingArea.start);
								local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
								local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
								Utils.updateCultivatorArea(x, z, x1, z1, x2, z2, false,false,angle);
							end;
						end;
					end;
				end;
			end;
			
			-- Seeding
			if self.seeding then
				if self.attacherVehicle.attacherVehicle ~= nil then
					if self.fullyExtended and self.boomsLowered then
						if self.speedViolationTimer > 0 and self.lastSpeed*3600 > 0.2 then
							for v,sowingArea in pairs(self.sowingAreas) do
								if self.currentSeedType ~= FruitUtil.FRUITTYPE_UNKNOWN and self.attacherVehicle.FanOn then
									local x,y,z = getWorldTranslation(sowingArea.start);
									local x1,y1,z1 = getWorldTranslation(sowingArea.width);
									local x2,y2,z2 = getWorldTranslation(sowingArea.height);
									local area = 0;
									
									area = Utils.updateSowingArea(self.currentSeedType, x, z, x1, z1, x2, z2,angle,true);
										
									local fruitDesc = FruitUtil.fruitIndexToDesc[self.currentSeedType];

									local pixelToSqm = g_currentMission:getTerrainDetailPixelsToSqm(); -- 8192px are mapped to 2048m
									local sqm = area*pixelToSqm;
									local ha = sqm/10000;
									local usage = fruitDesc.seedUsagePerSqm*sqm; 
									g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
									g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;

									g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
									g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;

									-- Retract used grain from cart
									if self.usingCartTankNo == 1 then
									  self.attacherVehicle.frontFillLevel = self.attacherVehicle.frontFillLevel - usage;
									  self.attacherVehicle:setFrontFillLevel(self.attacherVehicle.frontFillLevel, self.currentSeedType);
									elseif self.usingCartTankNo == 2 then
									  self.attacherVehicle.rearFillLevel = self.attacherVehicle.rearFillLevel - usage;
									  self.attacherVehicle:setRearFillLevel(self.attacherVehicle.rearFillLevel, self.currentSeedType);
									end;
									--Utils.updateCropsAt(x, z, x1, z1, x2, z2, 1.0);
									--Utils.updateGrassAt(x, z, x1, z1, x2, z2, 0.0);
									--Utils.updateCropsAt(x, z, x1, z1, x2, z2, 0.0);
									-- Fertilize
									if self.fertilize then
										Utils.updateSprayArea(x, z, x1, z1, x2, z2);
										-- Retract used fertilizer from cart
										if self.usingCartTankNo == 1 then
										  self.attacherVehicle.rearFillLevel = self.attacherVehicle.rearFillLevel - (usage * 0.8);
										  self.attacherVehicle:setRearFillLevel(self.attacherVehicle.rearFillLevel, self.currentSeedType);
										elseif self.usingCartTankNo == 2 then
										  self.attacherVehicle.frontFillLevel = self.attacherVehicle.frontFillLevel - (usage * 0.8);
										  self.attacherVehicle:setFrontFillLevel(self.attacherVehicle.frontFillLevel, self.currentSeedType);
										end;
									end;
								end;
							end;
							g_currentMission.missionStats.seedingDurationTotal = g_currentMission.missionStats.seedingDurationTotal + dt/(1000*60);
							g_currentMission.missionStats.seedingDurationSession = g_currentMission.missionStats.seedingDurationSession + dt/(1000*60);
						end;
					end;
				end;
			end;
		else
			if self.attacherVehicle.attacherVehicle ~= nil then
				if self.fullyExtended and self.boomsLowered then
					if self.speedViolationTimer > 0 then
						for k, combinationArea in pairs(self.combinationAreas) do
							if self.currentSeedType ~= FruitUtil.FRUITTYPE_UNKNOWN and self.attacherVehicle.FanOn then
								local x,y,z = getWorldTranslation(combinationArea.start);
								local x1,y1,z1 = getWorldTranslation(combinationArea.width);
								local x2,y2,z2 = getWorldTranslation(combinationArea.height);
								local area = 0;
								
								if not self.attacherVehicle.attacherVehicle.isAITractorActivated then
									Utils.updateCultivatorArea(x, z, x1, z1, x2, z2, false,false,angle);
								end;
								area = Utils.updateSowingArea(self.currentSeedType, x, z, x1, z1, x2, z2,angle,true);

								local fruitDesc = FruitUtil.fruitIndexToDesc[self.currentSeedType];

								local pixelToSqm = g_currentMission:getTerrainDetailPixelsToSqm(); -- 8192px are mapped to 2048m
								local sqm = area*pixelToSqm;
								local ha = sqm/10000;
								local usage = fruitDesc.seedUsagePerSqm*sqm; 
								g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
								g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;

								g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
								g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;

								-- Retract used grain from cart
								if self.usingCartTankNo == 1 then
								  self.attacherVehicle.frontFillLevel = self.attacherVehicle.frontFillLevel - usage;
								  self.attacherVehicle:setFrontFillLevel(self.attacherVehicle.frontFillLevel, self.currentSeedType);
								elseif self.usingCartTankNo == 2 then
								  self.attacherVehicle.rearFillLevel = self.attacherVehicle.rearFillLevel - usage;
								  self.attacherVehicle:setRearFillLevel(self.attacherVehicle.rearFillLevel, self.currentSeedType);
								end;
								--Utils.updateCropsAt(x, z, x1, z1, x2, z2, 1.0);
								--Utils.updateGrassAt(x, z, x1, z1, x2, z2, 0.0);
								--Utils.updateCropsAt(x, z, x1, z1, x2, z2, 0.0);
								-- Fertilize
								if self.fertilize then
									Utils.updateSprayArea(x, z, x1, z1, x2, z2);
									-- Retract used fertilizer from cart
									if self.usingCartTankNo == 1 then
									  self.attacherVehicle.rearFillLevel = self.attacherVehicle.rearFillLevel - (usage * 0.8);
									  self.attacherVehicle:setRearFillLevel(self.attacherVehicle.rearFillLevel, self.currentSeedType);
									elseif self.usingCartTankNo == 2 then
									  self.attacherVehicle.frontFillLevel = self.attacherVehicle.frontFillLevel - (usage * 0.8);
									  self.attacherVehicle:setFrontFillLevel(self.attacherVehicle.frontFillLevel, self.currentSeedType);
									end;
								end;
							end;
						end;
						g_currentMission.missionStats.seedingDurationTotal = g_currentMission.missionStats.seedingDurationTotal + dt/(1000*60);
						g_currentMission.missionStats.seedingDurationSession = g_currentMission.missionStats.seedingDurationSession + dt/(1000*60);
					end;
				end;
			end;
		end;
		
	end;
	self.seeding = not self.seeding;
end;

function Airseeder:draw()
	if self.attacherVehicle ~= nil and self.attacherVehicle.airCart and self.attacherVehicle.hudOn >= 2 then
		-- Status texts
		setTextColor(1, 1, 1, 1.0);
		setTextBold(false);
		if self.boomsLowered then
			renderText(0.76, 0.57, 0.020, string.format("Raise seed openers ["..self.keyType(InputBinding.JD1890LOWER).."]"));
		else
			renderText(0.76, 0.57, 0.020, string.format("Lower seed openers ["..self.keyType(InputBinding.JD1890LOWER).."]"));
		end;
		
		renderText(0.76, 0.55, 0.020, string.format("Fold seeder boom ["..self.keyType(InputBinding.JD1890FOLD).."]"));
		
		renderText(0.76, 0.53, 0.020, string.format("Unfold seeder boom ["..self.keyType(InputBinding.JD1890UNFOLD).."]"));
		
		if self.autoMarkersEnabled then
			renderText(0.76, 0.51, 0.020, string.format("Aut. marker off ["..self.keyType(InputBinding.JD1890AUTOMARKERS).."]"));
		else
			renderText(0.76, 0.51, 0.020, string.format("Aut. marker on ["..self.keyType(InputBinding.JD1890AUTOMARKERS).."]"));
		end;
		
		if self.markerPos == 1 then
			renderText(0.76, 0.49, 0.020, string.format("Retract markers ["..self.keyType(InputBinding.JD1890MAKERTRANSPORT).."]"));
			renderText(0.76, 0.47, 0.020, string.format("Right Marker ["..self.keyType(InputBinding.JD1890MAKERRIGHT).."]"));
		elseif self.markerPos == 2 or self.markerPos == 0 then
			renderText(0.76, 0.49, 0.020, string.format("Left Marker ["..self.keyType(InputBinding.JD1890MAKERLEFT).."]"));
			renderText(0.76, 0.47, 0.020, string.format("Right Marker ["..self.keyType(InputBinding.JD1890MAKERRIGHT).."]"));
		elseif self.markerPos == 3 then
			renderText(0.76, 0.49, 0.020, string.format("Retract markers ["..self.keyType(InputBinding.JD1890MAKERTRANSPORT).."]"));
			renderText(0.76, 0.47, 0.020, string.format("Left Marker ["..self.keyType(InputBinding.JD1890MAKERLEFT).."]"));
		end;
	end;
	
	if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
		if self.attacherVehicle ~= nil and self.fullyExtended and self.boomsLowered then
			g_currentMission:addWarning("You are driving too fast to sow", 0.07+0.022, 0.019+0.029);
		end;
    end;
	 
	if self.attacherVehicle ~= nil and not self.attacherVehicle.airCart then
		g_currentMission:addWarning("You must attach aircart in front of seeder", 0.07+0.022, 0.019+0.029);
	end;
end;

function Airseeder:onDetach()
end;

function Airseeder:onLeave()
end;

function Airseeder:onDeactivate()
end;

function Airseeder:onDeactivateSounds()
end;
