---
---
--- specializations for KuhnHrb503
--- @Autor Fendt413	edited by matto135
--- @Date 3/01/10


KuhnHrb503 = {};

function KuhnHrb503.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;
function KuhnHrb503:load(xmlFile)
-- Annimation Fraise
    self.rotors = {};

    local psFile = getXMLString(xmlFile, "vehicle.rotors.rotor(1)#index");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.rotors.rotor(%d)", i);
            local node = {};
            node.index = getXMLString(xmlFile, baseName.. "#index");
            node.direction = getXMLInt(xmlFile, baseName.. "#direction");
            if node.index == nil then
                break;
            end;
            node.index = Utils.indexToObject(self.components, node.index);
            if node ~= nil then
                table.insert(self.rotors, node);
            end;
            i = i+1;
        end;
    end;
	
	local rotationNodePartRAR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRAR#index"));
    if rotationNodePartRAR ~= nil then
        self.rotationPartRAR = {};
        self.rotationPartRAR.node = rotationNodePartRAR;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR#minRot"));
        self.rotationPartRAR.minRot = {};
        self.rotationPartRAR.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR#maxRot"));
        self.rotationPartRAR.maxRot = {};
        self.rotationPartRAR.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRAR.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR#rotTime"), 2)*1000;
        self.rotationPartRAR.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR#touchRotLimit"), 10));
    end;  	

	local rotationNodePartRAR2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRAR2#index"));
    if rotationNodePartRAR2 ~= nil then
        self.rotationPartRAR2 = {};
        self.rotationPartRAR2.node = rotationNodePartRAR2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR2#minRot"));
        self.rotationPartRAR2.minRot = {};
        self.rotationPartRAR2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR2#maxRot"));
        self.rotationPartRAR2.maxRot = {};
        self.rotationPartRAR2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRAR2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR2#rotTime"), 2)*1000;
        self.rotationPartRAR2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR2#touchRotLimit"), 10));
    end; 
	local rotationNodePartRAR3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRAR3#index"));
    if rotationNodePartRAR3 ~= nil then
        self.rotationPartRAR3 = {};
        self.rotationPartRAR3.node = rotationNodePartRAR3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR3#minRot"));
        self.rotationPartRAR3.minRot = {};
        self.rotationPartRAR3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR3#maxRot"));
        self.rotationPartRAR3.maxRot = {};
        self.rotationPartRAR3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRAR3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR3#rotTime"), 2)*1000;
        self.rotationPartRAR3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR3#touchRotLimit"), 10));
    end; 
	local rotationNodePartRAR4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRAR4#index"));
    if rotationNodePartRAR4 ~= nil then
        self.rotationPartRAR4 = {};
        self.rotationPartRAR4.node = rotationNodePartRAR4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR4#minRot"));
        self.rotationPartRAR4.minRot = {};
        self.rotationPartRAR4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR4#maxRot"));
        self.rotationPartRAR4.maxRot = {};
        self.rotationPartRAR4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRAR4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR4#rotTime"), 2)*1000;
        self.rotationPartRAR4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR4#touchRotLimit"), 10));
    end;  	
	local rotationNodePartRAR5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRAR5#index"));
    if rotationNodePartRAR5 ~= nil then
        self.rotationPartRAR5 = {};
        self.rotationPartRAR5.node = rotationNodePartRAR5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR5#minRot"));
        self.rotationPartRAR5.minRot = {};
        self.rotationPartRAR5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR5#maxRot"));
        self.rotationPartRAR5.maxRot = {};
        self.rotationPartRAR5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRAR5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR5#rotTime"), 2)*1000;
        self.rotationPartRAR5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR5#touchRotLimit"), 10));
    end;  
	local rotationNodePartRAR6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRAR6#index"));
    if rotationNodePartRAR6 ~= nil then
        self.rotationPartRAR6 = {};
        self.rotationPartRAR6.node = rotationNodePartRAR6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR6#minRot"));
        self.rotationPartRAR6.minRot = {};
        self.rotationPartRAR6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRAR6#maxRot"));
        self.rotationPartRAR6.maxRot = {};
        self.rotationPartRAR6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRAR6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRAR6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRAR6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR6#rotTime"), 2)*1000;
        self.rotationPartRAR6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRAR6#touchRotLimit"), 10));
    end;  		
	local translationNodeVerrain1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationVerrain1#index"));
    if translationNodeVerrain1 ~= nil then
        self.translationVerrain1 = {};
        self.translationVerrain1.node = translationNodeVerrain1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain1#minTrans"));
        self.translationVerrain1.minTrans = {};
        self.translationVerrain1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationVerrain1#maxTrans"));
        self.translationVerrain1.maxTrans = {};
        self.translationVerrain1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationVerrain1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationVerrain1.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationVerrain1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain1#transTime"), 2)*1000;
        self.translationVerrain1.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationVerrain1#touchTransLimit"), 10);
    end; 
	------ Son -----
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	
	self.drum1= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index1"));
	self.drum2= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index2"));
        self.drum3= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index3"));
    self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);
end;
function KuhnHrb503:delete()
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;
function KuhnHrb503:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KuhnHrb503:keyEvent(unicode, sym, modifier, isDown)
	if sym == Input.KEY_KP_1 then
		self.rotationMaxRAR = isDown;
		self.rotationMaxRAR2 = isDown;
		self.rotationMaxRAR3 = isDown;
		self.rotationMaxRAR4 = isDown;
		self.rotationMaxRAR5 = isDown;
		self.rotationMaxRAR6 = isDown;
		self.translationMax = isDown;
	end;
	if sym == Input.KEY_KP_0 then
		self.rotationMinRAR = isDown;
		self.rotationMinRAR2 = isDown;
		self.rotationMinRAR3 = isDown;
		self.rotationMinRAR4 = isDown;
		self.rotationMinRAR5 = isDown;
		self.rotationMinRAR6 = isDown;
		self.translationMin = isDown;
	end;	
end;

function KuhnHrb503:update(dt)
	if self:getIsActive() then
	-- Animation
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				self.isTurnedOn = not self.isTurnedOn;
			end;
		end;
		
		if self.isTurnedOn then
			for i=1, table.getn(self.rotors) do
				local rotor = self.rotors[i].index;
				local rotorRot = (-0.04*self.rotors[i].direction)*dt;
				rotate(rotor, 0, rotorRot, 0);
			end;
			if not self.workSoundEnabled and self:getIsActiveForSound() then
				playSample(self.workSound, 0, self.workSoundVolume, 0);
				setSamplePitch(self.workSound, self.workSoundPitchOffset);
				self.workSoundEnabled = true;
			end;	
		else
			if self.workSoundEnabled then
				stopSample(self.workSound);
				self.workSoundEnabled = false;
			end;

		end;
		--if self:isLowered(false) and self.isTurnedOn then
		--local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
		--	local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
		--local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
		--	Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);	
		--end;

		local doRotate = self.rotationMaxRAR or self.rotationMinRAR
		if self.rotationPartRAR ~= nil and doRotate then
			local x, y, z = getRotation(self.rotationPartRAR.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRAR.maxRot, self.rotationPartRAR.minRot, 3, self.rotationPartRAR.rotTime, dt, not self.rotationMaxRAR);
			setRotation(self.rotationPartRAR.node, unpack(newRot));
		end;
		local doRotate = self.rotationMaxRAR2 or self.rotationMinRAR2
		if self.rotationPartRAR2 ~= nil and doRotate then
			local x, y, z = getRotation(self.rotationPartRAR2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRAR2.maxRot, self.rotationPartRAR2.minRot, 3, self.rotationPartRAR2.rotTime, dt, not self.rotationMaxRAR2);
			setRotation(self.rotationPartRAR2.node, unpack(newRot));
		end;
		local doRotate = self.rotationMaxRAR3 or self.rotationMinRAR3
		if self.rotationPartRAR3 ~= nil and doRotate then
			local x, y, z = getRotation(self.rotationPartRAR3.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRAR3.maxRot, self.rotationPartRAR3.minRot, 3, self.rotationPartRAR3.rotTime, dt, not self.rotationMaxRAR3);
			setRotation(self.rotationPartRAR3.node, unpack(newRot));
		end;
		local doRotate = self.rotationMaxRAR4 or self.rotationMinRAR4
		if self.rotationPartRAR4 ~= nil and doRotate then
			local x, y, z = getRotation(self.rotationPartRAR4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRAR4.maxRot, self.rotationPartRAR4.minRot, 3, self.rotationPartRAR4.rotTime, dt, not self.rotationMaxRAR4);
			setRotation(self.rotationPartRAR4.node, unpack(newRot));
		end;
		local doRotate = self.rotationMaxRAR5 or self.rotationMinRAR5
		if self.rotationPartRAR5 ~= nil and doRotate then
			local x, y, z = getRotation(self.rotationPartRAR5.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRAR5.maxRot, self.rotationPartRAR5.minRot, 3, self.rotationPartRAR5.rotTime, dt, not self.rotationMaxRAR5);
			setRotation(self.rotationPartRAR5.node, unpack(newRot));
		end;
		local doRotate = self.rotationMaxRAR6 or self.rotationMinRAR6
		if self.rotationPartRAR6 ~= nil and doRotate then
			local x, y, z = getRotation(self.rotationPartRAR6.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRAR6.maxRot, self.rotationPartRAR6.minRot, 3, self.rotationPartRAR6.rotTime, dt, not self.rotationMaxRAR6);
			setRotation(self.rotationPartRAR6.node, unpack(newRot));
		end;
		local doTranslate = self.translationMax or self.translationMin
		if self.translationVerrain1 ~= nil and doTranslate then 
			local x, y, z = getTranslation(self.translationVerrain1.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationVerrain1.maxTrans, self.translationVerrain1.minTrans, 3, self.translationVerrain1.transTime, dt, not self.translationMax); 
			setTranslation(self.translationVerrain1.node, unpack(newTrans)); 
		end;
	else 
		if self.workSoundEnabled then
			stopSample(self.workSound);
			self.workSoundEnabled = false;
		end;
	end;	
	if self.drum1 ~= nil and self.isTurnedOn then
		rotate(self.drum1, 0, 0, self.drumRotationScale* 3);
	end;	
	if self.drum2 ~= nil and self.isTurnedOn  then
		rotate(self.drum2, 0, 0, self.drumRotationScale* 3);
	end;
        if self.drum3 ~= nil and self.isTurnedOn  then
		rotate(self.drum3, 0, 0, self.drumRotationScale* 3);
	end;		
end;


function KuhnHrb503:draw()
	g_currentMission:addExtraPrintText("Tasto B: attiva/disattiva presa di forza");
end;

function KuhnHrb503:onDetach()
    self.hasGroundContact = false;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;	
	self.isTurnedOn = false;
end;

function KuhnHrb503:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;