SetParticleState = {};
SetParticleState_mt = Class(SetParticleState, Event);

InitEventClass(SetParticleState, "SetParticleState");

function SetParticleState:emptyNew()
    local self = Event:new(SetParticleState_mt);
    self.className = "SetParticleState";
    return self;
end;

function SetParticleState:new(object, state)
    local self = SetParticleState:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetParticleState:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetParticleState:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetParticleState:run(connection)
	self.object:setParticleState(self.state, true)
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetParticleState:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetParticleState.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.particleState then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetParticleState:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetParticleState:new(vehicle, state));
			end;
		end;
	end;
end;

