KuhnDiscoverXL60 = {};

function KuhnDiscoverXL60.prerequisitesPresent(specializations)
	return true;
end;

function KuhnDiscoverXL60:load(xmlFile)

	self.setSoundState = SpecializationUtil.callSpecializationsFunction("setSoundState");
	self.setParticleState = SpecializationUtil.callSpecializationsFunction("setParticleState");
	self.setDirtScale = SpecializationUtil.callSpecializationsFunction("setDirtScale");
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
	self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
	  
	self.particleSystems = {};
	local particleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.ParticleSystems#count"), 0);
	for i = 1, particleSystemCount do
		local namei = string.format("vehicle.ParticleSystems.ParticleSystem%d", i);
		self.particleSystems[i] = {};
		self.particleSystems[i].ps = {};
		self.particleSystems[i].node = {};
		self.particleSystems[i].rain = {};
		self.particleSystems[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#node"));
		self.particleSystems[i].rain = Utils.getNoNil(getXMLBool(xmlFile, namei .. "#deactivateOnRain"), false);
		Utils.loadParticleSystem(xmlFile, self.particleSystems[i].ps, namei, self.components, false, nil, self.baseDirectory);
	end;
	self.particleState = false;
	
	local discCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.discHarrows#count"), 0);
	self.discHarrows = {};
	for i = 1, discCount do
		local name = string.format("vehicle.discHarrows.discHarrow%d", i);
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, name .. "#node"));
		if node == nil then
			print("discHarrows count ~= discHarrow nodes");
			return;
		else
			self.discHarrows[i] = {};
			self.discHarrows[i].speed = 0;
			self.discHarrows[i].node = node;
			self.discHarrows[i].offset = Utils.getNoNil(getXMLFloat(xmlFile, name .. "#offset"), 0);
			self.discHarrows[i].rotScale = Utils.getNoNil(getXMLFloat(xmlFile, name .. "#rotScale"), 1);
		end;
	end;
	
	local sDiscCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.stabilisingDiscs#count"), 0);
	self.stabilisingDiscs = {};
	for i = 1, sDiscCount do
		local name = string.format("vehicle.stabilisingDiscs.stabilisingDisc%d", i);
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, name .. "#node"));
		if node == nil then
			print("stabilisingDiscs count ~= stabilisingDisc nodes");
			return;
		else
		  self.stabilisingDiscs[i] = {};
		  self.stabilisingDiscs[i].speed = 0;
		  self.stabilisingDiscs[i].node = node;
		  self.stabilisingDiscs[i].offset = Utils.getNoNil(getXMLFloat(xmlFile, name .. "#offset"), 0);
		  self.stabilisingDiscs[i].rotScale = Utils.getNoNil(getXMLFloat(xmlFile, name .. "#rotScale"), 1);
		end;
	end;
	
	local cultivatorSound = getXMLString(xmlFile, "vehicle.cultivatorSound#file");
	if cultivatorSound ~= nil and cultivatorSound ~= "" then
		cultivatorSound = Utils.getFilename(cultivatorSound, self.baseDirectory);
		self.cultivatorSound = createSample("cultivatorSound");
		loadSample(self.cultivatorSound, cultivatorSound, false);
		self.cultivatorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#pitchOffset"), 0);
		self.cultivatorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#volume"), 1);
		self.cultivatorSoundEnabled = false;
	end;
	
	self.aiTerrainDetailChannel1 = g_currentMission.ploughChannel;
	self.aiTerrainDetailChannel2 = g_currentMission.sowingChannel;
	self.speedViolationMaxTime = 5000;
	self.speedViolationTimer = self.speedViolationMaxTime;
	self.saveLeftAi = self.aiLeftMarker;
	self:setDirtScale(0.3, 20);
	
	self.cultivatorLimitToField = false;
	self.cultivatorForceLimitToField = true;
	
end

function KuhnDiscoverXL60:delete()
	for k, v in pairs(self.particleSystems) do
		Utils.deleteParticleSystem(v.ps);
	end;
	if self.cultivatorSound ~= nil then
		delete(self.cultivatorSound);
	end;
end;

function KuhnDiscoverXL60:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KuhnDiscoverXL60:keyEvent(unicode, sym, modifier, isDown)
end;

function KuhnDiscoverXL60:update(dt)

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].startPosition);
			else
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			if self.attacherVehicle ~= nil then
				for k,v in pairs(self.attacherVehicle.attachedImplements) do
					if v.object == self then
						local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
						joint.moveDown = false;
					end;
				end;
			end;
			self:setAnimationTime(2, self.animationParts[2].startPosition);
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].startPosition);
			else
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
	end;
	
	if self.attacherVehicle ~= nil and self.attacherVehicle.isAITractorActivated then
		self.attacherVehicle.aiTurnNoBackward = true;
		self.attacherVehicle.turnEndBackDistance = 14;
		if self.attacherVehicle.turnStage == 5 then
			setTranslation(self.aiBackMarker, 0, 0, 0);
		else
			setTranslation(self.aiBackMarker, 0, 0, -4);
		end;
	end;
	
	if self.animationParts[1].clipEndTime then
		if self.attacherVehicle then
			self.aiLeftMarker = self.saveLeftAi;
			AITractor.updateToolsInfo(self.attacherVehicle);
		end;
		for k,v in pairs(self.discHarrows) do
			local x, y, z = getWorldTranslation(v.node);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			if y + v.offset <= terrainHeight then
				v.speed = v.rotScale * self.lastSpeedReal * self.movingDirection * dt;
			elseif v.rotScale > 0 then
				v.speed = math.max(v.speed - dt / 5000, 0);
			else
				v.speed = math.min(v.speed + dt / 5000, 0);
			end;
			rotate(v.node, 0, 0, v.speed);
		end;
		for k,v in pairs(self.stabilisingDiscs) do
			local x, y, z = getWorldTranslation(v.node);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			if y + v.offset <= terrainHeight then
				v.speed = v.rotScale * self.lastSpeedReal * self.movingDirection * dt;
			elseif v.rotScale > 0 then
				v.speed = math.max(v.speed - dt / 9000, 0);
			else
				v.speed = math.min(v.speed + dt / 9000, 0);
			end;
			rotate(v.node, 0, v.speed, 0);
		end;
		if self.animationParts[2].currentPosition > 1100 then
			if self.lastSpeed * 3600 > 3 then
				self:setSoundState(self:getIsActiveForSound());
			else
				self:setSoundState(false);
				self:setParticleState(false);
			end;
			if self:doCheckSpeedLimit() and self.lastSpeed * 3600 > 30 then
				self.speedViolationTimer = self.speedViolationTimer - dt;
				if self.isServer then
					if self.speedViolationTimer < 0 and self.attacherVehicle then
						self.attacherVehicle:detachImplementByObject(self);
					end;
				end;
			else
				self.speedViolationTimer = self.speedViolationMaxTime;
				local area = 0;
				if self.isServer then
					local cuttingAreasSend = {};
					for k, cuttingArea in pairs(self.cuttingAreas) do
						if self:getIsAreaActive(cuttingArea) then
							local x,y,z = getWorldTranslation(cuttingArea.start);
							local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
							local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
							table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
							area = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, x, z, x1, z1, x2, z2);
						end;
					end;
					if table.getn(cuttingAreasSend) > 0 then
						local limitToField = self.cultivatorLimitToField or self.cultivatorForceLimitToField;
						if not g_currentMission.allowClientsCreateFields then
							local owner = self:getOwner();
							if owner ~= nil and not owner:getIsLocal() then
								limitToField = true;
							end;
						end;
						if self.isAITractorActivated then
							limitToField = true;
						end;
						if self:getIsActiveForInput() then
							if Input.isKeyPressed(Input.KEY_shift) then
								limitToField = false;
							end;
						end;
						CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField);
						g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField));
					end;
					if area > 2 then
						self:setDirtScale(0.1, 100000);
						if self.lastSpeed * 3600 > 8 then
							self:setParticleState(true);
						else
							self:setParticleState(false);
						end;
					else
						self:setDirtScale(100000, 20);
						self:setParticleState(false);
					end;
				end;
			end;
		else
			self:setSoundState(false);
			self:setParticleState(false);
			self:setDirtScale(100000, 20);
		end;
	else
		if self.attacherVehicle then
			self.aiLeftMarker = nil;
			AITractor.updateToolsInfo(self.attacherVehicle);
		end;
		self:setSoundState(false);
		self:setParticleState(false);
		self:setAnimationTime(2, self.animationParts[2].startPosition);
		self:setDirtScale(100000, 20);
	end;
end;

function KuhnDiscoverXL60:setSoundState(state)
	if state == true then
		if self.cultivatorSound ~= nil and not self.cultivatorSoundEnabled then
			playSample(self.cultivatorSound, 0, self.cultivatorSoundVolume, 0);
			setSamplePitch(self.cultivatorSound, self.cultivatorSoundPitchOffset);
		end;
		self.cultivatorSoundEnabled = true;
	elseif state == false then
		if self.cultivatorSoundEnabled and self.cultivatorSound ~= nil then
			stopSample(self.cultivatorSound);
		end;
		self.cultivatorSoundEnabled = false;
	end;
end;

function KuhnDiscoverXL60:setParticleState(state, noEventSend)
	SetParticleState.sendEvent(self, state, noEventSend);
	for k, v in pairs(self.particleSystems) do
		if v.rain then
			if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 40 then
				Utils.setEmittingState(v.ps, state);
			else
				Utils.setEmittingState(v.ps, false);
			end;
		else
			Utils.setEmittingState(v.ps, state);
		end;
	end;
	self.particleState = state;
end;

function KuhnDiscoverXL60:setDirtScale(dirt, clean)
	if self.attacherVehicle and (self.attacherVehicle.isEntered or self.attacherVehicle.isControlled) then
		self.dirtInterval = dirt * 60 * 60 * 1000;
		self.cleaningInterval = clean * 1000;
	end;
end;

function KuhnDiscoverXL60:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	self:setAnimationTime(2, self.animationParts[2].startPosition);
end;

function KuhnDiscoverXL60:onDetach()
	KuhnDiscoverXL60.onDeactivate(self);
end;

function KuhnDiscoverXL60:draw()
	if self.animationParts[1].clipEndTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("Discover1"), InputBinding.IMPLEMENT_EXTRA);
	elseif self.animationParts[1].clipStartTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("Discover2"), InputBinding.IMPLEMENT_EXTRA);
	end;
	if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 5 then
		g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
	end;
end;

function KuhnDiscoverXL60:aiTurnOn()
	self:setAnimationTime(2, self.animationParts[2].animDuration);
end;

function KuhnDiscoverXL60:aiTurnOff()
	self:setAnimationTime(2, self.animationParts[2].startPosition);
end;

function KuhnDiscoverXL60:aiLower()
	self:setAnimationTime(2, self.animationParts[2].animDuration);
end;

function KuhnDiscoverXL60:aiRaise()
	self:setAnimationTime(2, self.animationParts[2].startPosition);
end;

function KuhnDiscoverXL60:onDeactivate()
	self.speedViolationTimer = self.speedViolationMaxTime;
	KuhnDiscoverXL60.onDeactivateSounds(self);
end;

function KuhnDiscoverXL60:onDeactivateSounds()
	self:setSoundState(false);
end;


