CylinderDirection = {};

function CylinderDirection.prerequisitesPresent(specializations)
    return true;
end;

function CylinderDirection:load(xmlFile)

	self.cylinders = {};
	local i = 0;
	while true do
		local nameStr = string.format("vehicle.hydraulicCylinders.hydraulicCylinder(%d)", i);
        local cylinder = {};
        local cylinderStr = getXMLString(xmlFile, nameStr .. "#cylinder");
        if cylinderStr == nil then
            break;
        end;
        cylinder.index = Utils.indexToObject(self.components, cylinderStr);
        cylinder.directionFix = Utils.indexToObject(self.components, getXMLString(xmlFile, nameStr .. "#cylinderFix"));
		cylinder.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, nameStr .. "#punch"));
		if cylinder.punch ~= nil then
			cylinder.translationFix = Utils.indexToObject(self.components, getXMLString(xmlFile, nameStr .. "#punchFix"));
			local ax, ay, az = getWorldTranslation(cylinder.punch);
			local bx, by, bz = getWorldTranslation(cylinder.translationFix);		
			cylinder.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		cylinder.scalePunch = Utils.getNoNil(getXMLBool(xmlFile, nameStr .. "#scale"), false);
		table.insert(self.cylinders, cylinder);
		i = i + 1;
	end;
end;

function CylinderDirection:delete()
end;

function CylinderDirection:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CylinderDirection:keyEvent(unicode, sym, modifier, isDown)
end;

function CylinderDirection:readStream(streamId, connection)
end;

function CylinderDirection:writeStream(streamId, connection)
end;

function CylinderDirection:update(dt)
end;

function CylinderDirection:updateTick(dt)
	for _, cylinder in pairs(self.cylinders) do
		local ax, ay, az = getWorldTranslation(cylinder.index);
		local bx, by, bz = getWorldTranslation(cylinder.directionFix);
		local x, y, z = worldDirectionToLocal(getParent(cylinder.index), bx-ax, by-ay, bz-az);
		local xU, yU, zU = 0, 1, 0;
		if math.abs(y) > 0.99 * Utils.vector3Length(x, y, z) then
			yU = 0;
			if y > 0 then
				zU = 1;
			else
				zU = -1;
			end;
		end;
		setDirection(cylinder.index, x, y, z, xU, yU, zU);
		if cylinder.punchDistance ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if cylinder.scalePunch then
				local xS, yS, zS = getScale(cylinder.punch);
				local newS = xS * (distance / cylinder.punchDistance);
				setScale(cylinder.punch, xS, yS, newS);
			else
				setTranslation(cylinder.punch, 0, 0, distance-cylinder.punchDistance);
			end;
		end;
	end;
end;

function CylinderDirection:draw()
end;