--
-- krone900
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @date  		11/10/10
--

krone900 = {};

function krone900.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(kroneWindrower, specializations) and SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function krone900:load(xmlFile)

	self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, krone900.getIsAreaActive);	
	self.setIsArmDown = SpecializationUtil.callSpecializationsFunction("setIsArmDown");
	self.setTransport = SpecializationUtil.callSpecializationsFunction("setTransport");

	self.steeringAnimations = {};
	self.steeringAnimations.axes = {};
	local i = 0;
    while true do
        local partName = string.format("vehicle.steeringAnimation.axis(%d)", i);
		local axis = {};
        local index = getXMLString(xmlFile, partName .. "#index");
        if index == nil then
            break;
        end;
		axis.node = Utils.indexToObject(self.components, index);
		axis.wheel = self.wheels[getXMLInt(xmlFile, partName .. "#wheelIndex")];
		if axis.wheel ~= nil then
			table.insert(self.steeringAnimations.axes, axis);
		else
			print("Error: Could not found wheel index!");
		end;		
        i = i+1;
	end;
	self.steeringAnimations.middleController = {};
	self.steeringAnimations.middleController.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringAnimation#middleController"));
	self.steeringAnimations.middleController.minTrans = getXMLFloat(xmlFile, "vehicle.steeringAnimation#minTrans");
	self.steeringAnimations.middleController.maxTrans = getXMLFloat(xmlFile, "vehicle.steeringAnimation#maxTrans");
	
	self.rowerFoldingParts = {};
	local i = 0;
    while true do
        local partName = string.format("vehicle.rowerFoldingParts.part(%d)", i);
		local part = {};
        local joint = getXMLInt(xmlFile, partName .. ".mainPart#joint");
        if joint == nil then
            break;
        end;
		local mainPart = {};
		mainPart.joint = self.componentJoints[joint];
		mainPart.minRot = {};
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partName .. ".mainPart#minRot"));
        mainPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        mainPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        mainPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		mainPart.maxRot = {};
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partName .. ".mainPart#maxRot"));
        mainPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        mainPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        mainPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
		mainPart.maxLimit = {};
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partName .. ".mainPart#maxLimit"));
        mainPart.maxLimit[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        mainPart.maxLimit[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        mainPart.maxLimit[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		mainPart.currentLimit = {0, 0, 0};
		mainPart.isDown = false;
		mainPart.transNode = Utils.indexToObject(self.components, getXMLString(xmlFile, partName .. ".mainPart#transNode"));
		mainPart.minTrans = {getXMLFloat(xmlFile, partName .. ".mainPart#minTrans")};
		mainPart.maxTrans = {getXMLFloat(xmlFile, partName .. ".mainPart#maxTrans")};

		local rower = {};
		rower.joint = self.componentJoints[getXMLInt(xmlFile, partName .. ".rower#joint")];
		rower.maxLimit = {};
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partName .. ".rower#maxLimit"));
        rower.maxLimit[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        rower.maxLimit[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        rower.maxLimit[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		rower.cuttingArea = self.cuttingAreas[getXMLInt(xmlFile, partName .. ".rower#cuttingArea")];
		rower.currentLimit = {0, 0, 0};
		
		part.rower = rower;
		-- part.bar = bar;
		part.mainPart = mainPart;
		part.moveTime = Utils.getNoNil(getXMLFloat(xmlFile, partName .. "#moveTime"),5)*1000;
		part.workingTime = Utils.getNoNil(getXMLFloat(xmlFile, partName .. "#workingTime"),2)*1000;
		part.isDown = false;
		table.insert(self.rowerFoldingParts, part);		
        i = i+1;
	end;

	self.animationSpeed = 0;
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#offsetTime"), 3) * 1000;
	
	self.rowerParticleSystemsRight = {};
      local i = 0;
      while true do
        local namei = string.format("vehicle.rowerParticleSystemsRight.rowerParticleSystemsRight(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.rowerParticleSystemsRight, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
	end;
	  
	self.rowerParticleSystemsLeft = {};
      local i = 0;
      while true do
        local namei = string.format("vehicle.rowerParticleSystemsLeft.rowerParticleSystemsLeft(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.rowerParticleSystemsLeft, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
      end;	

	self.doTransportCheck = false;
	self.doChangesForTransport = false;
	self.isTransport = true;
	self.attacherVehicleJoint = nil;
	self.isReadyToTransport = true;
	self.isLoading = true;
	self.isTurnedOn = false;

    self.steeringAxleAngle = 0;	
	self.updateSteeringAxleAngle = false;
    self.printWarningTime1 = 0;	
	
    self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
    self.saveMinRpm = 0; 	
end;

function krone900:delete()
	if self.rowerParticleSystemsRight ~= nil then
		Utils.deleteParticleSystem(self.rowerParticleSystemsRight);
	end;
	if self.rowerParticleSystemsLeft ~= nil then	
		Utils.deleteParticleSystem(self.rowerParticleSystemsLeft);
	end;
end;

function krone900:readStream(streamId, connection)
	self.isLoading = true;
	local isTransport = streamReadBool(streamId);
	self:setTransport(isTransport, true);
	for k, foldingPart in pairs(self.rowerFoldingParts) do
		local isDown = streamReadBool(streamId);
		self:setIsArmDown(isDown, k, true);
	end;
	
end;

function krone900:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isTransport);
	for k, foldingPart in pairs(self.rowerFoldingParts) do	
		streamWriteBool(streamId, foldingPart.mainPart.isDown);
	end;
	
end;

function krone900:mouseEvent(posX, posY, isDown, isUp, button)
end;

function krone900:keyEvent(unicode, sym, modifier, isDown)

end;

function krone900:update(dt)
		
	if self:getIsActiveForInput() then

		if self.isReadyToTransport then
			if InputBinding.hasEvent(InputBinding.KUHNGA8121_TRANSPORT) then
				local isTransport = false;
				for k, part in pairs(self.rowerFoldingParts) do
					isTransport = part.isDown;
					break;
				end;	
				self:setTransport(isTransport);
			end;
		end;
		if not self.isTransport then
			if InputBinding.hasEvent(InputBinding.KUHNGA8121_LOWER_LEFT) then
				local foldingArm = self.rowerFoldingParts[1].mainPart;
				self:setIsArmDown(1, not foldingArm.isDown);
			end;
			if InputBinding.hasEvent(InputBinding.KUHNGA8121_LOWER_RIGHT) then
				local foldingArm = self.rowerFoldingParts[2].mainPart;
				self:setIsArmDown(2, not foldingArm.isDown);
			end;
			if InputBinding.hasEvent(InputBinding.KUHNGA8121_LOWER_ALL) then
				local isDown = self.rowerFoldingParts[1].mainPart.isDown or self.rowerFoldingParts[2].mainPart.isDown;
				for k, part in pairs(self.rowerFoldingParts) do
					self:setIsArmDown(k, not isDown);
				end;	
			end;
		end;
		if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) and self.PTOId then
			self.printWarningTime1 = self.time + 1500;
		end;		
	end;
	

end;

function krone900:updateTick(dt)

	if self:getIsActive() then
		local isKeyEvent = false;	
		if self.isTurnedOn then
 			isKeyEvent = true;	
		else
 			isKeyEvent = false;	
		end;
		self:setVehicleRpmUp(dt, isKeyEvent);				
		self.isReadyToTransport = true;
		for _, part in pairs(self.rowerFoldingParts) do
			self.isReadyToTransport = self.isReadyToTransport and not part.mainPart.isDown;
		end;
		
		if self.PTOId then
			self:setIsTurnedOn(false);
			self.isTurnedOn = false;			
		end;
		if self.isTransport then		
			self:setIsTurnedOn(false);
		end;
		
		if self.doTransportCheck then
			-- check if rower animation stopped
			if self.animationSpeed < 0.01 then
				self.doChangesForTransport = true;
				self.doTransportCheck = false;
			end;			
		end;		
		-- if not self.isTransport then
		if self.isTurnedOn then	
            if not self.animationEnabled then
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
            end;		
        else
			if self.animationEnabled then
				if self.animationSpeed < 0.01 then
					disableAnimTrack(self.animation.animCharSet, 0);
					self.animationEnabled = false;
				else
					enableAnimTrack(self.animation.animCharSet, 0);
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
			end;
        end;
		-- end;
		
		if self.attacherVehicle ~= nil then	
			local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
			local dot = z; -- 0*x + z*1;
			dot = dot / Utils.vector2Length(x,z);
			local angle = math.acos(dot);
			if x < 0 then
				angle = -angle;
			end;
			local startSpeed = self.steeringAxleAngleScaleStart;
			local endSpeed = self.steeringAxleAngleScaleEnd;
			local scale = Utils.clamp(1 + (self.lastSpeed*3600-startSpeed) * 1.0/(startSpeed-endSpeed), 0, 1);
			self.steeringAxleAngle = angle*scale;

			for _, axis in pairs(self.steeringAnimations.axes) do
				setRotation(axis.node, getRotation(axis.wheel.repr));
			end;
			setJointFrame(self.componentJoints[7].jointIndex, 0, self.componentJoints[7].jointNode);					
			local x,y,z = getRotation(self.wheels[1].repr);
			local maxAngle = self.wheels[1].steeringAxleRotMax;
			local minAngle = self.wheels[1].steeringAxleRotMin;
			local percentage = (y - minAngle) / (maxAngle + math.abs(minAngle));
			local a,b,c = getTranslation(self.steeringAnimations.middleController.node);
			c = self.steeringAnimations.middleController.minTrans + percentage * (self.steeringAnimations.middleController.maxTrans - self.steeringAnimations.middleController.minTrans);
			setTranslation(self.steeringAnimations.middleController.node, a, b, c);
			
			for _, foldingPart in pairs(self.rowerFoldingParts) do
				local mainPart = foldingPart.mainPart;
				local x, y, z = getRotation(mainPart.joint.jointNode);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, mainPart.maxRot, mainPart.minRot, 3, foldingPart.moveTime, dt, not foldingPart.isDown);
				setRotation(mainPart.joint.jointNode, unpack(newRot));
				setJointFrame(mainPart.joint.jointIndex, 0, mainPart.joint.jointNode);
				x, y, z = getTranslation(mainPart.transNode);
				x = Utils.getMovedLimitedValues({x}, mainPart.maxTrans, mainPart.minTrans, 1, foldingPart.moveTime, dt, not foldingPart.isDown);
				setTranslation(mainPart.transNode, x[1],y,z);
				
				local rower = foldingPart.rower;
				setJointFrame(rower.joint.jointIndex, 0, rower.joint.jointNode);

				local newArmLimit = Utils.getMovedLimitedValues(mainPart.currentLimit, mainPart.maxLimit, {0,0,0}, 3, foldingPart.workingTime, dt, not mainPart.isDown);
				local newRowerLimit = Utils.getMovedLimitedValues(rower.currentLimit, rower.maxLimit, {0,0,0}, 3, foldingPart.workingTime, dt, not mainPart.isDown);
				for i=1, 3 do
					setJointRotationLimit(mainPart.joint.jointIndex, i-1, true, -newArmLimit[i], newArmLimit[i]);
					setJointRotationLimit(rower.joint.jointIndex, i-1, true, -newRowerLimit[i], newRowerLimit[i]);
				end;
				mainPart.currentLimit = newArmLimit;
				rower.currentLimit = newRowerLimit;

				local isExpanded = true;
                for i=1, 3 do
					isExpanded = isExpanded and newRowerLimit[i] >= rower.maxLimit[i] * 0.5;
                end;	
				
				for _, part in pairs(self.movingParts) do
					part.isDirty = true;
				end;
			end;
		else
			self.steeringAxleAngle = 0;			
		end;
		if self.isTurnedOn and self.movingDirection ~= 0 and self.lastAreaBiggerZero then
			local foldingArmRight = self.rowerFoldingParts[2].mainPart;	
			local foldingArmLeft = self.rowerFoldingParts[1].mainPart;
			if foldingArmLeft.isDown then			
				Utils.setEmittingState(self.rowerParticleSystemsLeft, true);		
			else
				Utils.setEmittingState(self.rowerParticleSystemsLeft, false);			
			end;
			if foldingArmRight.isDown then
				Utils.setEmittingState(self.rowerParticleSystemsRight, true);			
			else
				Utils.setEmittingState(self.rowerParticleSystemsRight, false);			
			end;
		else
			Utils.setEmittingState(self.rowerParticleSystemsLeft, false);	
			Utils.setEmittingState(self.rowerParticleSystemsRight, false);			
		end;	
		
	end;
end;


function krone900:draw()	
    if self.isClient then
		if self.isTransport then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("KUHNGA8121_TRANSPORT_OFF"), self.typeDesc), InputBinding.KUHNGA8121_TRANSPORT);
		else
			if self.isReadyToTransport then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("KUHNGA8121_TRANSPORT_ON"), self.typeDesc), InputBinding.KUHNGA8121_TRANSPORT);
			end;
			g_currentMission:addExtraPrintText(string.format(g_i18n:getText("KUHNGA8121_CONTROL"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.KUHNGA8121_LOWER_ALL) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.KUHNGA8121_LOWER_LEFT) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.KUHNGA8121_LOWER_RIGHT));
		end;
		
		if self.printWarningTime1 > self.time then
			g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
		end;	
	end;
end;

function krone900:onAttach(attacherVehicle)

	setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, math.rad(-80), math.rad(80));
	setJointRotationLimit(self.componentJoints[1].jointIndex, 2, true, math.rad(-5), math.rad(5));
	
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function krone900:onDetach()
	if self.rowerParticleSystemsRight ~= nil then
		Utils.setEmittingState(self.rowerParticleSystemsRight, false);
	end; 
	if self.rowerParticleSystemsLeft ~= nil then
		Utils.setEmittingState(self.rowerParticleSystemsLeft, false);
	end; 
	-- setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, math.rad(0), math.rad(0));
	-- setJointRotationLimit(self.componentJoints[1].jointIndex, 2, true, math.rad(0), math.rad(0));
	
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function krone900:onLeave()
	
	if self.rowerParticleSystemsRight ~= nil then
		Utils.setEmittingState(self.rowerParticleSystemsRight, false);
	end; 
	if self.rowerParticleSystemsLeft ~= nil then
		Utils.setEmittingState(self.rowerParticleSystemsLeft, false);
	end;  
end;

function krone900:setTransport(isTransport, noEventSend)
	SetTransportEvent.sendEvent(self, isTransport, noEventSend);
	for _, foldingPart in pairs(self.rowerFoldingParts) do			
		foldingPart.isDown = not isTransport;
	end;
	self.isTransport = isTransport;
	
	if not isTransport then
		self.doChangesForTransport = true;
	else
		-- wait for rower animation stop before checking tines
		self.doTransportCheck = true;	
		if self.isTurnedOn then
			self:setIsTurnedOn(false);
		end;						
	end;	

end;

function krone900:setIsArmDown(arm, isDown, noEventSend)
	local foldingArm = self.rowerFoldingParts[arm];
	if foldingArm ~= nil then
		SetIsArmDownEvent.sendEvent(self, arm, isDown, noEventSend);
		foldingArm.mainPart.isDown = isDown;
	end;
end;

function krone900:setIsTurnedOn(isTurnedOn, noEventSend)
	if not isTurnedOn then
		self.animationEnabled = true;
	end;
end;

function krone900:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -15000);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.000000011*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;


function krone900:getIsAreaActive(superFunc, area)
	local isActive = false;
	local rowerByArea = nil;
	for _, foldingPart in pairs(self.rowerFoldingParts) do
		if foldingPart.rower.cuttingArea == area then
			rowerByArea = foldingPart;
			break;
		end;
	end;
	if rowerByArea ~= nil then
		isActive = true;
		for i=1, 3 do
			isActive = isActive and rowerByArea.rower.currentLimit[i] >= rowerByArea.rower.maxLimit[i] * 0.5;
		end;	
	end;
    if superFunc ~= nil then
        return superFunc(self, area) and isActive;
    end;
	return isActive;	
end;