SetIsArmDownEvent = {};
SetIsArmDownEvent_mt = Class(SetIsArmDownEvent, Event);

InitEventClass(SetIsArmDownEvent, "SetIsArmDownEvent");

function SetIsArmDownEvent:emptyNew()
    local self = Event:new(SetIsArmDownEvent_mt);
    self.className="SetIsArmDownEvent";
    return self;
end;

function SetIsArmDownEvent:new(object, arm, isDown)
    local self = SetIsArmDownEvent:emptyNew()
    self.object = object;
	self.arm = arm;
	self.isDown = isDown;
    return self;
end;

function SetIsArmDownEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDown = streamReadBool(streamId);
	self.arm = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetIsArmDownEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isDown);
	streamWriteInt32(streamId, self.arm);
end;

function SetIsArmDownEvent:run(connection)   
	self.object:setIsArmDown(self.arm, self.isDown, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetIsArmDownEvent:new(self.object, self.arm, self.isDown), nil, connection, self.object);
    end;
end;

function SetIsArmDownEvent.sendEvent(vehicle, arm, isDown, noEventSend)
	local foldingArm = vehicle.rowerFoldingParts[arm];
	if foldingArm ~= nil then
		if isDown ~= vehicle.rowerFoldingParts[arm].mainPart.isDown then
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(SetIsArmDownEvent:new(vehicle, arm, isDown), nil, nil, vehicle);
				else
					g_client:getServerConnection():sendEvent(SetIsArmDownEvent:new(vehicle, arm, isDown));
				end;
			end;
		end;
	end;
end;

