--
-- AnimatedHydraulic
--
-- @author  Manuel Leithner
-- @date  12/04/10
--

AnimatedHydraulic = {};

function AnimatedHydraulic.prerequisitesPresent(specializations)
    return true;
end;

function AnimatedHydraulic:load(xmlFile)

	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		self.hydraulics[i].invertZ = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName.."#invertZ"), false);
		self.hydraulics[i].scaleZ = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName.."#scaleZ"), false);
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		if self.hydraulics[i].scaleZ then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);		
			self.hydraulics[i].localReferenceDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 100;
end;

function AnimatedHydraulic:delete()
end;

function AnimatedHydraulic:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimatedHydraulic:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimatedHydraulic:update(dt)

	if self:getIsActive() or not self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;

	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
end;

function AnimatedHydraulic:draw()	
end;

function AnimatedHydraulic:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		if hydraulic.invertZ then
			x = -x;
			y = -y;
			z = -z;
		end;
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
		if hydraulic.scaleZ and hydraulic.localReferenceDistance ~= nil then
			local len = Utils.vector3Length(x, y, z);
			setScale(hydraulic.node, 1, 1, len/hydraulic.localReferenceDistance);
		end
	end;
end;
