-- Original script: d47 strawmod
-- universal bale ready, fixed unloading, autoload, safe/load trailer state: Bassaddict
-- woolpallet ready: Steve007

-- Edit: 06.01.2014
-- Ready für meine Quaderballen aus meinem Quaderballentechnikpack und 2 Backgroundhud's hinzugefügt, damit man die Texte besser lesen kann. 
-- Man kann bei den Backgroundhud's auch zwischen dem alten und neuem Overlay hin und her wechseln.
-- Edit by: Ifko[nator]

-- Edit 2: 22.08.2014
-- Ready für die Baumsetzlingpaletten aus dem Forstmod, den Ballen der Claas Quadrant 1200 vom ehemaligem Eifok Team und es blenden sich nun automatisch Spanngurte ein, wenn der Anhänger voll ist.
-- Die Backgroundhud's richten sich nun nach den GUI Einstellungen Ingame.
-- Edit by: Ifko[nator]

-- Edit 3: 25.08.2014
-- Es blenden sich nun immer passende Spanngurte ein, sobald der Anhänger beladen wird.
-- Edit by: Ifko[nator]

-- Edit 4: 14.09.2014
-- Die Ballen der New Holland Pressen von HuberChris1991 hinzugefügt
-- Edit by: Ifko[nator]

ubt = {};

function ubt.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function ubt:load(xmlFile)
	self.File = Utils.getFilename("Texturen/Ballenhud.png", self.baseDirectory);
	self.File2 = Utils.getFilename("Texturen/Ballenhud2.png", self.baseDirectory);
	
	self.FileOld = Utils.getFilename("Texturen/BallenhudOld.png", self.baseDirectory);
	self.FileOld2 = Utils.getFilename("Texturen/BallenhudOld2.png", self.baseDirectory);
	
	self.hudPoxX = 0.745;
    self.hudPoxY = 0.285; 
    self.hudWidth = 0.25;
    self.hudHeight = 0.15;
	
	self.hudPoxX2 = 0.375;
    self.hudPoxY2 = 0.05;
    self.hudWidth2 = 0.365;
    self.hudHeight2 = 0.04;
	
	self.HUD = Overlay:new("HUD", self.File, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
	self.HUD2 = Overlay:new("HUD2", self.File2, self.hudPoxX2, self.hudPoxY2, self.hudWidth2, self.hudHeight2);
	
	self.HUDOld = Overlay:new("HUDOld", self.FileOld, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
	self.HUDOld2 = Overlay:new("HUDOld2", self.FileOld2, self.hudPoxX2, self.hudPoxY2, self.hudWidth2, self.hudHeight2);

	self.unloadLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.unloadLeft#index"));
	self.unloadRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.unloadRight#index"));
	self.unloadBack = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.unloadBack#index"));
	
	self.trailerIsEmpty = true;
	self.autoLoad = false;
	self.autoLoadText = {g_i18n:getText("AUTOLOAD_MANUAL"),g_i18n:getText("AUTOLOAD_AUTOMATIC")};
	self.loadingIsActive = false;
	self.wasToFast = false;
	self.displayHUD = false;
	
	self.smallBaleMass = 0.13093;
	
	self.updateCounter = 1;
	
	self.typeOnTrailer = 1;
	self.ulMode = 1;
	self.ulRef = {{g_i18n:getText("UNLOAD_LEFT"),false,self.unloadLeft},{g_i18n:getText("UNLOAD_BACK"),false,self.unloadBack},{g_i18n:getText("UNLOAD_RIGHT"),false,self.unloadRight},{g_i18n:getText("UNLOAD_TRAILER"),false,0}};	

	
	self.numAttacherParts = Utils.getNoNil(getXMLInt(xmlFile,"vehicle.attacherParts#count"), 0);
	self.numAttachers = {};
	self.attacher = {};
	self.attacherLevel = {};
	self.baleType = {};
	
	for i=1,self.numAttacherParts do
		self.numAttachers[i] = Utils.getNoNil(getXMLInt(xmlFile, string.format("vehicle.Attachers".."%d".."#count",i)), 0);
		self.baleType[i] = {g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, string.format("vehicle.Attachers".."%d".."#type",i))), "nil"),i};
		self.attacher[i] = {};
		self.attacherLevel[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, string.format("vehicle.Attachers".."%d".."#index",i)));
		for j=1,self.numAttachers[i] do
			self.attacher[i][j] = {};
			local partnamej = string.format("vehicle.Attachers".."%d"..".objectAttacher".."%d",i,j);
			self.attacher[i][j].object = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partnamej .. "#index"));
			setRigidBodyType(self.attacher[i][j].coll,"NoRigidBody");
			self.attacher[i][j].attachedObject = nil;
			self.attacher[i][j].objectInRange = nil;
		end;
	end;
	
	self.fillLevel = 0;
    self.fillLevelMax = self.numAttachers[self.typeOnTrailer];
	
	self.spanngurt1NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen1#index"));
	self.spanngurt2NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen2#index"));
	self.spanngurt3NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen3#index"));
	self.spanngurt4NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen4#index"));
	self.spanngurt5NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen5#index"));
	self.spanngurt6NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen6#index"));
	self.spanngurt7NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen7#index"));
	self.spanngurt8NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen8#index"));
	self.spanngurt9NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen9#index"));
	self.spanngurt10NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen10#index"));
	self.spanngurt11NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen11#index"));
	self.spanngurt12NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen12#index"));
	self.spanngurt13NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen13#index"));
	self.spanngurt14NormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.ballen14#index"));
	self.spanngurtVollNormaleQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteNormaleQuaderballen.voll#index"));
	
	self.spanngurt1GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen1#index"));
	self.spanngurt2GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen2#index"));
	self.spanngurt3GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen3#index"));
	self.spanngurt4GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen4#index"));
	self.spanngurt5GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen5#index"));
	self.spanngurt6GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen6#index"));
	self.spanngurt7GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen7#index"));
	self.spanngurt8GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen8#index"));
	self.spanngurt9GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen9#index"));
	self.spanngurt10GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen10#index"));
	self.spanngurt11GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen11#index"));
	self.spanngurt12GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen12#index"));
	self.spanngurt13GrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.ballen13#index"));
	self.spanngurtVollGrosseQuaderballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteGrosseQuaderballen.voll#index"));
	
	self.spanngurt1Rundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.ballen1#index"));
	self.spanngurt2Rundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.ballen2#index"));
	self.spanngurt3Rundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.ballen3#index"));
	self.spanngurt4Rundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.ballen4#index"));
	self.spanngurt5Rundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.ballen5#index"));
	self.spanngurt6Rundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.ballen6#index"));
	self.spanngurt7Rundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.ballen7#index"));
	self.spanngurt8Rundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.ballen8#index"));
	self.spanngurt9Rundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.ballen9#index"));
	self.spanngurtVollRundballen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteRundballen.voll#index"));
	
	self.spanngurt1Wollpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteWollpaletten.palette1#index"));
	self.spanngurt2Wollpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteWollpaletten.paletten2#index"));
	self.spanngurt3Wollpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteWollpaletten.paletten3#index"));
	self.spanngurt4Wollpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteWollpaletten.paletten4#index"));
	self.spanngurt5Wollpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteWollpaletten.paletten5#index"));
	self.spanngurtVollWollpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteWollpaletten.voll#index"));
	
	self.spanngurt1Baumsetzlingpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteBaumsetzlingpaletten.palette1#index"));
	self.spanngurt2Baumsetzlingpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteBaumsetzlingpaletten.paletten2#index"));
	self.spanngurt3Baumsetzlingpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteBaumsetzlingpaletten.paletten3#index"));
	self.spanngurt4Baumsetzlingpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteBaumsetzlingpaletten.paletten4#index"));
	self.spanngurt5Baumsetzlingpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteBaumsetzlingpaletten.paletten5#index"));
	self.spanngurtVollBaumsetzlingpaletten = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.spanngurte.spanngurteBaumsetzlingpaletten.voll#index"));
end;

function ubt:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local tmpTypeonTrailer = getXMLInt(xmlFile, key.."#typeOnTrailer");
		local tmpUlMode = getXMLInt(xmlFile, key.."#ulMode");
		local tmpAutoLoad = getXMLBool(xmlFile, key.."#autoLoad");
		local tmpDisplayHUD = getXMLBool(xmlFile, key.."#displayHUD");
		
		if tmpTypeonTrailer ~= nil then
			self.typeOnTrailer = tmpTypeonTrailer;
			self.fillLevelMax = self.numAttachers[self.typeOnTrailer];
		end;
		if tmpUlMode ~= nil then
			self.ulMode = tmpUlMode;
		end;
		if tmpAutoLoad ~= nil then
			self.autoLoad = tmpAutoLoad;
		end;
		if tmpDisplayHUD ~= nil then
			self.displayHUD = tmpDisplayHUD;
		end;
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function ubt:getSaveAttributesAndNodes(nodeIdent)
	local tmpAutoLoad;
	local tmpDisplayHUD;
	if self.autoLoad then
		tmpAutoLoad = "true";
	else
		tmpAutoLoad = "false";
	end;
	if self.displayHUD then
		tmpDisplayHUD = "true";
	else
		tmpDisplayHUD = "false";
	end;
	local attributes = string.format('typeOnTrailer="%d" ulMode="%d" autoLoad="%s" displayHUD="%s"',self.typeOnTrailer,self.ulMode,tmpAutoLoad,tmpDisplayHUD);
	return attributes, nil;
end;


function ubt:delete()
	if (not self.trailerIsEmpty) then
		for i=1, self.numAttachers[self.typeOnTrailer] do
			if self.attacher[self.typeOnTrailer][i].attachedObject ~= nil then
				unlink(self.attacher[self.typeOnTrailer][i].attachedObject);
			end;
		end;
		if self.fillLevel == 0 then
			self.trailerIsEmpty = true;
		end;
	end;
end;

function ubt:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ubt:keyEvent(unicode, sym, modifier, isDown)
end;

function ubt:update(dt)
	if self:getIsActiveForInput() then
		-- bale loading
		if InputBinding.hasEvent(InputBinding.ubtATTACH) and (not self.autoLoad) then
			for i=1, self.numAttachers[self.typeOnTrailer] do
				if self.attacher[self.typeOnTrailer][i].attachedObject == nil then
					local nearest = ObjectInRangeUbt(self,i);
					if nearest ~= nil then
						self.attacher[self.typeOnTrailer][i].objectInRange = nearest;
						ObjectAttachUbt(self,i);
					else
						break;
					end;
				end;
			end;
		elseif InputBinding.hasEvent(InputBinding.ubtATTACH) and self.autoLoad then
			if self.loadingIsActive then
				self.loadingIsActive = false;
			else
				self.loadingIsActive = true;
			end;
		end;
		-- bale unloading
		if InputBinding.hasEvent(InputBinding.ubtDETACH) and not self.loadingIsActive then
			for i=1, self.numAttachers[self.typeOnTrailer] do
				if self.attacher[self.typeOnTrailer][i].attachedObject ~= nil then
					ObjectDetachUbt(self,i);
				end;
			end;
			if self.fillLevel == 0 then
				self.trailerIsEmpty = true;
			end;
		end;
		-- toggle unloading side (left, back, right, trailer)
		if InputBinding.hasEvent(InputBinding.ubtTOGGLEUNLOAD) then
			if self.ulMode == 4 then
				self.ulMode = 0;
			end;
			self.ulMode = self.ulMode + 1;
		end;
		-- toggle bale type (round, normal_samll, normal_big, woolpallet, seedlingpallet)
		if InputBinding.hasEvent(InputBinding.ubtTOGGLEBALETYPE) then
			if self.trailerIsEmpty then
				if self.typeOnTrailer == table.getn(self.numAttachers) then
					self.typeOnTrailer = 0;
				end;
				self.typeOnTrailer = self.typeOnTrailer + 1;
				self.fillLevelMax = self.numAttachers[self.typeOnTrailer];
			end;
		end;
		-- toggle loading type (automatic, manual)
		if InputBinding.hasEvent(InputBinding.ubtTOGGLELOADINGTYPE) then
			if self.autoLoad and (not self.loadingIsActive) then
				self.autoLoad = false;
			else
				self.autoLoad = true;
			end;
		end;
		--toggle displaying HUD
		if InputBinding.hasEvent(InputBinding.ubtTOGGLEHUD) then
			if self.displayHUD then
				self.displayHUD = false;
			else
				self.displayHUD = true;
			end;
		end;
	end;
end;

function ubt:updateTick(dt)
	if self.fillLevel == 0 then
		self.trailerIsEmpty = true;
	else
		self.trailerIsEmpty = false;
	end;
	if self.fillLevel == self.fillLevelMax then
		self.loadingIsActive = false;
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("BALETYP_SQUAREBALE_NORMAL") then
			setVisibility(self.spanngurt14NormaleQuaderballen, false);
			setVisibility(self.spanngurtVollNormaleQuaderballen, true);
		else
			setVisibility(self.spanngurtVollNormaleQuaderballen, false);
		end;
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("BALETYP_SQUAREBALE_BIG") then
			setVisibility(self.spanngurt13GrosseQuaderballen, false);
			setVisibility(self.spanngurtVollGrosseQuaderballen, true);
		else
			setVisibility(self.spanngurtVollGrosseQuaderballen, false);
		end;
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("BALETYP_ROUND") then
			setVisibility(self.spanngurt9Rundballen, false);
			setVisibility(self.spanngurtVollRundballen, true);
		else
			setVisibility(self.spanngurtVollRundballen, false);
		end;
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("WOOLPALLET") then
			setVisibility(self.spanngurt5Wollpaletten, false);
			setVisibility(self.spanngurtVollWollpaletten, true);
		else
			setVisibility(self.spanngurtVollWollpaletten, false);
		end;
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("SEEDLINGPALLET") then
			setVisibility(self.spanngurt5Baumsetzlingpaletten, false);
			setVisibility(self.spanngurtVollBaumsetzlingpaletten, true);
		else
			setVisibility(self.spanngurtVollBaumsetzlingpaletten, false);
		end;
	else
		setVisibility(self.spanngurtVollNormaleQuaderballen, false);
		setVisibility(self.spanngurtVollGrosseQuaderballen, false);
		setVisibility(self.spanngurtVollRundballen, false);
		setVisibility(self.spanngurtVollWollpaletten, false);
		setVisibility(self.spanngurtVollBaumsetzlingpaletten, false);
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("BALETYP_SQUAREBALE_NORMAL") then
			if self.fillLevel == 1 then
				setVisibility(self.spanngurt1NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt1NormaleQuaderballen, false);
			end;
			if self.fillLevel == 2 then
				setVisibility(self.spanngurt2NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt2NormaleQuaderballen, false);
			end;
			if self.fillLevel == 3 then
				setVisibility(self.spanngurt3NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt3NormaleQuaderballen, false);
			end;
			if self.fillLevel == 4 then
				setVisibility(self.spanngurt4NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt4NormaleQuaderballen, false);
			end;
			if self.fillLevel == 5 then
				setVisibility(self.spanngurt5NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt5NormaleQuaderballen, false);
			end;
			if self.fillLevel == 6 then
				setVisibility(self.spanngurt6NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt6NormaleQuaderballen, false);
			end;
			if self.fillLevel == 7 then
				setVisibility(self.spanngurt7NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt7NormaleQuaderballen, false);
			end;
			if self.fillLevel == 8 then
				setVisibility(self.spanngurt8NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt8NormaleQuaderballen, false);
			end;
			if self.fillLevel == 9 then
				setVisibility(self.spanngurt9NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt9NormaleQuaderballen, false);
			end;
			if self.fillLevel == 10 then
				setVisibility(self.spanngurt10NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt10NormaleQuaderballen, false);
			end;
			if self.fillLevel == 11 then
				setVisibility(self.spanngurt11NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt11NormaleQuaderballen, false);
			end;
			if self.fillLevel == 12 then
				setVisibility(self.spanngurt12NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt12NormaleQuaderballen, false);
			end;
			if self.fillLevel == 13 then
				setVisibility(self.spanngurt13NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt13NormaleQuaderballen, false);
			end;
			if self.fillLevel == 14 then
				setVisibility(self.spanngurt14NormaleQuaderballen, true);
			else
				setVisibility(self.spanngurt14NormaleQuaderballen, false);
			end;
		else
			setVisibility(self.spanngurt1NormaleQuaderballen, false);
			setVisibility(self.spanngurt2NormaleQuaderballen, false);
			setVisibility(self.spanngurt3NormaleQuaderballen, false);
			setVisibility(self.spanngurt4NormaleQuaderballen, false);
			setVisibility(self.spanngurt5NormaleQuaderballen, false);
			setVisibility(self.spanngurt6NormaleQuaderballen, false);
			setVisibility(self.spanngurt7NormaleQuaderballen, false);
			setVisibility(self.spanngurt8NormaleQuaderballen, false);
			setVisibility(self.spanngurt9NormaleQuaderballen, false);
			setVisibility(self.spanngurt10NormaleQuaderballen, false);
			setVisibility(self.spanngurt11NormaleQuaderballen, false);
			setVisibility(self.spanngurt12NormaleQuaderballen, false);
			setVisibility(self.spanngurt13NormaleQuaderballen, false);
			setVisibility(self.spanngurt14NormaleQuaderballen, false);
		end;
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("BALETYP_SQUAREBALE_BIG") then
			if self.fillLevel == 1 then
				setVisibility(self.spanngurt1GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt1GrosseQuaderballen, false);
			end;
			if self.fillLevel == 2 then
				setVisibility(self.spanngurt2GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt2GrosseQuaderballen, false);
			end;
			if self.fillLevel == 3 then
				setVisibility(self.spanngurt3GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt3GrosseQuaderballen, false);
			end;
			if self.fillLevel == 4 then
				setVisibility(self.spanngurt4GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt4GrosseQuaderballen, false);
			end;
			if self.fillLevel == 5 then
				setVisibility(self.spanngurt5GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt5GrosseQuaderballen, false);
			end;
			if self.fillLevel == 6 then
				setVisibility(self.spanngurt6GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt6GrosseQuaderballen, false);
			end;
			if self.fillLevel == 7 then
				setVisibility(self.spanngurt7GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt7GrosseQuaderballen, false);
			end;
			if self.fillLevel == 8 then
				setVisibility(self.spanngurt8GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt8GrosseQuaderballen, false);
			end;
			if self.fillLevel == 9 then
				setVisibility(self.spanngurt9GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt9GrosseQuaderballen, false);
			end;
			if self.fillLevel == 10 then
				setVisibility(self.spanngurt10GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt10GrosseQuaderballen, false);
			end;
			if self.fillLevel == 11 then
				setVisibility(self.spanngurt11GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt11GrosseQuaderballen, false);
			end;
			if self.fillLevel == 12 then
				setVisibility(self.spanngurt12GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt12GrosseQuaderballen, false);
			end;
			if self.fillLevel == 13 then
				setVisibility(self.spanngurt13GrosseQuaderballen, true);
			else
				setVisibility(self.spanngurt13GrosseQuaderballen, false);
			end;
		else
			setVisibility(self.spanngurt1GrosseQuaderballen, false);
			setVisibility(self.spanngurt2GrosseQuaderballen, false);
			setVisibility(self.spanngurt3GrosseQuaderballen, false);
			setVisibility(self.spanngurt4GrosseQuaderballen, false);
			setVisibility(self.spanngurt5GrosseQuaderballen, false);
			setVisibility(self.spanngurt6GrosseQuaderballen, false);
			setVisibility(self.spanngurt7GrosseQuaderballen, false);
			setVisibility(self.spanngurt8GrosseQuaderballen, false);
			setVisibility(self.spanngurt9GrosseQuaderballen, false);
			setVisibility(self.spanngurt10GrosseQuaderballen, false);
			setVisibility(self.spanngurt11GrosseQuaderballen, false);
			setVisibility(self.spanngurt12GrosseQuaderballen, false);
			setVisibility(self.spanngurt13GrosseQuaderballen, false);
		end;
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("BALETYP_ROUND") then
			if self.fillLevel == 1 then
				setVisibility(self.spanngurt1Rundballen, true);
			else
				setVisibility(self.spanngurt1Rundballen, false);
			end;
			if self.fillLevel == 2 then
				setVisibility(self.spanngurt2Rundballen, true);
			else
				setVisibility(self.spanngurt2Rundballen, false);
			end;
			if self.fillLevel == 3 then
				setVisibility(self.spanngurt3Rundballen, true);
			else
				setVisibility(self.spanngurt3Rundballen, false);
			end;
			if self.fillLevel == 4 then
				setVisibility(self.spanngurt4Rundballen, true);
			else
				setVisibility(self.spanngurt4Rundballen, false);
			end;
			if self.fillLevel == 5 then
				setVisibility(self.spanngurt5Rundballen, true);
			else
				setVisibility(self.spanngurt5Rundballen, false);
			end;
			if self.fillLevel == 6 then
				setVisibility(self.spanngurt6Rundballen, true);
			else
				setVisibility(self.spanngurt6Rundballen, false);
			end;
			if self.fillLevel == 7 then
				setVisibility(self.spanngurt7Rundballen, true);
			else
				setVisibility(self.spanngurt7Rundballen, false);
			end;
			if self.fillLevel == 8 then
				setVisibility(self.spanngurt8Rundballen, true);
			else
				setVisibility(self.spanngurt8Rundballen, false);
			end;
			if self.fillLevel == 9 then
				setVisibility(self.spanngurt9Rundballen, true);
			else
				setVisibility(self.spanngurt9Rundballen, false);
			end;
		else
			setVisibility(self.spanngurt1Rundballen, false);
			setVisibility(self.spanngurt2Rundballen, false);
			setVisibility(self.spanngurt3Rundballen, false);
			setVisibility(self.spanngurt4Rundballen, false);
			setVisibility(self.spanngurt5Rundballen, false);
			setVisibility(self.spanngurt6Rundballen, false);
			setVisibility(self.spanngurt7Rundballen, false);
			setVisibility(self.spanngurt8Rundballen, false);
			setVisibility(self.spanngurt9Rundballen, false);
		end;
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("WOOLPALLET") then
			if self.fillLevel == 1 then
				setVisibility(self.spanngurt1Wollpaletten, true);
			else
				setVisibility(self.spanngurt1Wollpaletten, false);
			end;
			if self.fillLevel == 2 then
				setVisibility(self.spanngurt2Wollpaletten, true);
			else
				setVisibility(self.spanngurt2Wollpaletten, false);
			end;
			if self.fillLevel == 3 then
				setVisibility(self.spanngurt3Wollpaletten, true);
			else
				setVisibility(self.spanngurt3Wollpaletten, false);
			end;
			if self.fillLevel == 4 then
				setVisibility(self.spanngurt4Wollpaletten, true);
			else
				setVisibility(self.spanngurt4Wollpaletten, false);
			end;
			if self.fillLevel == 5 then
				setVisibility(self.spanngurt5Wollpaletten, true);
			else
				setVisibility(self.spanngurt5Wollpaletten, false);
			end;
		else
			setVisibility(self.spanngurt1Wollpaletten, false);
			setVisibility(self.spanngurt2Wollpaletten, false);
			setVisibility(self.spanngurt3Wollpaletten, false);
			setVisibility(self.spanngurt4Wollpaletten, false);
			setVisibility(self.spanngurt5Wollpaletten, false);
		end;
		if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("SEEDLINGPALLET") then
			if self.fillLevel == 1 then
				setVisibility(self.spanngurt1Baumsetzlingpaletten, true);
			else
				setVisibility(self.spanngurt1Baumsetzlingpaletten, false);
			end;
			if self.fillLevel == 2 then
				setVisibility(self.spanngurt2Baumsetzlingpaletten, true);
			else
				setVisibility(self.spanngurt2Baumsetzlingpaletten, false);
			end;
			if self.fillLevel == 3 then
				setVisibility(self.spanngurt3Baumsetzlingpaletten, true);
			else
				setVisibility(self.spanngurt3Baumsetzlingpaletten, false);
			end;
			if self.fillLevel == 4 then
				setVisibility(self.spanngurt4Baumsetzlingpaletten, true);
			else
				setVisibility(self.spanngurt4Baumsetzlingpaletten, false);
			end;
			if self.fillLevel == 5 then
				setVisibility(self.spanngurt5Baumsetzlingpaletten, true);
			else
				setVisibility(self.spanngurt5Baumsetzlingpaletten, false);
			end;
		else
			setVisibility(self.spanngurt1Baumsetzlingpaletten, false);
			setVisibility(self.spanngurt2Baumsetzlingpaletten, false);
			setVisibility(self.spanngurt3Baumsetzlingpaletten, false);
			setVisibility(self.spanngurt4Baumsetzlingpaletten, false);
			setVisibility(self.spanngurt5Baumsetzlingpaletten, false);
		end;
	end;
	self.wasToFast = false;
	if self:getIsActive() then
		-- autoload
		local toFast = self:doCheckSpeedLimit() and self.attacherVehicle.lastSpeed*3600 > 29;
		if self.autoLoad and self.loadingIsActive then
			if not toFast then
				local i = self.fillLevel+1;
				if self.attacher[self.typeOnTrailer][i].attachedObject == nil then
					local nearest = ObjectInRangeUbt(self,i);
					if nearest ~= nil then
						self.attacher[self.typeOnTrailer][i].objectInRange = nearest;
						ObjectAttachUbt(self,i);
					end;
				end;
			end;
			self.wasToFast = toFast;
		end;
	end;
end;

function ubt:draw()
	if self.wasToFast then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
    end;
	local tmpALText;
	if self.autoLoad then
		tmpALText = self.autoLoadText[2];
	else
		tmpALText = self.autoLoadText[1];
	end;
	if self.displayHUD then
		if g_newGUISkin then
			self.HUD:render();
			self.HUD2:render();
		else
			self.HUDOld:render();
			self.HUDOld2:render();
		end;
		setTextAlignment(RenderText.ALIGN_LEFT);
		local xPos = 0.75;
		local yPos = 0.3;
		setTextBold(true);
		renderText(0.38,0.06,0.02,string.format("(%d/%d), %s, %s, %s",self.fillLevel,self.fillLevelMax,self.baleType[self.typeOnTrailer][1],self.ulRef[self.ulMode][1],tmpALText));
		if self.autoLoad then
			if self.loadingIsActive then
				renderText(xPos,yPos+0.1,0.02,string.format("%s: "..g_i18n:getText("UBT_STOP_AUTOLOAD"),InputBinding.getKeyNamesOfDigitalAction(InputBinding.ubtATTACH)));
			else
				renderText(xPos,yPos+0.1,0.02,string.format("%s: "..g_i18n:getText("UBT_START_AUTOLOAD"),InputBinding.getKeyNamesOfDigitalAction(InputBinding.ubtATTACH)));
			end;
		else
			renderText(xPos,yPos+0.1,0.02,string.format("%s: "..g_i18n:getText("UBT_LOAD"),InputBinding.getKeyNamesOfDigitalAction(InputBinding.ubtATTACH)));
		end;
		renderText(xPos,yPos+0.08,0.02,string.format("%s: "..g_i18n:getText("UBT_UNLOAD"),InputBinding.getKeyNamesOfDigitalAction(InputBinding.ubtDETACH)));
		renderText(xPos,yPos+0.06,0.02,string.format("%s: "..g_i18n:getText("UBT_TOGGLE_BALE_TYPE"),InputBinding.getKeyNamesOfDigitalAction(InputBinding.ubtTOGGLEBALETYPE)));
		renderText(xPos,yPos+0.04,0.02,string.format("%s: "..g_i18n:getText("UBT_TOGGLE_UNLOAD_SIDE"),InputBinding.getKeyNamesOfDigitalAction(InputBinding.ubtTOGGLEUNLOAD)));
		renderText(xPos,yPos+0.02,0.02,string.format("%s: "..g_i18n:getText("UBT_TOGGLE_LOADING_TYPE"),InputBinding.getKeyNamesOfDigitalAction(InputBinding.ubtTOGGLELOADINGTYPE)));
		renderText(xPos,yPos,0.02,string.format("%s: "..g_i18n:getText("UBT_HUD_HIDE"),InputBinding.getKeyNamesOfDigitalAction(InputBinding.ubtTOGGLEHUD)));
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("UBT_HUD_SHOW"), self.typeDesc), InputBinding.ubtTOGGLEHUD);
	end;
end;

function ObjectInRangeUbt(self,k)
	local nearestObject;
	local itemNode;
	local index;
	local nearestDistance = 15;
	local objectCopy = self.attacher[self.typeOnTrailer][k].object;
	local px, py, pz = getWorldTranslation(objectCopy);
	if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("SEEDLINGPALLET") then
		for index, item in pairs(g_currentMission.vehicles) do
			if item.typeName == "aForestMod.seedlingPallet" then
				if getParent(item.rootNode) == getRootNode() then
					itemNode = item.rootNode;
					local vx, vy, vz = getWorldTranslation(itemNode);
					local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
					if distance < nearestDistance then
						index = index;
						nearestObject = itemNode;
						nearestDistance = distance;
					end;
				end;
			end;
		end;
	else
		for index, item in pairs(g_currentMission.itemsToSave) do
			itemNode = item.item.nodeId;
			if getParent(item.item.nodeId) == getRootNode() then
				local vx, vy, vz = getWorldTranslation(itemNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					if self.baleType[self.typeOnTrailer][1] == g_i18n:getText("BALETYP_SQUAREBALE_NORMAL") then
						if item.item.i3dFilename == "data/maps/models/objects/strawbale/haybaleBaler.i3d" 
							or item.item.i3dFilename == "data/maps/models/objects/strawbale/strawbaleBaler.i3d" 
							or getUserAttribute(itemNode, "isSquarebale") 
						then
							index = index;
							nearestObject = itemNode;
							nearestDistance = distance;
						end;
					elseif self.baleType[self.typeOnTrailer][1] == g_i18n:getText("BALETYP_SQUAREBALE_BIG") then
						if item.item.i3dFilename == g_modsDirectory .. "/ClaasQuadrant1200/Ballen/haybaleBaler.i3d" 
							or item.item.i3dFilename == g_modsDirectory .. "/ClaasQuadrant1200/Ballen/strawbaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/mrClaasQuadrant1200/Ballen/haybaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/mrClaasQuadrant1200/Ballen/strawbaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/mrClaasQuadrant1200/Ballen/strawbaleBalerB.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/mrClaasQuadrant1200/Ballen/strawbaleBalerW.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/NewHollandD1000Pack/Ballen/strawbaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/NewHollandD1000Pack/Ballen/haybaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/Mengele550/Ballen/strawbaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/Mengele550/Ballen/haybaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/Fortschritt530/Ballen/strawbaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/Fortschritt530/Ballen/haybaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/CaseLB330/Ballen/strawbaleBaler.i3d"
							or item.item.i3dFilename == g_modsDirectory .. "/CaseLB330/Ballen/haybaleBaler.i3d"
						then
							index = index;
							nearestObject = itemNode;
							nearestDistance = distance;
						end;
					elseif self.baleType[self.typeOnTrailer][1] == g_i18n:getText("BALETYP_ROUND") then
						if getUserAttribute(itemNode, "isRoundbale") then
							index = index;
							nearestObject = itemNode;
							nearestDistance = distance;
						end;
					elseif self.baleType[self.typeOnTrailer][1] == g_i18n:getText("WOOLPALLET") then
						if item.item.i3dFilename == "data/maps/models/objects/pallets/woolPallet.i3d" 
							or item.item.i3dFilename == g_modsDirectory .. "/IfkoWorldAddOn/models/objects/WoolPaletteCollector/woolPallet.i3d" 
							or item.item.i3dFilename == g_modsDirectory .. "/moreRealisticGenuineMap/_RES/woolPallet.i3d" 
						then
							index = index;
							nearestObject = itemNode;
							nearestDistance = distance;
						end;
					end;
				end;
			end;
		end;
	end;
	return nearestObject;
end;

function ObjectAttachUbt(self,k)
	setRigidBodyType(self.attacher[self.typeOnTrailer][k].objectInRange,"NoRigidBody");
	local x,y,z = getWorldRotation(self.attacher[self.typeOnTrailer][k].objectInRange);		
	setTranslation(self.attacher[self.typeOnTrailer][k].objectInRange, 0,0,0);
	setRotation(self.attacher[self.typeOnTrailer][k].objectInRange, 0,0,0);
	link(self.attacher[self.typeOnTrailer][k].object,self.attacher[self.typeOnTrailer][k].objectInRange);
	self.attacher[self.typeOnTrailer][k].attachedObject = self.attacher[self.typeOnTrailer][k].objectInRange;
	self.attacher[self.typeOnTrailer][k].objectInRange = nil;
	self.fillLevel = self.fillLevel + 1;
end;

function ObjectDetachUbt(self,k)
	if self.ulRef[self.ulMode][1] == g_i18n:getText("UNLOAD_TRAILER") then
		local x,y,z = getWorldTranslation(self.attacher[self.typeOnTrailer][k].attachedObject);
		local rx,ry,rz = getWorldRotation(self.attacher[self.typeOnTrailer][k].attachedObject);
		local root = getRootNode();
		setRigidBodyType(self.attacher[self.typeOnTrailer][k].attachedObject,"Dynamic");
		setTranslation(self.attacher[self.typeOnTrailer][k].attachedObject,x,y,z);
		setRotation(self.attacher[self.typeOnTrailer][k].attachedObject,rx,ry,rz);
		link(root,self.attacher[self.typeOnTrailer][k].attachedObject);
		self.attacher[self.typeOnTrailer][k].attachedObject = nil;
		--registerObjectClassName(self.attacher[self.typeOnTrailer][k].attachedObject, "ubtObject");
		--g_currentMission:addItemToSave(self.attacher[self.typeOnTrailer][k].attachedObject);
		self.fillLevel = self.fillLevel - 1;
	else
		local x,y,z = getWorldTranslation(self.attacher[self.typeOnTrailer][k].attachedObject);
		local rx,ry,rz = getWorldRotation(self.attacher[self.typeOnTrailer][k].attachedObject);
		local nx,ny,nz = getWorldTranslation(self.attacherLevel[self.typeOnTrailer]);
		local tx,ty,tz = getWorldTranslation(self.ulRef[self.ulMode][3]);
		local x = x + (tx - nx);
		local y = y + (ty - ny);
		local z = z + (tz - nz);
		local tH = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
		local relHeight = ny - tH;
		local root = getRootNode();
		setRigidBodyType(self.attacher[self.typeOnTrailer][k].attachedObject,"Dynamic");
		setTranslation(self.attacher[self.typeOnTrailer][k].attachedObject,x,(y - relHeight),z);
		setRotation(self.attacher[self.typeOnTrailer][k].attachedObject,rx,ry,rz);
		link(root,self.attacher[self.typeOnTrailer][k].attachedObject);
		self.attacher[self.typeOnTrailer][k].attachedObject = nil;
		--registerObjectClassName(self.attacher[self.typeOnTrailer][k].attachedObject, "ubtObject");
		--g_currentMission:addItemToSave(self.attacher[self.typeOnTrailer][k].attachedObject);
		self.fillLevel = self.fillLevel - 1;
	end;
end;

function ubt:onDetach()
	self.loadingIsActive = false;
end;

function ubt:onLeave()
	self.loadingIsActive = false;
end;

function ubt:readStream(streamId, connection)
end;

function ubt:writeStream(streamId, connection)   
end;