--
-- KroneEasyCut6210CV
-- Specialization for KroneEasyCut6210CV
--
-- @author Felix "Outlaw" Sorge
-- @date  02/07/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--

KroneEasyCut6210CV = {};

function KroneEasyCut6210CV.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function KroneEasyCut6210CV:load(xmlFile)

	self.mower = SpecializationUtil.callSpecializationsFunction("mower");
	self.lowerRmp = SpecializationUtil.callSpecializationsFunction("lowerRmp");
	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {}; 
    self.animParts = {};
	self.collisionArm = {};
	self.startpoint = {};
	self.loopCheck = {};
	self.Speed = {};
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		self.startpoint[nameR] = Utils.getNoNil(getXMLFloat(xmlFile, partname.."#startpoint"),0.0);
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; 
		local charId = getAnimCharacterSet(self.charId[nameR]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[nameR]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackTime(charId, 0, self.startpoint[nameR]);
		enableAnimTrack(charId, 0);
		disableAnimTrack(charId, 0);
		self.loopCheck[nameR] = false;
		self.Speed[nameR] = 1.0;
	end; 
	
	local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end;
		
	self.leftParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.leftParticleSystems.leftParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.leftParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	self.rightParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.rightParticleSystems.rightParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.rightParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    if numWindrowerDropAreas ~= 1 or numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
        print("Warning: number of cutting areas and drop areas should be equal");
    end;
	
	self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
	self.acr = 0;
	self.acl = 0; 
			
	self.keyType = InputBinding.getButtonKeyName;
	self.keyName = "Taste"; 
		
end;

function KroneEasyCut6210CV:update(dt)		
			
	if self:getIsActive() then
	
		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.KroneEasyCut6210CV_on) and self.CheckDone.transport and self.Go.transport and self.Go.lower then
			self.turnOn = not self.turnOn; 	
			if self.turnOn then
				self.Go.on = true; 
				self.Done.on = true;
				self.loopCheck.on = true;
				self.Speed.on = 4.0; 
			else
				self.Go.on = false;
				self.Done.on = true;
			end;
		end; 
		
		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self.Speed.lower = 1.0; 
			if self.CheckDone.transport and self.Go.transport then
				self.Go.lower = not self.Go.lower;
				self.Done.lower = true; 
			end; 			
			if self.attacherVehicle.selectedImplement ~= 0 and self.CheckDone.transport and self.Go.transport then
				local implement = self.attacherVehicle.attachedImplements[self.attacherVehicle.selectedImplement];
				if implement.object.allowsLowering then
					local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
					if jointDesc.moveDown and not self.Go.lower then
						jointDesc.moveDown = false;
					elseif not jointDesc.moveDown and self.Go.lower then
						jointDesc.moveDown = true;
					end; 	
          
				end;
			end;	
		end; 
		
		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.KroneEasyCut6210CV_schwenk_left) and self.CheckDone.transport and self.Go.transport then
			self.Speed.schwenk = 1.0; 
			self.Go.schwenk = 5000.0;
			self.Done.schwenk = true; 	
		end; 
		
		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.KroneEasyCut6210CV_schwenk_middle) and self.CheckDone.transport and self.Go.transport then
		self.Speed.schwenk = 1.0; 
			self.Go.schwenk = 3000.0;
			self.Done.schwenk = true; 	
		end; 
		
		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.KroneEasyCut6210CV_schwenk_right) and self.CheckDone.transport and self.Go.transport  then
		self.Speed.schwenk = 1.0; 
			self.Go.schwenk = 1000.0;
			self.Done.schwenk = true; 	
		end; 

		if self:getIsActiveForInput() and InputBinding.hasEvent(InputBinding.KroneEasyCut6210CV_transport) and not self.turnOn then
			self.Go.transport = not self.Go.transport;
			self.Done.transport = true; 
			self.Speed.lower = 0.1; 
			self.Speed.schwenk = 0.1; 
			if self.Go.transport then
				self.Go.schwenk = 1000.0;
				self.Done.schwenk = true; 
				self.Go.lower = not self.Go.lower;
				self.Done.lower = true; 
			else
				if self.Go.lower then
				self.Go.lower = not self.Go.lower;
				self.Done.lower = true; 
			end; 
				self.Go.schwenk = 0.0;
				self.Done.schwenk = true; 
			end; 	
		end; 
	end; 	
	

	if self.turnOn and self.attacherVehicle ~= nil then
		if not self.backupRmp then
			self.backupRmp = self.attacherVehicle.motor.minRpm;
		end; 			
		if self.attacherVehicle.motor.minRpm >= -500 then
			self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm - 10; 
		end; 		
		if not self.mowerSoundEnabled and self:getIsActiveForSound() then
            setSamplePitch(self.mowerSound, self.mowerSoundPitchOffset);
            playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
            self.mowerSoundEnabled = true;
        end;
		if not self.Go.lower and not self.CheckDone.lower then
			self:mower(FruitUtil.FRUITTYPE_GRASS, "left");
			self:mower(FruitUtil.FRUITTYPE_GRASS, "right");
		end; 
	else
		self:lowerRmp(); 
		if self.mowerSoundEnabled then
			stopSample(self.mowerSound);
			self.mowerSoundEnabled = false;
		end; 	
	end;
	
	if self.Go.lower or self.CheckDone.lower or not self.turnOn then
		Utils.setEmittingState(self.leftParticleSystems, false)
		Utils.setEmittingState(self.rightParticleSystems, false)
	end; 
	
		
	if self.fixAttacher then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.saveJoint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.maxRotJoint = joint.maxRotLimit;
				self.attacherJointIndex = implement.jointDescIndex;
				self.rotationCopy  = joint.minRot;
				joint.minRot = {Utils.degToRad(2),0,0};			
				joint.maxRotLimit = {0, 0, 0};
				setJointRotationLimit(joint.jointIndex, 2, true, 0, 0);
			end;
			self.fixAttacher = false;
		end;
		
	if self.Done.transport or self.Done.schwenk or self.Done.lower then	
		local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[4];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[5];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
		local joint = self.componentJoints[6];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	end; 
 
	if self.Go.transport ~= nil and self.Done.transport ~= false then
		self:anim("transport"); 
	end;
	
	if self.Go.schwenk ~= nil and self.Done.schwenk ~= false then
		self:anim("schwenk"); 
	end;
				
	if self.Go.lower ~= nil and self.Done.lower ~= false then
		self:anim("lower"); 
	end;
	
	if self.Go.on ~= nil and self.Done.on ~= false then
		self:anim("on"); 
	end;
	
end;

function KroneEasyCut6210CV:draw()
	if self.Go.transport and not self.turnOn then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.KroneEasyCut6210CV_transport).. ": " ..g_i18n:getText("KroneEasyCut6210CV_1")); 
	elseif not self.turnOn then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.KroneEasyCut6210CV_transport).. ": " ..g_i18n:getText("KroneEasyCut6210CV_2")); 
	end; 
		
	if self.turnOn and self.CheckDone.transport and self.Go.transport and self.Go.lower then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.KroneEasyCut6210CV_on).. ": " ..g_i18n:getText("KroneEasyCut6210CV_4")); 
	elseif self.CheckDone.transport and self.Go.transport and self.Go.lower then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.KroneEasyCut6210CV_on).. ": " ..g_i18n:getText("KroneEasyCut6210CV_3")); 
	end; 

	if self.CheckDone.transport and self.Go.transport then
	g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.KroneEasyCut6210CV_schwenk_left).. "/" ..self.keyType(InputBinding.KroneEasyCut6210CV_schwenk_middle).. "/" ..self.keyType(InputBinding.KroneEasyCut6210CV_schwenk_right).. ": " ..g_i18n:getText("KroneEasyCut6210CV_7")); 
	end; 
end;

function KroneEasyCut6210CV:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	local loopCheck = self.loopCheck[varName];
	local speed = Utils.getNoNil(self.Speed[varName],1);
	local offset = 10;  
	local charId = getAnimCharacterSet(self.charId[varName]);
	local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
	if self.Done[varName] ~= false then
		if self.Go[varName] == true then
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			setAnimTrackSpeedScale(charId, 0, speed);
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
				self.Done[varName] = false;	
				self.CheckDone[varName] = self.Go[varName];	
			end;
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck then
				local setTime = getAnimClipDuration(charId, clipIndex) - getAnimClipDuration(charId, clipIndex);
				setAnimTrackTime(charId, 0, setTime);
			end;
		elseif self.Go[varName] == false then
			if loopCheck == true then
				self.Done[varName] = false;	
			else
				assignAnimTrackClip(charId , 0, clipIndex);
				setAnimTrackLoopState(charId, 0, loopCheck);
				setAnimTrackSpeedScale(charId, 0, -speed);
				enableAnimTrack(charId, 0);
				if getAnimTrackTime(charId, 0) <= 0 then
					self.Done[varName] = false;	
					self.CheckDone[varName] = self.Go[varName];
				end;
			end;
		elseif self.Go[varName] ~= nil then
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			if self.Go[varName] < 0.0 then
				self.Go[varName] = 0.0;
			elseif self.Go[varName] > getAnimClipDuration(charId, clipIndex) then
				self.Go[varName] = getAnimClipDuration(charId, clipIndex);
			end;
			if getAnimTrackTime(charId, 0) >= self.Go[varName] then
				setAnimTrackSpeedScale(charId, 0, -speed);
			else
				setAnimTrackSpeedScale(charId, 0, speed);
			end;
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) <= self.Go[varName] + offset and getAnimTrackTime(charId, 0) >= self.Go[varName] - offset then
				self.Done[varName] = false;	
				self.CheckDone[varName] = self.Go[varName];
			end;
		end;
	end;
	if self.Done[varName] == false then
		disableAnimTrack(charId, 0);
	end;
end; 

function KroneEasyCut6210CV:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do		            
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;

function KroneEasyCut6210CV:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KroneEasyCut6210CV:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym==Input.KEY_8 then
		self.keySet = not self.keySet; 
		if self.keySet then
			self.keyType = InputBinding.getButtonName;
			self.keyName = "Button"; 
		else
			self.keyType = InputBinding.getButtonKeyName;
			self.keyName = "Tasten"; 
		end; 
	end;
end;

function KroneEasyCut6210CV:onAttach()
	self.fixAttacher = true; 
end; 	

function KroneEasyCut6210CV:onDetach()
	local joint = self.saveJoint; 
	joint.minRot = self.rotationCopy;
	joint.maxRotLimit = self.maxRotJoint;
	if self.mowerSoundEnabled then
        stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;
	self:lowerRmp(); 
	Utils.setEmittingState(self.rightParticleSystems, false)
	Utils.setEmittingState(self.leftParticleSystems, false)
end;

function KroneEasyCut6210CV:delete()
	if self.mowerSoundEnabled then
        stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;
	self:lowerRmp(); 
	Utils.setEmittingState(self.rightParticleSystems, false)
	Utils.setEmittingState(self.leftParticleSystems, false)
end;

function KroneEasyCut6210CV:lowerRmp()
	if self.backupRmp and self.attacherVehicle then
		if self.attacherVehicle.motor.minRpm <= self.backupRmp then
			self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm + 10; 
		else
			self.attacherVehicle.motor.minRpm = self.backupRmp; 
			self.backupRmp = nil; 			
		end; 	
	end; 
end;

function KroneEasyCut6210CV:mower(fruitTypeR, site)
	local numDropAreas = table.getn(self.windrowerDropAreas);
	local numAreas = table.getn(self.cuttingAreas);
    local sum = 0;
    local fruitType = fruitTypeR;	 
    local fruitTypeFix = false;
	if site == "right" then
		i = 1;
	elseif site == "left" then
		i = 2;
	end; 	
	local cuttingArea = self.cuttingAreas[i];
       if cuttingArea then
           local x,y,z = getWorldTranslation(cuttingArea.start);
           local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
           local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
		if not fruitTypeFix then
               fruitType = fruitTypeR;
           end;
		local area = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
	    area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
		Utils.updateCuttedMeadowArea(x, z, x1, z1, x2, z2);
            if area == 0 and not fruitTypeFix then
			fruitType = fruitTypeR; 
				if site == "right" then
			if self.acr < 50 then
				self.acr = self.acr + 1;
			else
				self.acr = 0; 
				Utils.setEmittingState(self.rightParticleSystems, false)
			end; 
		elseif site == "left" then
				if self.acl < 50 then
					self.acl = self.acl + 1;
				else
					self.acl = 0; 
					Utils.setEmittingState(self.leftParticleSystems, false)
				end; 
			end; 
        end;
		if area > 0 then
             fruitTypeFix = true;
			if site == "right" then
					Utils.setEmittingState(self.rightParticleSystems, true)
				elseif site == "left" then
					Utils.setEmittingState(self.leftParticleSystems, true)
				end; 
           end;
		if numDropAreas >= numAreas then
               if area > 0 then
				local dropArea = self.windrowerDropAreas[i];					
                   local x,y,z = getWorldTranslation(dropArea.start);
                   local x1,y1,z1 = getWorldTranslation(dropArea.width);
                   local x2,y2,z2 = getWorldTranslation(dropArea.height);
                   local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                   area = area + old;
                   local value = area / total;
                   if value < 1 and value > 0.08 then
                        value = 1;
                   else
                       value = math.floor(value + 0.6); -- round, biased to the bigger value
                   end;
                   if value >= 1 then
                       value = math.min(value, g_currentMission.maxWindrowValue);
                       Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
                   end;
               end;
           else
                sum = sum + area;
           end;
       end;
   end;
   if sum > 0 and numDropAreas > 0 then
    local dropArea = self.windrowerDropAreas[1];
    local x,y,z = getWorldTranslation(dropArea.start);
    local x1,y1,z1 = getWorldTranslation(dropArea.width);
    local x2,y2,z2 = getWorldTranslation(dropArea.height);
    local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
    sum = sum + old;
    local value = math.floor(sum / total + 0.7); -- round, biased to the bigger value
    if value >= 1 then
        value = math.min(value, g_currentMission.maxWindrowValue);
        Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);	
    end;
end; 