-- ##########################################
-- #	RotateOBJ							#
-- #	version: 1.0						#
-- #	Date: 09.01.2013					#
-- #	author: [FSM]Webby					#
-- #	hp: fieldstar.forumprofi.de			#
-- #										#
-- # 	Keine Vernderung ohne				# 
-- # 	meine Erlaubnis!					#
-- # 	No modification without				# 
-- # 	my permission!						#
-- #										#
-- #	history:							#
-- #	v1.0	Project started				#
-- #										#
-- ########################################## 	

RotateOBJ = {};

function RotateOBJ.prerequisitesPresent(specializations)
	print("RotateOBJ v1.0 by [FSM]Webby loaded!");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function RotateOBJ:load(xmlFile)
	self.rotateO = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.rotateO.rotor(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
             break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"),0.003);
        if node ~= nil then
            table.insert(self.rotateO, {node=node,speed=speed});
        end;
        i = i + 1;
    end;
end;

function RotateOBJ:delete()

end;

function RotateOBJ:mouseEvent(posX, posY, isDown, isUp, button)

end;

function RotateOBJ:keyEvent(unicode, sym, modifier, isDown)

end;

function RotateOBJ:update(dt)
end;

function RotateOBJ:updateTick(dt)
	if self.isMotorStarted then
        for _,v in pairs(self.rotateO) do
            if v.node ~= nil then
                rotate(v.node,v.speed*dt,0,0)
            end;
        end;
	end;
end;

function RotateOBJ:draw()

end;

function RotateOBJ:onEnter()
	
end;

function RotateOBJ:onLeave()

end;