-- MultiGroundParticelSystem
-- Specialization for mods with MultiGroundParticelSystems
--
-- @author  Tobias F.(John Deere 6930)
-- @date  23/03/10
--

MultiGroundParticelSystem = {};

function MultiGroundParticelSystem.prerequisitesPresent(specializations)
    return true;
end;

function MultiGroundParticelSystem:load(xmlFile)	
	self.multiGroundParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.multiGroundParticleSystems.node(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.multiGroundParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		i = i +1;		
    end;	
    self.groundParticleSystemActive = false;
end;

function MultiGroundParticelSystem:delete()
    Utils.deleteParticleSystem(self.multiGroundParticleSystems);
end;

function MultiGroundParticelSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MultiGroundParticelSystem:keyEvent(unicode, sym, modifier, isDown)
end;

function MultiGroundParticelSystem:update(dt)
    if self:getIsActive() then
        if self.movingDirection ~= 0 and self.isTurnedOn then
            if not self.groundParticleSystemActive then
				Utils.setEmittingState(self.multiGroundParticleSystems, true);
                self.groundParticleSystemActive = true;
            end;
		else
            if self.groundParticleSystemActive then
				Utils.setEmittingState(self.multiGroundParticleSystems, false);			
                self.groundParticleSystemActive = false;
            end;
        end;
    end;
end;


function MultiGroundParticelSystem:draw()
end;

function MultiGroundParticelSystem:onLeave()
    if self.deactivateOnLeave then
        MultiGroundParticelSystem.onDeactivate(self);
    end;
end;

function MultiGroundParticelSystem:onDeactivate()
    if self.groundParticleSystemActive then
		Utils.setEmittingState(self.multiGroundParticleSystems, false);
        self.groundParticleSystemActive = false;
    end;
end;