--
-- KroneVarioPack
-- Class for all KroneVarioPacks
--
-- @author  Felix "Outlaw" S.
-- @date  04/04/09
--
-- Copyright (C) Outlaw, Confidential, All Rights Reserved.

KroneVarioPack = {};

function KroneVarioPack.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function KroneVarioPack:load(xmlFile)	
	self.loadBale = KroneVarioPack.loadBale;
	self.rotBale = KroneVarioPack.rotBale;
	self.setEmittingState = KroneVarioPack.setEmittingState;

	----------###########	dustPartcle	############------------------	
	self.dustParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.dustParticleSystems.particleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};
			local node =  Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"));
			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, node, false, "$data/vehicles/particleSystems/threshingCutterMiddleParticleSystem.i3d", self.baseDirectory);
			self.dustParticleSystems[desc.index] = currentPS;
			if self.defaultDustParticleSystem == nil then
				self.defaultDustParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;	
	
	----------###########	PickUpPartcle	############------------------
	self.pickupParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.pickupParticleSystems.particleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};
			local node =  Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"));
			local particleNode = Utils.loadStaticParticleSystem(xmlFile, currentPS, key, node, false, "$data/vehicles/particleSystems/threshingCutterMiddleParticleSystem.i3d", self.baseDirectory);
			self.pickupParticleSystems[desc.index] = currentPS;
			if self.defaultPickupParticleSystem == nil then
				self.defaultPickupParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;
	
	----------###########	Balles	############------------------
	self.BaleScal = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTypes#scaleDummy"));
	self.BaleLink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTypes#DummyLink"));
	self.baleTypes = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.baleTypes.baleType(%d)", i);
		local t = getXMLString(xmlFile, key.."#fruitType");
		local filename = getXMLString(xmlFile, key.."#filename");
		if t==nil or filename==nil then
			break;
		end;

		local entry = {};
		entry.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fillScale"),self.fillScale);
		entry.filename = filename;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			self.baleTypes[desc.index] = entry;
			self.defaultBaleType = entry;
		end;
		i = i +1;
	end;
	self.currentBale = {};
	self.BaleCount = 0;
	
	----------###########	PeepSound	############------------------	
    local piepSound = getXMLString(xmlFile, "vehicle.piep#file");
    if piepSound ~= nil and piepSound ~= "" then
        piepSound = Utils.getFilename(piepSound, self.baseDirectory);
        self.piepSound = createSample("piepSound");
        loadSample(self.piepSound, piepSound, false);
        self.piepSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.piep#pitchOffset"), 1);
        self.piepSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.piep#volume"), 1);
    end;

	self.playWarning = false;
	----------###########	HUD	############------------------
	local x,y = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.HUD#BasePos"),"0 0"));
	local height = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.HUD#BaseHeight"),0.15);
	local width = height* Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.HUD#WidthMultiplicator"),height*10);
	self.BaleCountPosition = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.HUD#BaleCountPosi"),string.format("%0.2f %0.2f",x,y)))};
	
	local FileHUDBase = getXMLString(xmlFile,"vehicle.HUD#Basefile");
	FileHUDBase = Utils.getFilename(FileHUDBase, self.baseDirectory);	
	
	local StopFile = getXMLString(xmlFile,"vehicle.HUD#StopFile");
	StopFile = Utils.getFilename(StopFile, self.baseDirectory);	
	
	local WickelFile = getXMLString(xmlFile,"vehicle.HUD#WickelFile");
	WickelFile = Utils.getFilename(WickelFile, self.baseDirectory);	
	
	local PickUpFile = getXMLString(xmlFile,"vehicle.HUD#PickUpFile");
	PickUpFile = Utils.getFilename(PickUpFile, self.baseDirectory);
	
	local FillLevelHud = getXMLString(xmlFile,"vehicle.HUD#FillLevel");
	FillLevelHud = Utils.getFilename(FillLevelHud, self.baseDirectory);
  
	self.HUDBase = Overlay:new("Krone_HUDBase", FileHUDBase, x,y, width, height);
	self.Stop = Overlay:new("StopFile", StopFile, x,y, width, height);
	self.Wickel = Overlay:new("WickelFile", WickelFile, x,y, width, height);
	self.PickUpP = Overlay:new("PickUpFile", PickUpFile, x,y, width, height);
	
	local x,y = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.HUD#LevelPosi"),"0 0"));
	local width,height = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.HUD#Levelsize"),"0 0"));
	self.FillLevelHud = Overlay:new("FillLevelHud", FillLevelHud, x,y, width, height);
	self.FillLevelHudHeight =  height;
   
   self.HUDActive = true;
   self.renderPickUp = false;
	----------###########	Klappe	############------------------
	self.klappe = {};
	self.klappe.colli = Utils.getNoNil(getXMLInt(xmlFile,"vehicle.klappe#Colli"),1);	
	self.klappe.minRot = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.klappe#minRot"),"0 0 0"))};
	for k,v in pairs(self.klappe.minRot) do
		self.klappe.minRot[k] = Utils.degToRad(v);
	end;
	self.klappe.maxRot = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.klappe#maxRot"),"0 0 0"))};
	for k,v in pairs(self.klappe.maxRot) do
		self.klappe.maxRot[k] = Utils.degToRad(v);
	end;
	self.klappe.MoveTime = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.klappe#MoveTime"),5)*1000;	
	self.klappe.openBack = false;
	self.klappe.openedBack = 0;	

	self.klappeDelay = -1;
	self.klappeDelay2 = -1;
	----------###########	Pickup	############------------------
	self.pickUp = {};
	self.pickUp.colli = Utils.getNoNil(getXMLInt(xmlFile,"vehicle.pickUp#Colli"),1);	
	self.pickUp.minRot = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.pickUp#minRot"),"0 0 0"))};
	for k,v in pairs(self.pickUp.minRot) do
		self.pickUp.minRot[k] = Utils.degToRad(v);
	end;
	self.pickUp.maxRot = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile,"vehicle.pickUp#maxRot"),"0 0 0"))};
	for k,v in pairs(self.pickUp.maxRot) do
		self.pickUp.maxRot[k] = Utils.degToRad(v);
	end;
	self.pickUp.MoveTime = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.pickUp#MoveTime"),5)*1000;
	self.pickUp.currentRotLimit = {0,0,0};
	self.pickUp.MoveUp = false;
	----------###########	Shader	############------------------
	self.StabFoerderer = {};
	local i = 0;
	while true do
		local baseString = string.format("vehicle.chains.chain(%d)",i);
		local entry = {};
		local node = getXMLString(xmlFile,baseString.."#index");
		if node == nil then
			break;
		else
			entry.node = Utils.indexToObject(self.components,node);
			entry.ParamName = Utils.getNoNil(getXMLString(xmlFile,baseString.."#Parameter"),"movingDirection");
			entry.speed = Utils.getNoNil(getXMLFloat(xmlFile,baseString.."#Speed"),1);
			setShaderParameter(entry.node, entry.ParamName, 0,0,0,0,false);
			entry.offset = 0;
			table.insert(self.StabFoerderer,entry);
		end;
		i = i+1;
	end;
	----------###########	sonsiges	############------------------
    self.allowFillType = KroneVarioPack.allowFillType;

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;
	
    self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
	
	self.restDeltaFillLevel = 1;
    self.wasToFast = false;
    self.block = false;
    self.GenBalle = true;	
    self.isTurnedOn = false;	
	
	self.niederhalter = {};
	self.niederhalter.node1 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.niederHalter#index"));
	self.niederhalter.node2 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.niederHalter#ColliIndex"));
	self.niederhalter.node3 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.niederHalter#RotPart"));
	self.niederhalter.node4 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.niederHalter#Wheel"));
    
	local count = getXMLInt(xmlFile, "vehicle.drums#count");
    self.drums = {}
	local part = self.drums;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.drums.part" .. "%d", i);
	    part[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partname .. "#index"));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#rot"));
		part[i].rot = {};
	    part[i].rot[1] = Utils.getNoNil(x, 0);
	    part[i].rot[2] = Utils.getNoNil(y, 0);
	    part[i].rot[3] = Utils.getNoNil(z, 0);
    end;	
	
	g_currentMission.UpdateVarioPackBalles = true;
	self.fillScaleOrg = self.fillScale;
end;


function KroneVarioPack:update(dt)
	if g_currentMission.UpdateVarioPackBalles == true then
		for k,v in pairs(g_currentMission.itemsToSave)do
			i, j = string.find(v.i3dFilename, "KroneVarioPack1500")
			if i ~= nil and j ~= nil then
				setMass(v.node, 0.7);
			end;
		end;
		g_currentMission.UpdateVarioPackBalles = false;
	end;

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self.isTurnedOn = not self.isTurnedOn;
		end;		
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self.pickUp.MoveUp = not self.pickUp.MoveUp;
		end;		
		if InputBinding.hasEvent(InputBinding.reset) then
			self:setFillLevel(0, FruitUtil.FRUITTYPE_UNKNOWN);
			delete(self.currentBale.id);
			self.currentBale = {};
			self.BaleCount = 0;
		end;
	end;
    if self:getIsActive() then 
		self.renderPickUp = false;
		
		local hasGroundContact = false;
        local x,y,z = getWorldTranslation(self.groundReferenceNode);
        local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
        if terrainHeight+self.groundReferenceThreshold >= y then
            hasGroundContact = true;
        end;
	
		local newRotLimit = Utils.getMovedLimitedValues(self.pickUp.currentRotLimit, self.pickUp.minRot, self.pickUp.maxRot, 3, self.pickUp.MoveTime , dt, self.pickUp.MoveUp);
		self.pickUp.currentRotLimit = newRotLimit;
		for i=1,3 do
			setJointRotationLimit(self.componentJoints[self.pickUp.colli].jointIndex, i-1, true, 0, newRotLimit[i]);
		end;
		setRotation(self.niederhalter.node1,-newRotLimit[1],-newRotLimit[2],-newRotLimit[3]);
		if newRotLimit[1] ~= self.pickUp.minRot[1] then
			self.renderPickUp = true;
		end;
		
        if self.isTurnedOn then
			for i=1, table.getn(self.drums) do
				rotate(self.drums[i].index, self.drums[i].rot[1]  * dt, self.drums[i].rot[2]  * dt, self.drums[i].rot[3]  * dt);
			end;
			local x,y,z = getRotation(self.niederhalter.node4);
			setRotation(self.niederhalter.node3,x,y,z);
			
			if not self.block then
				local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 29;
				if not toFast then
					local totalArea =0;
					local usedFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
					local percent = self.fillLevel/self.capacity;
					for k, cuttingArea in pairs(self.cuttingAreas) do
						local x,y,z = getWorldTranslation(cuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
						for fruitType,v in pairs(self.fillTypes) do
							if fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN and hasGroundContact then
								local area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio;
								area = area + Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
								if area > 0 then
									local spray = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.sprayChannel, x, z, x1, z1, x2, z2);
									local multi = 1;
									if spray > 0 then
										multi = 2;
									end;
									totalArea = totalArea+area*multi;
									usedFruitType = fruitType;
								end;
							end;
						end;
					end;
					self:setEmittingState(usedFruitType,totalArea);
					if self.fillLevel <= 0 and usedFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
						local baleType = self.baleTypes[usedFruitType];
						if baleType == nil then
							baleType = self.defaultBaleType;
						end;
						local baleRoot = Utils.loadSharedI3DFile(baleType.filename, self.baseDirectory);

						local baleId = getChildAt(baleRoot, 0);
						setRigidBodyType(baleId, "None");
						link(self.BaleLink, baleId);
						delete(baleRoot);
						self.currentBale.id = baleId;
						self.currentBale.filename = baleType.filename;
						self:setFillLevel(1, usedFruitType);
					end;
					local Height = percent* self.FillLevelHudHeight;
					self.FillLevelHud.height = Height;	
					
					self:rotBale(dt);
					
					if percent >= 0.90 and not self.playWarning then
						setSamplePitch(self.piepSound, self.piepSoundPitchOffset);
						playSample(self.piepSound, 1, self.piepSoundVolume, 0);
						self.playWarning = true;
					end;
					if totalArea > 0  then
						
						local literPerPixel = 4*8000/1200 / 6 / (2*2) *12/4 / 4;

						local deltaLevel = totalArea * literPerPixel * self.baleTypes[usedFruitType].fillScale;

						local oldFillLevel = self.fillLevel;
						self:setFillLevel(self.fillLevel+deltaLevel, usedFruitType);
						if self.fillLevel == self.capacity then
							self.restDeltaFillLevel = deltaLevel - (self.fillLevel-oldFillLevel)
							self.block = true;
							self.klappeDelay2 = 170;
							
							local x,y,z = getWorldTranslation(self.currentBale.id);
							local rx,ry,rz = getWorldRotation(self.currentBale.id);
							link(getRootNode(), self.currentBale.id);
							setTranslation(self.currentBale.id, x, y, z);
							setRotation(self.currentBale.id, rx, ry, rz);
							g_currentMission:addItemToSave(Utils.getFilename(self.currentBale.filename, self.baseDirectory), self.currentBale.id, 0);						
							setRigidBodyType(self.currentBale.id, "Dynamic");							
							--self:setFillLevel(self.restDeltaFillLevel, usedFruitType);
							self:setFillLevel(0, usedFruitType);
						end;
						
					end;
				else
					self:setEmittingState(nil);
				end;
			else
				if self.klappe.openedBack == 1 and self.klappe.openBack == true then	
					if self.GenBalle then
						self.klappeDelay = 120;
						self.BaleCount = self.BaleCount+1;
						self.GenBalle = false;
					end;
					local x,y,z = getWorldTranslation(self.BaleLink);
					local x1,y1,z1 = getWorldTranslation(self.currentBale.id);
					local dis = Utils.vector3Length(x-x1,y-y1,z-z1);
					if dis <= 3 then
						local x1,y1,z1 = getTranslation(self.currentBale.id);
						y1 = y1+0.93167;

						local x,y,z = localDirectionToWorld(self.components[1].node,0,0,-1);
						local force = 0.05;x= x*force;y= y*force;z= z*force;
						addImpulse(self.currentBale.id,x,y,z,0,0,0, true);						

						setMass(self.currentBale.id, 0.7);
					end;
				elseif self.klappe.openedBack == -1 and self.klappe.openBack == false and self.klappeDelay2 == -1 then
					self.playWarning = false;
					self.block = false;
					self.GenBalle = true;
					self.currentBale = {};
				end;
				self:setEmittingState(nil);
            end;
			if self.klappeDelay == 0 then
				self.klappe.openBack = false;				
				self.klappeDelay = -1;
			elseif self.klappeDelay > 0 then
				self.klappeDelay = self.klappeDelay-1;
			end;			
			if self.klappeDelay2 == 0 then
				self.klappe.openBack = true;				
				self.klappeDelay2 = -1;
			elseif self.klappeDelay2 > 0 then
				self:rotBale(dt);
				self.klappeDelay2 = self.klappeDelay2-1;
			else
				self.klappeDelay2 = -1;
			end;
			
            self.wasToFast = toFast;
		else
			self:setEmittingState(nil);
        end;
		if self.componentJoints[self.klappe.colli].jointNode ~= nil then	
			local rot = {getRotation(self.componentJoints[self.klappe.colli].jointNode)};				
			local newRot = Utils.getMovedLimitedValues(rot, self.klappe.minRot, self.klappe.maxRot, 3, self.klappe.MoveTime , dt, self.klappe.openBack);
			setRotation(self.componentJoints[self.klappe.colli].jointNode,unpack(newRot));
			
			if math.abs(newRot[1]-rot[1]) > 0.001 then
				setJointFrame(self.componentJoints[self.klappe.colli].jointIndex, 0,self.componentJoints[self.klappe.colli].jointNode);
			end;
			if math.abs(self.klappe.minRot[1]-newRot[1]) < 0.001 then
				self.klappe.openedBack = -1;
			elseif math.abs(self.klappe.maxRot[1]-newRot[1]) < 0.001 then
				self.klappe.openedBack = 1;
			else
				self.klappe.openedBack = 0;
			end;
		end;
	end;

end;


function KroneVarioPack:draw()
	if self:getIsActive() and self.HUDActive then 
		self.HUDBase:render();
		self.FillLevelHud:render();
		if self.block then
			self.Stop:render();
		end;
		if self.klappeDelay2 > 0 then
			self.Wickel:render();
		end;
		if self.renderPickUp then
			self.PickUpP:render();
		end;
		setTextColor(0,0,0,1);
		setTextBold(false);
		renderText(self.BaleCountPosition[1],self.BaleCountPosition[2],0.04,string.format("%d",self.BaleCount));
	end;
	if self:getIsActiveForInput() then
		g_currentMission:addHelpButtonText(g_i18n:getText("lowerPickUp"), InputBinding.LOWER_IMPLEMENT);
		g_currentMission:addHelpButtonText(g_i18n:getText("onoff"), InputBinding.IMPLEMENT_EXTRA);
		g_currentMission:addHelpButtonText(g_i18n:getText("reset"), InputBinding.reset);
	end;
	
end;

function KroneVarioPack:rotBale(dt)
	local percent = self.fillLevel/self.capacity;
	local x3,y3,z3 = getScale(self.BaleScal);
	setScale(self.BaleScal,x3,percent,percent);
	rotate(self.BaleLink,0.007*dt,0,0);
	for k,v in pairs(self.StabFoerderer) do
		v.offset = v.offset +v.speed*dt;
		setShaderParameter(v.node, v.ParamName, v.offset,0,0,0,false);
	end;
end;


function KroneVarioPack:setEmittingState(usedFruitType, area)
	if usedFruitType ~= nil and area > 0 then
		for k,v in pairs (self.dustParticleSystems) do
			if k == usedFruitType then
				Utils.setEmittingState(v, true);
			else
				Utils.setEmittingState(v, false);
			end;
		end;
		for k,v in pairs (self.pickupParticleSystems) do
			if k == usedFruitType then
				Utils.setEmittingState(v, true);
			else
				Utils.setEmittingState(v, false);
			end;
		end;
	elseif usedFruitType == nil or area <= 0 then
		for k,v in pairs (self.dustParticleSystems) do
			Utils.setEmittingState(v, false);
		end;		
		for k,v in pairs (self.pickupParticleSystems) do
			Utils.setEmittingState(v, false);
		end;
	end;
end;


function KroneVarioPack:onDetach()
	self.deactivateOnDetach = true;
	self:onDeactivate();
end;
function KroneVarioPack:onLeave()
	self.deactivateOnDetach = true;
	self:onDeactivate();
end;

function KroneVarioPack:onAttach()

end; 
function KroneVarioPack:onDeactivate()
	self:setEmittingState(nil);
	self.isTurnedOn = false;
	self.playWarning = false;
end; 

function KroneVarioPack:delete()
	for k,v in pairs (self.dustParticleSystems) do
		Utils.deleteParticleSystem(v);
	end;	
	for k,v in pairs (self.pickupParticleSystems) do
		Utils.deleteParticleSystem(v);
	end;
	delete(self.HUDBase);
	delete(self.Stop);
	delete(self.Wickel); 
	delete(self.PickUpP);
	--	--Utils.setEmittingState(self.dustParticleSystems[type], true)
end;


function KroneVarioPack:allowFillType(fillType)
    return self.fillTypes[fillType] == true;
end;

function KroneVarioPack:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KroneVarioPack:keyEvent(unicode, sym, modifier, isDown)


end;
function KroneVarioPack:loadBale(xmlFile, key, resetVehicles)
	local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
	local fillType = getXMLString(xmlFile, key.."#fillType");
	if fillLevel ~= nil and fillLevel >0 and fillType ~= nil then
		local fillTypeDesc = FruitUtil.fruitTypes[fillType];
		if fillTypeDesc ~= nil then	
			self:setFillLevel(fillLevel, fillTypeDesc.index);
			local baleType = self.baleTypes[fillTypeDesc.index];
			if baleType == nil then
				baleType = self.defaultBaleType;
			end;
			local baleRoot = Utils.loadSharedI3DFile(baleType.filename, self.baseDirectory);

			local baleId = getChildAt(baleRoot, 0);
			setRigidBodyType(baleId, "None");
			link(self.BaleLink, baleId);
			delete(baleRoot);
			self.currentBale.id = baleId;
			self.currentBale.filename = baleType.filename;
			self:rotBale(1);
		end;
	end;
    return true;
end;