SetSidewallRightEvent = {};
SetSidewallRightEvent_mt = Class(SetSidewallRightEvent, Event);

InitEventClass(SetSidewallRightEvent, "SetSidewallRightEvent");

function SetSidewallRightEvent:emptyNew()
    local self = Event:new(SetSidewallRightEvent_mt);
    self.className="SetSidewallRightEvent";
    return self;
end;

function SetSidewallRightEvent:new(vehicle, state)
    local self = SetSidewallRightEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetSidewallRightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetSidewallRightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetSidewallRightEvent:run(connection)
	self.vehicle:setSidewallRight(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetSidewallRightEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SetSidewallRightEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetSidewallRightEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetSidewallRightEvent:new(vehicle, state));
		end;
	end;
end;