--
-- Specialization for Dolly
-- 
--
-- @author:		Marcu Hedblom a.k.a Xentro (www.ls-uk.info)
-- @version:	v1.1
-- @date:		02/09/11
-- @history:	v1.0 - inital implementation
-- 				v1.1 - 
--
-- Do not edit without my permission

Dolly = {};

function Dolly.prerequisitesPresent(specializations)
	return true;
end;

function Dolly:load(xmlFile)
	print("dolly.lua by Xentro have been loaded" );
	
	self.reverseLights = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reverseLights#index"));	
	setVisibility(self.reverseLights, false);
	
	-- delay light on attach
	self.delayLightMaxTime 	= 2000;
	self.lightTimer 		= self.delayLightMaxTime;
	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");
end;

function Dolly:delete()
end;

function Dolly:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Dolly:keyEvent(unicode, sym, modifier, isDown)
end;

function Dolly:update(dt)
	if self:getIsActive() then 
		if self.movingDirection == -1 and self:doCheckSpeedLimit() and self.lastSpeed*3600 > 0.27 and self.lightCanBeActivated then
			setVisibility(self.reverseLights, true);
		elseif self.movingDirection ~=-1  then 
			setVisibility(self.reverseLights, false);
		end;
		if self.lightsA then
			self.lightTimer = self.lightTimer - dt;
			if self.lightTimer < 0 then
				self.lightCanBeActivated = true;
			end;
		else
			self.lightTimer = self.delayLightMaxTime;
		end;
	end;
end;

function Dolly:draw()
end;

function Dolly:onAttach()
	self.lightsA = true;
end;

function Dolly:onDetach()
	setVisibility(self.reverseLights, false);
	self.lightCanBeActivated = false;
	self.lightsA = false;
end;

function Dolly:onLeave()
	setVisibility(self.reverseLights, false);
end;