-- farmerCar
-- Specialization for farmer car mod

farmerCar = {};

function farmerCar.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function farmerCar:load(xmlFile)
    hornSoundFile = Utils.getFilename("horn.wav", self.baseDirectory);
    self.hornSoundId = createSample("famerCarSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
end;

function farmerCar:delete()
    delete(self.hornSoundId);
end;

function farmerCar:mouseEvent(posX, posY, isDown, isUp, button)
end;

function farmerCar:keyEvent(unicode, sym, modifier, isDown)
end;

function farmerCar:update(dt)
    if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.FARMER_CAR_HORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
end;

function farmerCar:draw()
    g_currentMission:addHelpButtonText(g_i18n:getText("FarmerCarHorn"), InputBinding.FARMER_CAR_HORN);
end;

