--specjalizacja kosiarki z farming simulator 2013--

--source("Skrypty/SetTurnedOnEvent.lua")
--source("Skrypty/MowerAreaEvent.lua")
--source("Skrypty/MowerToggleWindrowDropEvent.lua")
zzz = {}
function zzz.prerequisitesPresent(specializations)
  return true
end
function zzz:load(xmlFile)
  self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn")
  self.setUseMower1WindrowDropAreas = Mower.setUseMower1WindrowDropAreas
  self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2)
  self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"))
  if self.groundReferenceNode == nil then
    self.groundReferenceNode = self.components[1].node
  end
  if self.isClient then
    local mower1StartSound = getXMLString(xmlFile, "vehicle.mower1StartSound#file")
    if mower1StartSound ~= nil and mower1StartSound ~= "" then
      mower1StartSound = Utils.getFilename(mower1StartSound, self.baseDirectory)
      self.mower1StartSound = createSample("mower1StartSound")
      loadSample(self.mower1StartSound, mower1StartSound, false)
      self.mower1StartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1StartSound#pitchOffset"), 1)
      self.mower1StartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1StartSound#volume"), 1)
      setSamplePitch(self.mower1StartSound, self.mower1StartSoundPitchOffset)
    end
    self.mower1SoundEnabled = false
    local mower1Sound = getXMLString(xmlFile, "vehicle.mower1Sound#file")
    if mower1Sound ~= nil and mower1Sound ~= "" then
      mower1Sound = Utils.getFilename(mower1Sound, self.baseDirectory)
      self.mower1Sound = createSample("mower1Sound")
      loadSample(self.mower1Sound, mower1Sound, false)
      self.mower1SoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1Sound#pitchOffset"), 1)
      self.mower1SoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1Sound#volume"), 1)
      setSamplePitch(self.mower1Sound, self.mower1SoundPitchOffset)
      self.mower1Sound3DVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1Sound#volume3D"), self.mowerSoundVolume)
      self.mower1Sound3DInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1Sound#innerRadius"), 10)
      self.mower1Sound3DRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1Sound#radius"), 50)
      self.mower1Sound3D = createAudioSource("mower1Sound3D", mower1Sound, self.mower1Sound3DRadius, self.mower1Sound3DInnerRadius, self.mower1Sound3DVolume, 0)
      setSamplePitch(getAudioSourceSample(self.mower1Sound3D), self.mower1SoundPitchOffset)
      link(self.components[1].node, self.mower1Sound3D)
      setVisibility(self.mower1Sound3D, false)
    end
    local mower1StopSound = getXMLString(xmlFile, "vehicle.mower1StopSound#file")
    if mower1StopSound ~= nil and mower1StopSound ~= "" then
      mower1StopSound = Utils.getFilename(mower1StopSound, self.baseDirectory)
      self.mower1StopSound = createSample("mower1StopSound")
      loadSample(self.mower1StopSound, mower1StopSound, false)
      self.mower1StopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1StopSound#pitchOffset"), 1)
      self.mower1StopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1StopSound#volume"), 1)
      setSamplePitch(self.mower1StopSound, self.mower1StopSoundPitchOffset)
    end
  end
  self.turnedOnRotationNodes = {}
  local i = 0
  while true do
    do
      local key = string.format("vehicle.turnedOnRotationNodes.turnedOnRotationNode(%d)", i)
      if not hasXMLProperty(xmlFile, key) then
        break
      end
      local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"))
      local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key .. "#rotSpeed"), 1) * 0.001)
      if node ~= nil then
        table.insert(self.turnedOnRotationNodes, {node = node, rotSpeed = rotSpeed})
      end
      i = i + 1
    end
  end
  self.mower1TurnOnAnimation = getXMLString(xmlFile, "vehicle.mower1TurnOnAnimation#name")
  self.mower1TurnOnAnimationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1TurnOnAnimation#turnOnSpeed"), 1)
  self.mower1TurnOffAnimationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1TurnOnAnimation#turnOffSpeed"), -self.mower1TurnOnAnimationSpeed)
  self.mower1WindrowDropAreas = {}
  local i = 0
  while true do
    do
      local areaKey = string.format("vehicle.mower1WindrowDropAreas.mower1WindrowDropArea(%d)", i)
      if not hasXMLProperty(xmlFile, areaKey) then
        break
      end
      local area = {}
      if self:loadAreaFromXML(area, xmlFile, areaKey) then
        area.value = 0
        area.valueAccum = 0
        table.insert(self.mower1WindrowDropAreas, area)
      end
      i = i + 1
    end
  end
  self.useMower1WindrowDropAreas = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.mower1ToggleWindrowDrop#startEnabled"), 0 < table.getn(self.mower1WindrowDropAreas))
  local i18n = g_i18n
  if self.customEnvironment ~= nil then
    i18n = _G[self.customEnvironment].g_i18n
  end
  self.mower1ToggleWindrowDropEnableText = getXMLString(xmlFile, "vehicle.mower1ToggleWindrowDrop#enableText")
  self.mower1ToggleWindrowDropDisableText = getXMLString(xmlFile, "vehicle.mower1ToggleWindrowDrop#disableText")
  if self.mower1ToggleWindrowDropEnableText ~= nil then
    self.mower1ToggleWindrowDropEnableText = i18n:getText(self.mower1ToggleWindrowDropEnableText)
  end
  if self.mower1ToggleWindrowDropDisableText ~= nil then
    self.mower1ToggleWindrowDropDisableText = i18n:getText(self.mower1ToggleWindrowDropDisableText)
  end
  self.mower1ToggleWindrowDropAnimation = getXMLString(xmlFile, "vehicle.mower1ToggleWindrowDrop#animationName")
  self.mower1EnableWindrowDropAnimationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1ToggleWindrowDrop#animationEnableSpeed"), 1)
  self.mower1DisableWindrowDropAnimationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1ToggleWindrowDrop#animationDisableSpeed"), -self.mower1EnableWindrowDropAnimationSpeed)
  self.mower1PickupFillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mower1CutAreas#pickupFillScale"), 1)
  self.mower1CutAreasSend = {}
  self.mower1CutAreas = {}
  local i = 0
  while true do
    do
      local areaKey = string.format("vehicle.mower1CutAreas.mower1CutArea(%d)", i)
      if not hasXMLProperty(xmlFile, areaKey) then
        break
      end
      local area = {}
      if self:loadAreaFromXML(area, xmlFile, areaKey) then
        area.dropWindrow = Utils.getNoNil(getXMLBool(xmlFile, areaKey .. "#dropWindrow"), true)
        area.dropArea = getXMLInt(xmlFile, areaKey .. "#dropArea")
        if area.dropArea ~= nil and self.mower1WindrowDropAreas[area.dropArea] == nil then
          area.dropArea = nil
        end
        table.insert(self.mower1CutAreas, area)
        table.insert(self.mower1CutAreasSend, {})
      end
      i = i + 1
    end
  end
  if table.getn(self.mower1CutAreas) == 0 then
    for _, cuttingArea in pairs(self.cuttingAreas) do
      cuttingArea.dropWindrow = true
      table.insert(self.mower1CutAreas, cuttingArea)
      table.insert(self.mower1CutAreasSend, {})
    end
  end
  self.isTurnedOn = false
  self.wasToFast = false
  self.mowerGroundFlag = self:getNextDirtyFlag()
end
function zzz:delete()
  if self.mower1StartSound ~= nil then
    delete(self.mower1StartSound)
  end
  if self.mower1Sound ~= nil then
    delete(self.mower1Sound)
    self.mower1SoundEnabled = false
  end
  if self.mower1StopSound ~= nil then
    delete(self.mower1StopSound)
  end
end
function zzz:readStream(streamId, connection)
  local turnedOn = streamReadBool(streamId)
  self:setIsTurnedOn(turnedOn, true)
  if self.mower1ToggleWindrowDropEnableText ~= nil and self.mower1ToggleWindrowDropDisableText ~= nil then
    local useMower1WindrowDropAreas = streamReadBool(streamId)
    self:setUseMower1WindrowDropAreas(useMower1WindrowDropAreas, true)
  end
end
function zzz:writeStream(streamId, connection)
  streamWriteBool(streamId, self.isTurnedOn)
  if self.mower1ToggleWindrowDropEnableText ~= nil and self.mower1ToggleWindrowDropDisableText ~= nil then
    streamWriteBool(streamId, self.useMower1WindrowDropAreas)
  end
end
function zzz:readUpdateStream(streamId, timestamp, connection)
end
function zzz:writeUpdateStream(streamId, connection, dirtyMask)
end
function zzz:mouseEvent(posX, posY, isDown, isUp, button)
end
function zzz:keyEvent(unicode, sym, modifier, isDown)
end
function zzz:update(dt)
  if self:getIsActive() then
    if self:getIsActiveForInput() then
      if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
        self:setIsTurnedOn(not self.isTurnedOn)
      end
      if self.mower1ToggleWindrowDropEnableText ~= nil and self.mower1ToggleWindrowDropDisableText ~= nil and InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
        self:setUseMower1WindrowDropAreas(not self.useMower1WindrowDropAreas)
      end
    end
    if self.isTurnedOn then
      for _, node in pairs(self.turnedOnRotationNodes) do
        rotate(node.node, 0, -dt * node.rotSpeed, 0)
        if self.setMovingToolDirty ~= nil then
          self:setMovingToolDirty(node.node)
        end
      end
    end
  end
end
function zzz:updateTick(dt)
  self.wasToFast = false
  if self:getIsActive() and self.isTurnedOn then
    local toFast = self:doCheckSpeedLimit() and self.lastSpeed * 3600 > 31
    if not toFast and self.isServer then
      local x, y, z = getWorldTranslation(self.groundReferenceNode)
      local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z)
      if y <= terrainHeight + self.groundReferenceThreshold then
        local foldAnimTime = self.foldAnimTime
        local numAreasSend = 0
        local numDropAreas = 0
        local areasSend = self.mower1CutAreasSend
        for _, area in pairs(self.mower1CutAreas) do
          if self:getIsAreaActive(area) then
            numAreasSend = numAreasSend + 1
            areasSend[numAreasSend].x, _, areasSend[numAreasSend].z = getWorldTranslation(area.start)
            areasSend[numAreasSend].x1, _, areasSend[numAreasSend].z1 = getWorldTranslation(area.width)
            areasSend[numAreasSend].x2, _, areasSend[numAreasSend].z2 = getWorldTranslation(area.height)
            areasSend[numAreasSend].dropWindrow = area.dropWindrow
            areasSend[numAreasSend].dropArea = area.dropArea
            if self.useMower1WindrowDropAreas then
              areasSend[numAreasSend].dropWindrow = true
            else
              areasSend[numAreasSend].dropArea = nil
            end
          end
        end
        for _, area in pairs(self.mower1WindrowDropAreas) do
          numDropAreas = numDropAreas + 1
          area.x, _, area.z = getWorldTranslation(area.start)
          area.x1, _, area.z1 = getWorldTranslation(area.width)
          area.x2, _, area.z2 = getWorldTranslation(area.height)
        end
        if numAreasSend > 0 then
          local numAreasUsed, numDropAreasUsed, pickedUpWindrow = MowerAreaEvent.runLocally(areasSend, numAreasSend, self.mower1WindrowDropAreas, numDropAreas)
          if numAreasUsed > 0 or numDropAreasUsed > 0 then
            g_server:broadcastEvent(MowerAreaEvent:new(areasSend, numAreasUsed, self.mower1WindrowDropAreas, numDropAreas, numDropAreasUsed))
          end
          if pickedUpWindrow > 0 and self.allowFillType ~= nil and self:allowFillType(Fillable.FILLTYPE_GRASS_WINDROW) then
            local fillDelta = pickedUpWindrow * FruitUtil.getFillTypeLiterPerSqm(Fillable.FILLTYPE_GRASS_WINDROW, 1) * self.mower1PickupFillScale
            self:setFillLevel(self:getFillLevel(Fillable.FILLTYPE_GRASS_WINDROW) + fillDelta, Fillable.FILLTYPE_GRASS_WINDROW)
          end
        end
      end
    end

    if self.isClient then
      if self:getIsActiveForSound() then
        if self.mower1Sound ~= nil and not self.mower1SoundEnabled and (self.mower1StartSound == nil or not isSamplePlaying(self.mower1StartSound) or getSamplePlayOffset(self.mower1StartSound) >= getSampleDuration(self.mower1StartSound) - 1.8 * dt) then
          playSample(self.mower1Sound, 0, self.mower1SoundVolume, 0)
          self.mower1SoundEnabled = true
        end
        if self.mower1Sound3D ~= nil then
          setVisibility(self.mower1Sound3D, false)
        end
      elseif self.mower1Sound3D ~= nil then
        setVisibility(self.mower1Sound3D, true)
      end
    end
    self.wasToFast = toFast
  end
end
function zzz:draw()
  if self.isClient then
    if self:getIsActiveForInput(true) then
      if self.isTurnedOn then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA)
      else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA)
      end
      if self.mower1ToggleWindrowDropEnableText ~= nil and self.mower1ToggleWindrowDropDisableText ~= nil then
        if self.useMower1WindrowDropAreas then
          g_currentMission:addHelpButtonText(string.format(self.mower1ToggleWindrowDropDisableText, self.typeDesc), InputBinding.IMPLEMENT_EXTRA3)
        else
          g_currentMission:addHelpButtonText(string.format(self.mower1ToggleWindrowDropEnableText, self.typeDesc), InputBinding.IMPLEMENT_EXTRA3)
        end
      end
    end
    if self.wasToFast then
      g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2"), 0.092, 0.048)
    end
  end
end
--[[function zzz:onDetach()
  if self.deactivateOnDetach then
    Mower1.onDeactivate(self)
  else
    Mower1.onDeactivateSounds(self)
  end
end]]
function zzz:onLeave()
  if self.deactivateOnLeave then
    Mower1.onDeactivate(self)
  else
    Mower1.onDeactivateSounds(self)
  end
end
--[[function zzz:onDeactivate()
  Mower1.onDeactivateSounds(self)
  self:setIsTurnedOn(false, true)
end]]
function zzz:onDeactivateSounds()
  if self.isClient then
    if self.mower1SoundEnabled then
      stopSample(self.mower1Sound)
      self.mower1SoundEnabled = false
    end
    if self.mower1Sound3D ~= nil then
      setVisibility(self.mower1Sound3D, false)
    end
  end
end
function zzz:setIsTurnedOn(isTurnedOn, noEventSend)
  if isTurnedOn ~= self.isTurnedOn then
    SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend)
    self.isTurnedOn = isTurnedOn
    if self.isClient then
      if self.mower1SoundEnabled then
        stopSample(self.mower1Sound)
        self.mower1SoundEnabled = false
      end
      if self.mower1StartSound ~= nil then
        stopSample(self.mower1StartSound)
      end
      if self.mower1StopSound ~= nil then
        stopSample(self.mower1StopSound)
      end
      if self.mower1Sound3D ~= nil then
        setVisibility(self.mower1Sound3D, false)
      end
      if self:getIsActiveForSound() then
        if self.isTurnedOn then
          if self.mower1StartSound ~= nil then
            playSample(self.mower1StartSound, 1, self.mower1StartSoundVolume, 0)
          end
        elseif self.mower1StopSound ~= nil then
          playSample(self.mower1StopSound, 1, self.mower1StopSoundVolume, 0)
        end
      end
    end
    if self.mower1TurnOnAnimation ~= nil and self.playAnimation ~= nil then
      local speed = self.mower1TurnOnAnimationSpeed
      if not self.isTurnedOn then
        speed = self.mower1TurnOffAnimationSpeed
      end
      self:playAnimation(self.mower1TurnOnAnimation, speed, nil, true)
    end
  end
end
function zzz:setUseMower1WindrowDropAreas(useMower1WindrowDropAreas, noEventSend)
  if useMower1WindrowDropAreas ~= self.useMower1WindrowDropAreas then
    Mower1ToggleWindrowDropEvent.sendEvent(self, useMower1WindrowDropAreas, noEventSend)
    self.useMower1WindrowDropAreas = useMower1WindrowDropAreas
    if self.mower1ToggleWindrowDropAnimation ~= nil and self.playAnimation ~= nil then
      local speed = self.mower1EnableWindrowDropAnimationSpeed
      if not useMower1WindrowDropAreas then
        speed = self.mower1DisableWindrowDropAnimationSpeed
      end
      self:playAnimation(self.mower1ToggleWindrowDropAnimation, speed, nil, true)
    end
  end
end