--
-- GroundPartikelSystem
-- Specialization for mods with GroundPartikelSystems
--
-- @author  Tobias Fricke (1.LS Modschmiede)
-- @date  06/07/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

GroundPartikelSystem = {};

function GroundPartikelSystem.prerequisitesPresent(specializations)
    return true;
end;

function GroundPartikelSystem:load(xmlFile)
    self.groundParticleSystems = {};
    local psName = "vehicle.groundParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.groundParticleSystems, psName, self.components, false, nil, self.baseDirectory)
    self.groundParticleSystemActive = false;

end;

function GroundPartikelSystem:delete()
    Utils.deleteParticleSystem(self.groundParticleSystems);
end;

function GroundPartikelSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;

function GroundPartikelSystem:keyEvent(unicode, sym, modifier, isDown)
end;

function GroundPartikelSystem:update(dt)

    if self:getIsActive() then
        if self.movingDirection ~= 0 and self.isTurnedOn then
            if not self.groundParticleSystemActive then
                self.groundParticleSystemActive = true;
                Utils.setEmittingState(self.groundParticleSystems, true);
            end;
		else
            if self.groundParticleSystemActive then
                self.groundParticleSystemActive = false;
                Utils.setEmittingState(self.groundParticleSystems, false);
            end;
        end;
    end;
end;


function GroundPartikelSystem:draw()
end;

function GroundPartikelSystem:onLeave()
    if self.deactivateOnLeave then
        GroundPartikelSystem.onDeactivate(self);
    end;
end;

function GroundPartikelSystem:onDeactivate()
    if self.groundParticleSystemActive then
        self.groundParticleSystemActive = false;
        Utils.setEmittingState(self.groundParticleSystems, false);
    end;
end;