--
-- Koegel
-- Specialization for Koegel
--
-- @author:		JoPi
--				JoXXer
-- @date:		19/06/14
-- @version:	v1.0
-- @history:	v1.0 - initial version
--
-- free for noncommercial-usage

Koegel = {};

function Koegel.prerequisitesPresent(specializations)
	Vehicle.registerJointType("augerCoupling");
	return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Koegel:load(xmlFile)
	self.toggleGrainDoor = SpecializationUtil.callSpecializationsFunction("toggleGrainDoor");
	self.getCanTip = Utils.overwrittenFunction(self.getCanTip, Koegel.getCanTip);
	self.fillLitersPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillLitersPerSecond"), 500);
	self.setIsSowingMachineFilling = Koegel.setIsSowingMachineFilling;
	self.addSowingMachineFillTrigger = Koegel.addSowingMachineFillTrigger;
	self.removeSowingMachineFillTrigger = Koegel.removeSowingMachineFillTrigger;
	self.isSowingMachineFilling = false;
	self.sowingMachineFillTriggers = {};
	self.sowingMachineFillActivatable = SowingMachineFillActivatable:new(self);
	self.setIsSprayerFilling = Koegel.setIsSprayerFilling;
	self.addSprayerFillTrigger = Koegel.addSprayerFillTrigger;
	self.removeSprayerFillTrigger = Koegel.removeSprayerFillTrigger;
	self.isSprayerFilling = false;
	self.sprayerFillTriggers = {};
	self.sprayerFillActivatable = SprayerFillActivatable:new(self);
	self.grainDoor = {};
	self.grainDoor.animationName = getXMLString(xmlFile, "vehicle.grainDoor#animationName");
	self.grainDoor.openNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainDoor#openNode"));
	self.grainDoor.minDistance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainDoor#minDistance"), 1);
	self.grainDoor.allowOpening = false;
	self.grainDoor.inRange = false;
	self.isGrainDoorOpen = false;
	self.isAugerAttached = false;
	for a=1, table.getn(self.movingTools) do
		if self.movingTools[a].rotSpeed ~= nil then
			self.movingTools[a].rotSpeedBackup = self.movingTools[a].rotSpeed;
		end;
	end;
end;

function Koegel:delete()
	g_currentMission:removeActivatableObject(self.sowingMachineFillActivatable);
	g_currentMission:removeActivatableObject(self.sprayerFillActivatable);
end;

function Koegel:readStream(streamId, connection)
	local isGrainDoorOpen = streamReadBool(streamId);
	self:toggleGrainDoor(isGrainDoorOpen, true);
	local isSowingMachineFilling = streamReadBool(streamId);
	self:setIsSowingMachineFilling(isSowingMachineFilling, true);
	local isSprayerFilling = streamReadBool(streamId);
	self:setIsSprayerFilling(isSprayerFilling, true);
end;

function Koegel:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isGrainDoorOpen);
	streamWriteBool(streamId, self.isSowingMachineFilling);
	streamWriteBool(streamId, self.isSprayerFilling);
end;

function Koegel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Koegel:keyEvent(unicode, sym, modifier, isDown)
end;

function Koegel:update(dt)
	if self.grainDoor.allowOpening then
		if self.grainDoor.openNode then
			if self.grainDoor.inRange then
				if InputBinding.hasEvent(InputBinding.GRAIN_DOOR) then
					self:toggleGrainDoor(not self.isGrainDoorOpen);
				end;
				if self.isGrainDoorOpen then
					g_currentMission:addHelpButtonText(g_i18n:getText("CLOSE_GRAIN_DOOR"), InputBinding.GRAIN_DOOR);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("OPEN_GRAIN_DOOR"), InputBinding.GRAIN_DOOR);
				end;
			end;
		end;
	else
		self:toggleGrainDoor(false);
	end;
	if self.isGrainDoorOpen then
		self.allowOvercharge = true;
	else
		self.allowOvercharge = false;
		self:setUnloadingState(false);
	end;
end;

function Koegel:updateTick(dt)
	if self.isServer and self.isSowingMachineFilling or self.isSprayerFilling then
		local delta = 0;
		if self.sowingMachineFillTrigger ~= nil and (self.fillLevel == 0 or Fillable.FILLTYPE_SEEDS) then
			delta = self.fillLitersPerSecond*dt*0.001;
			delta = self.sowingMachineFillTrigger:fillSowingMachine(self, delta);
		end;
		if self.sprayerFillTrigger ~= nil and (self.fillLevel == 0 or Fillable.FILLTYPE_FERTILIZER) then
			delta = self.fillLitersPerSecond*dt*0.001;
			delta = self.sprayerFillTrigger:fillSprayer(self, delta);
		end;
		if delta <= 0 then
			self:setIsSowingMachineFilling(false);
			self:setIsSprayerFilling(false);
		end;
	end;
	if self.grainDoor.openNode then
		if g_currentMission.player ~= nil then
			local px,py,pz = getWorldTranslation(self.grainDoor.openNode);
			local vx,vy,vz = getWorldTranslation(g_currentMission.player.rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < self.grainDoor.minDistance then
				self.grainDoor.inRange = true;
			else
				self.grainDoor.inRange = false;
			end;
		end;
	end;
	if self.tipState ~= Trailer.TIPSTATE_CLOSED then
		for a=1, table.getn(self.movingTools) do
			if self.movingTools[a].rotSpeed ~= nil then
				self.movingTools[a].rotSpeed = 0;
			end;
		end;
	else
		for a=1, table.getn(self.movingTools) do
			if self.movingTools[a].rotSpeed ~= nil then
				self.movingTools[a].rotSpeed = self.movingTools[a].rotSpeedBackup;
			end;
		end;
	end;
end;

function Koegel:draw()
	if not self.isGrainDoorOpen and self.grainDoor.allowOpening then
		g_currentMission:addExtraPrintText(g_i18n:getText("grainDoorTip"));
	end;
end;

function Koegel:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local isGrainDoorOpen = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isGrainDoorOpen"), false);
	self:toggleGrainDoor(isGrainDoorOpen);
	return BaseMission.VEHICLE_LOAD_OK;
end;

function Koegel:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'isGrainDoorOpen="' .. tostring(self.isGrainDoorOpen) .. '"';
	return attributes, nil;
end;

function Koegel:toggleGrainDoor(isOpen, noEventSend)
	ToggleGrainDoorEvent.sendEvent(self, isOpen, noEventSend);
	if isOpen then
		if self.grainDoor.animationName ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.grainDoor.animationName, 1, nil, true);
		end;
	else
		if self.grainDoor.animationName ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.grainDoor.animationName, -1, nil, true);
		end;
	end;
	self.isGrainDoorOpen = isOpen;
end;

function Koegel:getCanTip(oldFunc)
	if self.isAugerAttached then
		return false;
	else
		return oldFunc(self);
	end;
end;

function Koegel:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	if jointType == Vehicle.JOINTTYPE_AUGERCOUPLING then
		if jointIndex == 1 then
			self.isAugerAttached = true;
			self.grainDoor.allowOpening = true;
			if self.toggleTipSideCount ~= nil then
				self.toggleTipSideActive = false;
			end;
		end;
	end;
end;

function Koegel:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	if jointIndex == 1 then
		self.isAugerAttached = false;
		self.grainDoor.allowOpening = false;
		self.toggleTipSideActive = true;
	end;
end;

function Koegel:setIsSowingMachineFilling(isFilling, noEventSend)
	SowingMachineSetIsFillingEvent.sendEvent(self, isFilling, noEventSend)
	if self.isSowingMachineFilling ~= isFilling then
		self.isSowingMachineFilling = isFilling;
		self.sowingMachineFillTrigger = nil;
		if isFilling then
			for i, trigger in ipairs(self.sowingMachineFillTriggers) do
				if trigger:getIsActivatable(self) then
					self.sowingMachineFillTrigger = trigger;
					break;
				end;
			end;
		end
	end;
end;

function Koegel:addSowingMachineFillTrigger(trigger)
	if table.getn(self.sowingMachineFillTriggers) == 0 then
		g_currentMission:addActivatableObject(self.sowingMachineFillActivatable);
	end;
	table.insert(self.sowingMachineFillTriggers, trigger);
end;

function Koegel:removeSowingMachineFillTrigger(trigger)
	for i=1, table.getn(self.sowingMachineFillTriggers) do
		if self.sowingMachineFillTriggers[i] == trigger then
			table.remove(self.sowingMachineFillTriggers, i);
			break;
		end;
	end;
	if table.getn(self.sowingMachineFillTriggers) == 0 then
		if self.isServer then
			self:setIsSowingMachineFilling(false);
		end;
		g_currentMission:removeActivatableObject(self.sowingMachineFillActivatable);
	end;
end;

function Koegel:setIsSprayerFilling(isFilling, noEventSend)
	SprayerSetIsFillingEvent.sendEvent(self, isFilling, noEventSend)
	if self.isSprayerFilling ~= isFilling then
		self.isSprayerFilling = isFilling;
		self.sprayerFillTrigger = nil;
		if isFilling then
			for i, trigger in ipairs(self.sprayerFillTriggers) do
				if trigger:getIsActivatable(self) then
					self.sprayerFillTrigger = trigger;
					break;
				end;
			end;
		end
	end;
end;

function Koegel:addSprayerFillTrigger(trigger)
	if table.getn(self.sprayerFillTriggers) == 0 then
		g_currentMission:addActivatableObject(self.sprayerFillActivatable);
	end;
	table.insert(self.sprayerFillTriggers, trigger);
end;

function Koegel:removeSprayerFillTrigger(trigger)
	for i=1, table.getn(self.sprayerFillTriggers) do
		if self.sprayerFillTriggers[i] == trigger then
			table.remove(self.sprayerFillTriggers, i);
			break;
		end;
	end;
	if table.getn(self.sprayerFillTriggers) == 0 then
		if self.isServer then
			self:setIsSprayerFilling(false);
		end;
		g_currentMission:removeActivatableObject(self.sprayerFillActivatable);
	end;
end;

SowingMachineFillActivatable = {}
local SowingMachineFillActivatable_mt = Class(SowingMachineFillActivatable);

function SowingMachineFillActivatable:new(sowingMachine)
	local self = {};
	setmetatable(self, SowingMachineFillActivatable_mt);
	self.sowingMachine = sowingMachine;
	self.activateText = "unknown";
	return self;
end;

function SowingMachineFillActivatable:getIsActivatable()
	if self.sowingMachine:getIsActiveForInput() and self.sowingMachine.fillLevel < self.sowingMachine.capacity then
		for i,trigger in ipairs(self.sowingMachine.sowingMachineFillTriggers) do
			if trigger:getIsActivatable(self.sowingMachine) then
				self:updateActivateText();
				return true;
			end;
		end;
	end;
	return false;
end;

function SowingMachineFillActivatable:onActivateObject()
	self.sowingMachine:setIsSowingMachineFilling(not self.sowingMachine.isSowingMachineFilling);
	self:updateActivateText();
	g_currentMission:addActivatableObject(self);
end;

function SowingMachineFillActivatable:drawActivate()
end;

function SowingMachineFillActivatable:updateActivateText()
	if self.sowingMachine.isSowingMachineFilling then
		self.activateText = string.format(g_i18n:getText("stop_refill_OBJECT"), self.sowingMachine.typeDesc);
	else
		self.activateText = string.format(g_i18n:getText("buy_seeds"), self.sowingMachine.typeDesc);
	end;
end;

SprayerFillActivatable = {}
local SprayerFillActivatable_mt = Class(SprayerFillActivatable);

function SprayerFillActivatable:new(sprayer)
	local self = {};
	setmetatable(self, SprayerFillActivatable_mt);
	self.sprayer = sprayer;
	self.activateText = "unknown";
	return self;
end;

function SprayerFillActivatable:getIsActivatable()
	if self.sprayer:getIsActiveForInput() and self.sprayer.fillLevel < self.sprayer.capacity then
		for i,trigger in ipairs(self.sprayer.sprayerFillTriggers) do
			if trigger:getIsActivatable(self.sprayer) then
				self:updateActivateText();
				return true;
			end;
		end;
	end;
	return false;
end;

function SprayerFillActivatable:onActivateObject()
	self.sprayer:setIsSprayerFilling(not self.sprayer.isSprayerFilling);
	self:updateActivateText();
	g_currentMission:addActivatableObject(self);
end;

function SprayerFillActivatable:drawActivate()
end;

function SprayerFillActivatable:updateActivateText()
	if self.sprayer.isSprayerFilling then
		self.activateText = string.format(g_i18n:getText("stop_refill_OBJECT"), self.sprayer.typeDesc);
	else
		self.activateText = string.format(g_i18n:getText("buy_fertilizer"), self.sprayer.typeDesc);
	end;
end;


--
-- ToggleGrainDoorEvent
-- Networkevent for ToggleGrainDoor
--
-- @author:		JoPi
-- @date:		31/05/14
-- @version:	v1.0
-- @history:	v1.0 - initial version
--
-- free for noncommercial-usage

ToggleGrainDoorEvent = {};
ToggleGrainDoorEvent_mt = Class(ToggleGrainDoorEvent, Event);
InitEventClass(ToggleGrainDoorEvent, "ToggleGrainDoorEvent");

function ToggleGrainDoorEvent:emptyNew()
	local self = Event:new(ToggleGrainDoorEvent_mt);
	return self;
end;

function ToggleGrainDoorEvent:new(vehicle, isOpen)
	local self = ToggleGrainDoorEvent:emptyNew()
	self.vehicle = vehicle;
	self.isGrainDoorOpen = isOpen;
	return self;
end;

function ToggleGrainDoorEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isGrainDoorOpen = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function ToggleGrainDoorEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isGrainDoorOpen);
end;

function ToggleGrainDoorEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.vehicle);
	end;
	if self.vehicle ~= nil then
		self.vehicle:toggleGrainDoor(self.isGrainDoorOpen, true);
	end;
end;

function ToggleGrainDoorEvent.sendEvent(vehicle, isOpen, noEventSend)
	if isOpen ~= vehicle.isGrainDoorOpen then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(ToggleGrainDoorEvent:new(vehicle, isOpen), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(ToggleGrainDoorEvent:new(vehicle, isOpen));
			end;
		end;
	end;
end;