--
-- AugerPallet
-- Specialization for AugerPallet
--
-- @author:		JoPi
-- @date:		09/04/14
-- @version:	v1.0
-- @history:	v1.0 - initial version
--
-- free for noncommercial-usage

AugerPallet = {};

function AugerPallet.prerequisitesPresent(specializations)
	Vehicle.registerJointType("AugerCoupling");
	return true;
end;

function AugerPallet:load(xmlFile)
	self.auger = {};
	self.auger.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.augerPallet.auger#index"));
	local x,y,z = getTranslation(self.auger.node);
	self.auger.trans = {x,y,z};
	local rx,ry,rz = getRotation(self.auger.node);
	self.auger.rot = {rx,ry,rz};
	local atx,aty,atz = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.augerPallet.auger#attachTranslation"));
	self.auger.attachTrans = {atx,aty,atz};
	local arx,ary,arz = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.augerPallet.auger#attachRotation"));
	self.auger.attachRot = {arx,ary,arz};
	self.pallet = {};
	self.pallet.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.augerPallet.pallet#index"));
	self.pallet.collisionNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.augerPallet.pallet#collision"));
	self.pallet.collisionMask = getCollisionMask(self.pallet.collisionNode);
end;

function AugerPallet:delete()
end;

function AugerPallet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AugerPallet:keyEvent(unicode, sym, modifier, isDown)
end;

function AugerPallet:update(dt)
end;

function AugerPallet:draw()
end;

function AugerPallet:onAttach(attacherVehicle)
	setTranslation(self.auger.node, unpack(self.auger.attachTrans));
	setRotation(self.auger.node, unpack(self.auger.attachRot));
	setVisibility(self.pallet.node, false);
	setCollisionMask(self.pallet.collisionNode, 0);
end;

function AugerPallet:onDetach()
	setTranslation(self.auger.node, unpack(self.auger.trans));
	setRotation(self.auger.node, unpack(self.auger.rot));
	setVisibility(self.pallet.node, true);
	setCollisionMask(self.pallet.collisionNode, self.pallet.collisionMask);
end;