--
-- infoHud
-- Specialization for an extra information hud in the left bottom corner of the screen. Information can be added from anywere within the script by using the addStats and addInfoText functions
--
-- @author  Templaer
-- @date  31/08/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

infoHud = {};

function infoHud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function infoHud:load(xmlFile)
	self.addInfoText = SpecializationUtil.callSpecializationsFunction("addInfoText");
	self.addStats = SpecializationUtil.callSpecializationsFunction("addStats");

    self.hudInfoBasePosX = 0.833;
    self.hudInfoBaseWidth = 0.17;
    self.hudInfoBasePosY = 0.1725;
    self.hudInfoBaseHeight = 0.72;

	self.infoPanelPath = Utils.getFilename("hud_info.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
	
	self.infoButtonTexts = {};
	self.showHudInfoBase = true;
	self.statisticsMode = false;
end;

function infoHud:delete()
    if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
end;

function infoHud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function infoHud:keyEvent(unicode, sym, modifier, isDown)
end;

function infoHud:update(dt)
    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.TOGGLEHUD) then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
		
		if InputBinding.hasEvent(InputBinding.STATISTICS) then
		    self.statisticsMode = not self.statisticsMode;
		end;
	end;
end;
	
function infoHud:addInfoText(button, text)
	table.insert(self.infoButtonTexts, {text=text, button=button});
end;

function infoHud:addStats(left, right)
	table.insert(self.infoButtonTexts, {left=left, right=right});
end;
	
function infoHud:draw()
	if self.showHudInfoBase and self.isEntered then
	
		local renderTextsLeft = {};
		local renderTextsRight = {};

		
		if not self.statisticsMode then
			self:addInfoText(InputBinding.TOGGLEHUD, g_i18n:getText("ToggleHud"));
		end;
		
		for i=1, table.getn(self.infoButtonTexts) do
			local button = self.infoButtonTexts[i].button;
			if button ~= nil then
				if InputBinding.getButtonName(button) ~= nil then
					table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " ..InputBinding.getButtonKeyName(button).." " .. g_i18n:getText("or") .. " " .. g_i18n:getText("Button") .. " "..InputBinding.getButtonName(button)..":"));
				else	
					table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " ..InputBinding.getButtonKeyName(button)..":"));
				end;	
				table.insert(renderTextsRight, self.infoButtonTexts[i].text);
			else
				table.insert(renderTextsLeft, self.infoButtonTexts[i].left);
				table.insert(renderTextsRight, self.infoButtonTexts[i].right);
			end;
		end;
		self.infoButtonTexts = {};
		
		if table.getn(renderTextsLeft) >= 1 then
			self.hudInfoBaseOverlay:render();
		end;
		
		local num = math.min(7, table.getn(renderTextsLeft));
		
		for i=1, num do
			local left = renderTextsLeft[i];
			local right = renderTextsRight[i];
			renderText(0.85, (7-i)*0.03+(0.44), 0.025, left);
			renderText(0.85, (7-i)*0.03+(0.41), 0.025, right);
		end;
	end;
end;

