K700A3 = {};

function K700A3.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function K700A3:load(xmlFile)
	self.drehzahlnadel3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drehzahlnadel3#index"));
	self.tachonadel3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tachonadel3#index"));
	self.fensterOpen = false;
end;

function K700A3:delete()
end;

function K700A3:readStream(streamId, connection)
end;

function K700A3:writeStream(streamId, connection)
end;

function K700A3:mouseEvent(posX, posY, isDown, isUp, button)
end;

function K700A3:keyEvent(unicode, sym, modifier, isDown)
end;

function K700A3:update(dt)
	if self.isMotorStarted then
        local kmh = math.min(5, math.max(0, self.lastSpeed*self.speedDisplayScale*15000));
        local rotateDrehzahlnadel3 = (((kmh / 25)*300) +1);
		local rotateTachonadel3 = (((kmh / 25)*-100) +50);
		setRotation(self.drehzahlnadel3, 0, 0, Utils.degToRad( rotateDrehzahlnadel3));
		setRotation(self.tachonadel3, 0, 0, Utils.degToRad( rotateTachonadel3));
    else
        setRotation(self.drehzahlnadel3, 0, 0, 0);
        setRotation(self.tachonadel3, 0, 0, 0);
    end;	
end;

function K700A3:draw()
end;

function K700A3:validateAttacherJoint(implement, jointDesc, dt)
end;

function K700A3:onLeave()
end;

function K700A3:onEnter()
end;
