K700A = {};

function K700A.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function K700A:load(xmlFile)
	self.drehzahlnadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drehzahlnadel#index"));
	self.tachonadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tachonadel#index"));
	self.fensterOpen = false;
end;

function K700A:delete()
end;

function K700A:readStream(streamId, connection)
end;

function K700A:writeStream(streamId, connection)
end;

function K700A:mouseEvent(posX, posY, isDown, isUp, button)
end;

function K700A:keyEvent(unicode, sym, modifier, isDown)
end;

function K700A:update(dt)
	if self.isMotorStarted then
        local kmh = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
        local rotateDrehzahlnadel = (((kmh / 25)*18) +20);
		local rotateTachonadel = (((kmh / 25)*92) -1);
		  setRotation(self.drehzahlnadel, 0, 0, Utils.degToRad( rotateDrehzahlnadel));
		  setRotation(self.tachonadel, 0, 0, Utils.degToRad( rotateTachonadel));
    else
        setRotation(self.drehzahlnadel, 0, 0, 0);
        setRotation(self.tachonadel, 0, 0, 0);
    end;	
end;

function K700A:draw()
end;

function K700A:validateAttacherJoint(implement, jointDesc, dt)
end;

function K700A:onLeave()
end;

function K700A:onEnter()
end;
