K700A2 = {};

function K700A2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function K700A2:load(xmlFile)
	self.drehzahlnadel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drehzahlnadel2#index"));
	self.tachonadel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tachonadel2#index"));
	self.fensterOpen = false;
end;

function K700A2:delete()
end;

function K700A2:readStream(streamId, connection)
end;

function K700A2:writeStream(streamId, connection)
end;

function K700A2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function K700A2:keyEvent(unicode, sym, modifier, isDown)
end;

function K700A2:update(dt)
	if self.isMotorStarted then
        local kmh = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
        local rotateDrehzahlnadel2 = (((kmh / 25)*11) +48);
		local rotateTachonadel2 = (((kmh / 25)*11) -1);
		setRotation(self.drehzahlnadel2, 0, 0, Utils.degToRad( rotateDrehzahlnadel2));
		setRotation(self.tachonadel2, 0, 0, Utils.degToRad( rotateTachonadel2));
    else
        setRotation(self.drehzahlnadel2, 0, 0, 0);
        setRotation(self.tachonadel2, 0, 0, 0);
    end;	
end;

function K700A2:draw()
end;

function K700A2:validateAttacherJoint(implement, jointDesc, dt)
end;

function K700A2:onLeave()
end;

function K700A2:onEnter()
end;
