--
-- Sound
-- Specialization for a different exterior and interior sound on vehicles
--
-- @author  Templaer
-- @date  18/11/09
--

Sound = {};

function Sound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Sound:load(xmlFile)
	self.swapSounds = SpecializationUtil.callSpecializationsFunction("swapSounds");

	self.outdoorCamera = true;
	self.isCameraChanged = false;
	self.requiresSound = true;
	self.Sound = true;

    local externalStartSound = getXMLString(xmlFile, "vehicle.motorStartSound#file");
    if externalStartSound ~= nil and externalStartSound ~= "" then
        externalStartSound = Utils.getFilename(externalStartSound, self.baseDirectory);
        self.externalStartSound = createSample("externalStartSound");
        loadSample(self.externalStartSound, externalStartSound, false);
    end;

    local externalStopSound = getXMLString(xmlFile, "vehicle.motorStopSound#file");
    if externalStopSound ~= nil and externalStopSound ~= "" then
        externalStopSound = Utils.getFilename(externalStopSound, self.baseDirectory);
        self.externalStopSound = createSample("externalStopSound");
        loadSample(self.externalStopSound, externalStopSound, false);
    end;

    local externalSound = getXMLString(xmlFile, "vehicle.motorSound#file");
    if externalSound ~= nil and externalSound ~= "" then
        externalSound = Utils.getFilename(externalSound, self.baseDirectory);
        self.externalSound = createSample("externalSound");
        loadSample(self.externalSound, externalSound, false);
    end;

    local externalSoundRun = getXMLString(xmlFile, "vehicle.motorSoundRun#file");
    if externalSoundRun ~= nil and externalSoundRun ~= "" then
        externalSoundRun = Utils.getFilename(externalSoundRun, self.baseDirectory);
        self.externalSoundRun = createSample("externalSoundRun");
        loadSample(self.externalSoundRun, externalSoundRun, false);
    end;



    local internalStartSound = getXMLString(xmlFile, "vehicle.internalStartSound#file");
    if internalStartSound ~= nil and internalStartSound ~= "" then
        internalStartSound = Utils.getFilename(internalStartSound, self.baseDirectory);
        self.internalStartSound = createSample("internalStartSound");
        loadSample(self.internalStartSound, internalStartSound, false);
    end;

    local internalStopSound = getXMLString(xmlFile, "vehicle.internalStopSound#file");
    if internalStopSound ~= nil and internalStopSound ~= "" then
        internalStopSound = Utils.getFilename(internalStopSound, self.baseDirectory);
        self.internalStopSound = createSample("internalStopSound");
        loadSample(self.internalStopSound, internalStopSound, false);
    end;

    local internalSound = getXMLString(xmlFile, "vehicle.internalSound#file");
    if internalSound ~= nil and internalSound ~= "" then
        internalSound = Utils.getFilename(internalSound, self.baseDirectory);
        self.internalSound = createSample("internalSound");
        loadSample(self.internalSound, internalSound, false);
    end;

    local internalSoundRun = getXMLString(xmlFile, "vehicle.internalSoundRun#file");
    if internalSoundRun ~= nil and internalSoundRun ~= "" then
        internalSoundRun = Utils.getFilename(internalSoundRun, self.baseDirectory);
        self.internalSoundRun = createSample("internalSoundRun");
        loadSample(self.internalSoundRun, internalSoundRun, false);
    end;


end;

function Sound:delete()
end;

function Sound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Sound:keyEvent(unicode, sym, modifier, isDown)

end;

function Sound:update(dt)
	if self.isEntered then
		if not g_currentMission.fixedCamera then
			if InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) then
				self.outdoorCamera = not self.outdoorCamera;
			end;

			if self.outdoorCamera or self.isFrontWindowOpen or self.isLeftDoorOpen or self.isRightDoorOpen then
				self.requiresSound = true;
			else
				self.requiresSound = false;
			end;

			if not self.Sound and self.requiresSound or self.Sound and not self.requiresSound then
				self:swapSounds();
			end;
		else
			if not self.Sound then
				self:swapSounds();
			end;
		end;
	end;

end;

function Sound:onEnter()
	self.outdoorCamera = true;
end;

function Sound:draw()
end;

function Sound:swapSounds()
	-- Stop the sounds
	if self.isMotorStarted then
		stopSample(self.motorSound);
		stopSample(self.motorSoundRun);

	end;
	if self.stopThreshing then
		stopSample(self.threshingSound);
	end;
	-- Swap the sounds
	if not self.Sound then
		self.motorStartSound = self.externalStartSound;
		self.motorStopSound = self.externalStopSound;
		self.motorSound = self.externalSound;
		self.motorSoundRun = self.externalSoundRun;
		self.Sound = true;
	else
		self.motorStartSound = self.internalStartSound;
		self.motorStopSound = self.internalStopSound;
		self.motorSound = self.internalSound;
		self.motorSoundRun = self.internalSoundRun;
		self.Sound = false;
	end;

	-- Start the sounds again
	if self.isMotorStarted then
		playSample(self.motorSound, 0, 1, 0);
		playSample(self.motorSoundRun, 0, 1, 0);
		self.playMotorSound = true;
	end;
	if self.isThreshing then
		playSample(self.threshingSound, 0, 1, 0);

		end;
	if self.ThreshingActive then
	playSample(self.BatteurSoundId, 0, 1, 0);
	end;
end;

