--author: igor29381
--string for xml: <AutomaticPlasticPlane index="here is index of plastic plane" />


AutomaticPlasticPlane = {};

function AutomaticPlasticPlane.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function AutomaticPlasticPlane:load(xmlFile)

	local AutoPPIndex = getXMLString(xmlFile, "vehicle.AutomaticPlasticPlaneClose#index");
	if AutoPPIndex ~= nil then
		self.AutoPP = Utils.indexToObject(self.components, AutoPPIndex);
	end;
	self.AutoPPState = false;

	local AutoPP2Index = getXMLString(xmlFile, "vehicle.AutomaticPlasticPlaneOpen#index");
	if AutoPP2Index ~= nil then
		self.AutoPP2 = Utils.indexToObject(self.components, AutoPP2Index);
	end;
	self.AutoPP2State = true;

	self.lastFillLevel = self.fillLevel;
end;

function AutomaticPlasticPlane:delete()
end;

function AutomaticPlasticPlane:readStream(streamId, connection)
end;

function AutomaticPlasticPlane:writeStream(streamId, connection)
end;

function AutomaticPlasticPlane:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AutomaticPlasticPlane:keyEvent(unicode, sym, modifier, isDown)
end;

function AutomaticPlasticPlane:update(dt)
	if self.AutoPP ~= nil then
	if self.AutoPP2 ~= nil then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self.AutoPPState = not self.AutoPPState;
			self.AutoPP2State = not self.AutoPP2State;
		end;
		local FL = string.format("%1.0f", self.fillLevel);
		local LFL = string.format("%1.0f", self.lastFillLevel);
		if FL ~= LFL or not self.AutoPPState then
			setVisibility(self.AutoPP, false);
			setVisibility(self.AutoPP2, true);
		else
			setVisibility(self.AutoPP, true);
			setVisibility(self.AutoPP2, false);
		end;
		if self.tipState ~= Trailer.TIPSTATE_CLOSED then
			setVisibility(self.AutoPP, false);
			setVisibility(self.AutoPP2, true);
		end;
		self.lastFillLevel = self.fillLevel;
	end;
	end;
end;

function AutomaticPlasticPlane:updateTick(dt)
end;

function AutomaticPlasticPlane:draw()
          if self.AutoPPState then
              g_currentMission:addExtraPrintText(string.format(g_i18n:getText("tentOpen")));
          else
              g_currentMission:addExtraPrintText(string.format(g_i18n:getText("tentClose")));
          end;
end;