--
-- Play Animation 
-- Northern_Strike
-- 

playanim = {};

function playanim.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function playanim:load(xmlFile)
	self.SetDoorPanel = SpecializationUtil.callSpecializationsFunction("SetDoorPanel"); 
	self.DoorPanel = true;	
end;

function playanim:delete()
end;

function playanim:readStream(streamId, connection)
    self:SetDoorPanel(streamReadBool(streamId), true);
end;

function playanim:writeStream(streamId, connection)
    streamWriteBool(streamId, self.DoorPanel);
end;

function playanim:mouseEvent(posX, posY, isDown, isUp, button)
end;

function playanim:keyEvent(unicode, sym, modifier, isDown)
end;

function playanim:update(dt)
if self.inrange then
		if InputBinding.hasEvent(InputBinding.DOOR) then
			self:SetDoorPanel(not self.DoorPanel);
		end;

	if self.inrange then
		if self.DoorPanel then
			self:setAnimationTime(1, self.animationParts[1].offSet);
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_4"), InputBinding.DOOR);
		else
			self:setAnimationTime(1, self.animationParts[1].animDuration);
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_5"), InputBinding.DOOR);
		end;
	end;

end;
end;

function playanim:updateTick(dt)
	if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function playanim:draw()
end;

function playanim:onLeave()
	
end;

function playanim:SetDoorPanel(isDoorPanel,noEventSend)
	SetDoorPanelEvent.sendEvent(self, isDoorPanel, noEventSend);
	if isDoorPanel then
		self.DoorPanel = true;
	else
		self.DoorPanel = false;
	end;
end;