T150 = {};

function T150.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function T150:load(xmlFile)
    self.ativarlimpador1 = false;
	self.lpd1 = 650;
	self.ativarlimpador2 = false;
	self.lpd2 = 650;
   
	local rotationPartNodelimpador1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.limpador1#index"));
    if rotationPartNodelimpador1 ~= nil then
        self.limpador1 = {};
        self.limpador1.node = rotationPartNodelimpador1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.limpador1#minRot"));
        self.limpador1.minRot = {};
        self.limpador1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.limpador1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.limpador1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.limpador1#maxRot"));
        self.limpador1.maxRot = {};
        self.limpador1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.limpador1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.limpador1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.limpador1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.limpador1#rotTime"), 2)*1000;
        self.limpador1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.limpador1#touchRotLimit"), 10));
    end;
	local rotationPartNodelimpador2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.limpador2#index"));
    if rotationPartNodelimpador2 ~= nil then
        self.limpador2 = {};
        self.limpador2.node = rotationPartNodelimpador2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.limpador2#minRot"));
        self.limpador2.minRot = {};
        self.limpador2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.limpador2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.limpador2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.limpador2#maxRot"));
        self.limpador2.maxRot = {};
        self.limpador2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.limpador2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.limpador2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.limpador2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.limpador2#rotTime"), 2)*1000;
        self.limpador2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.limpador2#touchRotLimit"), 10));
    end;
    
	local rotacaoprecaofreio = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.precao_freio#index"));
    if rotacaoprecaofreio ~= nil then
        self.precaofreio = {};
        self.precaofreio.node = rotacaoprecaofreio;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.precao_freio#minRot"));
        self.precaofreio.minRot = {};
        self.precaofreio.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.precaofreio.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.precaofreio.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.precao_freio#maxRot"));
        self.precaofreio.maxRot = {};
        self.precaofreio.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.precaofreio.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.precaofreio.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.precaofreio.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.precao_freio#rotTime"), 2)*1000;
        self.precaofreio.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.precao_freio#touchRotLimit"), 10));
    end;
    
	local rotacaofreiodemao = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.freio_de_mao#index"));
    if rotacaofreiodemao ~= nil then
        self.freiodemao = {};
        self.freiodemao.node = rotacaofreiodemao;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.freio_de_mao#minRot"));
        self.freiodemao.minRot = {};
        self.freiodemao.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.freiodemao.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.freiodemao.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.freio_de_mao#maxRot"));
        self.freiodemao.maxRot = {};
        self.freiodemao.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.freiodemao.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.freiodemao.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.freiodemao.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.freio_de_mao#rotTime"), 2)*1000;
        self.freiodemao.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.freio_de_mao#touchRotLimit"), 10));
    end;
    
	local rotacaocontagiro = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.contagiro#index"));
		if rotacaocontagiro ~= nil then
        self.contagiro = {};
        self.contagiro.node = rotacaocontagiro;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.contagiro#minRot"));
        self.contagiro.minRot = {};
        self.contagiro.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.contagiro.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.contagiro.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.contagiro#maxRot"));
        self.contagiro.maxRot = {};
        self.contagiro.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.contagiro.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.contagiro.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.contagiro.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.contagiro#rotTime"), 2)*1000;
        self.contagiro.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.contagiro#touchRotLimit"), 10));
    end;
    
	local rotacaomarcadordeBAK = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BAK#index"));
    if rotacaomarcadordeBAK ~= nil then
        self.marcadordeBAK = {};
        self.marcadordeBAK.node = rotacaomarcadordeBAK;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.BAK#minRot"));
        self.marcadordeBAK.minRot = {};
        self.marcadordeBAK.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.marcadordeBAK.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.marcadordeBAK.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.BAK#maxRot"));
        self.marcadordeBAK.maxRot = {};
        self.marcadordeBAK.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.marcadordeBAK.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.marcadordeBAK.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.marcadordeBAK.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.BAK#rotTime"), 2)*1000;
        self.marcadordeBAK.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.BAK#touchRotLimit"), 10));
    end;
    
    local velocimetro = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.velocimetro#index"));
    if velocimetro ~= nil then
        self.velocimetro = {};
        self.velocimetro.node = velocimetro;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.velocimetro#minRot"));
        self.velocimetro.minRot = {};
        self.velocimetro.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.velocimetro.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.velocimetro.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.velocimetro#maxRot"));
        self.velocimetro.maxRot = {};
        self.velocimetro.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.velocimetro.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.velocimetro.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.velocimetro.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.velocimetro#rotTime"), 2)*1000;
        self.velocimetro.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.velocimetro#touchRotLimit"), 10));
    end;

   local rotacaoportadireita = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.portadireita#index"));
    if rotacaoportadireita ~= nil then
        self.portadireita = {};
        self.portadireita.node = rotacaoportadireita;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.portadireita#minRot"));
        self.portadireita.minRot = {};
        self.portadireita.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.portadireita.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.portadireita.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.portadireita#maxRot"));
        self.portadireita.maxRot = {};
        self.portadireita.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.portadireita.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.portadireita.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.portadireita.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.portadireita#rotTime"), 2)*1000;
        self.portadireita.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.portadireita#touchRotLimit"), 10));
    end;
	local rotacaoportaesquerda = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.portaesquerda#index"));
    if rotacaoportaesquerda ~= nil then
        self.portaesquerda = {};
        self.portaesquerda.node = rotacaoportaesquerda;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.portaesquerda#minRot"));
        self.portaesquerda.minRot = {};
        self.portaesquerda.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.portaesquerda.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.portaesquerda.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.portaesquerda#maxRot"));
        self.portaesquerda.maxRot = {};
        self.portaesquerda.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.portaesquerda.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.portaesquerda.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.portaesquerda.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.portaesquerda#rotTime"), 2)*1000;
        self.portaesquerda.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.portaesquerda#touchRotLimit"), 10));
    end;
end;    

function T150:keyEvent(unicode, sym, modifier, isDown)
    
	if isDown and sym == Input.KEY_7 then
		self.ativarlimpador1 = not self.ativarlimpador1;
	end;
	if isDown and sym == Input.KEY_7 then
		self.ativarlimpador2 = not self.ativarlimpador2;
	end;
    
	if isDown and sym == Input.KEY_space   then
			self.rotationMaxprecao_freio = not self.rotationMaxprecao_freio;
		end;
		if isDown and sym == Input.KEY_space   then
			self.rotationMaxfreio_de_mao = not self.rotationMaxfreio_de_mao;
		end;
    if isDown and sym == Input.KEY_KP_7 then 
		self.rotacaomaximaportadireita = not self.rotacaomaximaportadireita;
	end; 
	 if isDown and sym == Input.KEY_KP_8 then 
		self.rotacaomaximaportaesquerda = not self.rotacaomaximaportaesquerda;
	end;
 end;

function T150:update(dt)
    
	if self.ativarlimpador1 then
		self.lpd1 = self.lpd1 - dt;
		if self.lpd1 < 0 then
			self.rotacaomaximaesquerda = not self.rotacaomaximaesquerda;
			self.rotacaomaximalimpador1 = not self.rotacaomaximalimpador1;
			self.lpd1 = 650;
		end;
	end;
	if self.ativarlimpador2 then
		self.lpd2 = self.lpd2 - dt;
		if self.lpd2 < 0 then
			self.rotacaomaximaesquerda = not self.rotacaomaximaesquerda;
			self.rotacaomaximalimpador2 = not self.rotacaomaximalimpador2;
			self.lpd2 = 650;
		end;
	end;
	
	if self.limpador1 ~= nil then
		local x, y, z = getRotation(self.limpador1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.limpador1.maxRot, self.limpador1.minRot, 3, self.limpador1.rotTime, dt, not self.rotacaomaximalimpador1);
		setRotation(self.limpador1.node, unpack(newRot));
	end;
	if self.limpador2 ~= nil then
		local x, y, z = getRotation(self.limpador2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.limpador2.maxRot, self.limpador2.minRot, 3, self.limpador2.rotTime, dt, not self.rotacaomaximalimpador2);
		setRotation(self.limpador2.node, unpack(newRot));
	end;
    
	if self.precaofreio ~= nil then
			local x, y, z = getRotation(self.precaofreio.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.precaofreio.maxRot, self.precaofreio.minRot, 3, self.precaofreio.rotTime, dt, not self.rotationMaxprecao_freio);
			setRotation(self.precaofreio.node, unpack(newRot));
		end;
    
	if self.freiodemao ~= nil then
			local x, y, z = getRotation(self.freiodemao.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.freiodemao.maxRot, self.freiodemao.minRot, 3, self.freiodemao.rotTime, dt, not self.rotationMaxfreio_de_mao);
			setRotation(self.freiodemao.node, unpack(newRot));
		end;
    
	local maxrpmneedle = 900;
			if self.contagiro ~= nil then
				local x, y, z = getRotation(self.contagiro.node);
				y = ((self.contagiro.maxRot[2] - self.contagiro.minRot[2]) / maxrpmneedle) * (self.motor.lastMotorRpm/2.2) + self.contagiro.minRot[2];
				setRotation(self.contagiro.node, x, y ,z);
			end;
    
	local maxfuelguage = 315;
			if self.marcadordeBAK ~= nil then
				local x, y, z = getRotation(self.marcadordeBAK.node);
				y = ((self.marcadordeBAK.maxRot[2] - self.marcadordeBAK.minRot[2]) / maxfuelguage) * self.fuelFillLevel + self.marcadordeBAK.minRot[2];
				setRotation(self.marcadordeBAK.node, x, y ,z);
			end;

    local maxKmh = 55;
	if self.velocimetro ~= nil then
		local x, y, z = getRotation(self.velocimetro.node);
		y = ((self.velocimetro.maxRot[2] - self.velocimetro.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.velocimetro.minRot[2];
		setRotation(self.velocimetro.node, x, y ,z);
	end;

    if self.portaesquerda ~= nil then
		   local x, y, z = getRotation(self.portaesquerda.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.portaesquerda.maxRot, self.portaesquerda.minRot, 3, self.portaesquerda.rotTime, dt, not self.rotacaomaximaportaesquerda);
		   setRotation(self.portaesquerda.node, unpack(newRot));
        end;

    if self.portadireita ~= nil then
		   local x, y, z = getRotation(self.portadireita.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.portadireita.maxRot, self.portadireita.minRot, 3, self.portadireita.rotTime, dt, not self.rotacaomaximaportadireita);
		   setRotation(self.portadireita.node, unpack(newRot));
        end;
        
end;

function T150:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function T150:draw()
end;

function T150:onEnter()
  
end;

function T150:onLeave()
 
end;

function T150:delete()

end;


function T150:mouseEvent(posX, posY, isDown, isUp, button)
end;