--
-- AnimatedParts
-- Class for animated parts
--
-- @author Templaer
-- @version 1.0
-- @date  08/08/10

AnimatedParts = {};

function AnimatedParts.prerequisitesPresent(specializations)
    return true;
end;

function AnimatedParts:load(xmlFile)

    self.setMoveDirection = SpecializationUtil.callSpecializationsFunction("setMoveDirection");

    local startMoveDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.foldingParts#startMoveDirection"), 1);
    self.startAnimTime = 0;
    if startMoveDirection > 0.1 then
        self.startAnimTime = 1;
    end;
    
    self.foldAnimTime = 0;
    self.maxFoldAnimDuration = 0.0001;

    self.foldingParts = {};
    local i=1;
    while true do
        local baseName = string.format("vehicle.foldingParts.foldingPart%d", i);
		local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#rootNode"));
        if rootNode == nil then
            break;
        end;

		local entry = {};
		entry.anchorActor = Utils.getNoNil(getXMLInt(xmlFile,  baseName.."#anchorActor"), 0);
		entry.animCharSet = 0;
		
		entry.animCharSet = getAnimCharacterSet(rootNode);
		if entry.animCharSet ~= 0 then
			local clip = getAnimClipIndex(entry.animCharSet, getXMLString(xmlFile, baseName.."#animationClip"));
			if clip >= 0 then
				assignAnimTrackClip(entry.animCharSet, 0, clip);
				setAnimTrackLoopState(entry.animCharSet, 0, false);
				entry.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#speedScale"), 1);
				entry.animDuration = getAnimClipDuration(entry.animCharSet, clip);
				self.maxFoldAnimDuration = math.max(self.maxFoldAnimDuration, entry.animDuration);

				table.insert(self.foldingParts, entry);
			end;
		end;
        i = i+1;
    end;

    self.foldMoveDirection = startMoveDirection;

    AnimatedParts.setAnimTime(self, self.startAnimTime)
end;

function AnimatedParts:delete()
end;

function AnimatedParts:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

    AnimatedParts.setAnimTime(self, self.startAnimTime)
    return BaseMission.VEHICLE_LOAD_OK;
end;

function AnimatedParts:setRelativePosition(positionX, offsetY, positionZ, yRot)
    AnimatedParts.setAnimTime(self, self.startAnimTime);
end;

function AnimatedParts:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimatedParts:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimatedParts:update(dt)

    if self:getIsActive() then
        for k,foldingPart in pairs(self.foldingParts) do
            local isInvalid = false;
            local charSet = foldingPart.animCharSet;
            if self.foldMoveDirection > 0.1 then
                local trackTime = getAnimTrackTime(charSet, 0);
                if trackTime < foldingPart.animDuration then
                    isInvalid = true;
                end;
                self.foldAnimTime = trackTime / self.maxFoldAnimDuration;
            elseif self.foldMoveDirection < -0.1 then
                local trackTime = getAnimTrackTime(charSet, 0);
                if trackTime > 0 then
                    isInvalid = true;
                end;
                self.foldAnimTime = trackTime / self.maxFoldAnimDuration;
            end;
        end;
        self.foldAnimTime = Utils.clamp(self.foldAnimTime, 0, 1);
    end;

    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
            if self.foldMoveDirection > 0.1 or (self.foldMoveDirection == 0 and self.foldAnimTime > 0.5) then
                self:setMoveDirection(-1)
            else
                self:setMoveDirection(1)
            end;
        end;
    end;
end;

function AnimatedParts:draw()
end;

function AnimatedParts:onDetach()
    if self.deactivateOnDetach then
        AnimatedParts.onDeactivate(self);
    end;
end;

function AnimatedParts:onLeave()
    if self.deactivateOnLeave then
        AnimatedParts.onDeactivate(self);
    end;
end;

function AnimatedParts:onDeactivate()
    self:setMoveDirection(0);
end;

function AnimatedParts:setMoveDirection(direction)
    self.foldMoveDirection = direction;
    for k,foldingPart in pairs(self.foldingParts) do
        local charSet = foldingPart.animCharSet;
        local speedScale = nil;
        if self.foldMoveDirection > 0.1 then
            speedScale = foldingPart.speedScale;
        elseif self.foldMoveDirection < -0.1 then
            speedScale = -foldingPart.speedScale;
        end;
        if speedScale ~= nil then
            if speedScale > 0 then
                if getAnimTrackTime(charSet, 0) < 0.0 then
                    setAnimTrackTime(charSet, 0, 0.0);
                end;
            else
                if getAnimTrackTime(charSet, 0) > foldingPart.animDuration then
                    setAnimTrackTime(charSet, 0, foldingPart.animDuration);
                end;
            end;
            setAnimTrackSpeedScale(charSet, 0, speedScale);
            enableAnimTrack(charSet, 0);
        else
            disableAnimTrack(charSet, 0);
        end;
    end;
end;

function AnimatedParts.setAnimTime(self, animTime)
    self.foldAnimTime = animTime;
    for k,foldingPart in pairs(self.foldingParts) do
        enableAnimTrack(foldingPart.animCharSet, 0);
        setAnimTrackTime(foldingPart.animCharSet, 0, animTime*foldingPart.animDuration, true);
        disableAnimTrack(foldingPart.animCharSet, 0);
    end;
end;
